#ifndef WALL_H
#define WALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/**  Wall class

*@brief Library to draw the thoroughfare of the copter
*@author Wu Aiming
*@date May 2019
*/

class Wall
{
public:
    
    /**Constructor*/
    Wall();
    /**Destructor*/
    ~Wall();
    /**
    *@brief Initialise all parameters of the Wall
    */
    void init();
    /**
    *@brief Input a mainfold
    */
    int* _ab;
    /**
    *@brief Draw the thoroughfare of the copter
    *@param lcd
    *@returns The boundary position of thoroughfare in (0,0)
    *@details Use the method to use function within N5110.h file
    */
    int* draw(N5110 &lcd);

private:

    int _a1;
    int _a2;
    int _a3;
    int _a4;
    int _a5;
    int _a6;
    int _a7;
    int _a8;
    int _a9;
    int _a10;
    int _a11;
    int _a12;
    int _b1;
    int _b2;
    int _b3;
    int _b4;
    int _b5;
    int _b6;
    int _b7;
    int _b8;
    int _b9;
    int _b10;
    int _b11;
    int _b12;
};
#endif

