#include "mbed.h"
#include "Timer.h"

int Medicion_tiempo();
void Selector_color();
void config_escala();

DigitalOut s0(PC_7);
DigitalOut s1(PA_9);
DigitalOut s2(PA_8);
DigitalOut s3(PB_10);
DigitalIn p_out(PB_4);

Timer tiempo;
int tim=0;
int escala;

int mcolor[3][2]={{0,0},{0,1},{1,1}};
int mesc_freq[3][2]={{0,1},{1,0},{1,1}};

Serial emisor(USBTX, USBRX);

int main() 
{
    emisor.printf("ingrese el tipo de escala de frecuencia \n");
    escala=emisor.getc();

    while(1) 
    {
        config_escala();
        Selector_color();
        Medicion_tiempo();
    }
}

int Medicion_tiempo()
{
    while(p_out){}
    tiempo.start();
    while(!p_out){}
    tiempo.stop();
    tim=tiempo.read_us();
    //emisor.printf("tiempo en mili segundos %i\n", tim);
    tiempo.reset();    

    return tim;
}

void Selector_color()
{
    for(int i =0;i<3;i++)
    {
        s2.write(mcolor[i][0]);
        s3.write(mcolor[i][1]);

        switch(i)
        {
            case 0:
               emisor.printf("Rojo %d ",Medicion_tiempo());
               break;
            case 1:
               emisor.printf("Azul %d ",Medicion_tiempo());
               break;
            case 2:
               emisor.printf("Verde %d \n",Medicion_tiempo());
               break;
        }
    }
}

void config_escala()
{
    s0.write(mesc_freq[escala - 1][0]);
    s1.write(mesc_freq[escala - 1][1]);
}