#include "mbed.h"
#include "Biquad.h"
#include "filtervalues.h"
#include "HIDScope.h"


DigitalOut led_red(LED_RED);

Serial pc(USBTX,USBRX);// serial connection to pc

Ticker      sample_timer;
HIDScope    scope( 2 );


Biquad myfilter1;// make filter for signal 1
Biquad myfilter2;//make filter for signal 2

AnalogIn emg1_input(A0);//input for first emg signal 1
AnalogIn emg2_input(A1);//input for first emg signal 2

volatile double filteredsignal1=0;//the first filtered emg signal 1
volatile double filteredsignal2=0;//the first filtered emg signal 2


void filtereverything(bool makeempty)
{
    //highpass  
    double pass1_emg1 = myfilter1.filter(emg1_input.read(), v1_f1_emg1 , v2_f1_emg1 , a1_f1 , a2_f1 , b0_f1 , b1_f1 , b2_f1);
    double pass1_emg2 = myfilter1.filter(emg2_input.read(), v1_f2_emg2 , v2_f1_emg2 , a1_f1 , a2_f1 , b0_f1 , b1_f1 , b2_f1);
    // take aboslute values    
    double pass2_emg1 = fabs(pass1_emg1);
    double pass2_emg2 = fabs(pass1_emg2);
    //lowpass   
    double pass3_emg1 = myfilter1.filter(pass2_emg1, v1_f2_emg1 , v2_f2_emg1 , a1_f2 , a2_f2 , b0_f2 , b1_f2 , b2_f2);
    double pass3_emg2 = myfilter1.filter(pass2_emg2, v1_f2_emg2 , v2_f2_emg2 , a1_f2 , a2_f2 , b0_f2 , b1_f2 , b2_f2);
    
    filteredsignal1 = pass1_emg1;
    filteredsignal2 = pass3_emg2;
    
    if (makeempty==true) {//this is needed so the filtered value is not high after shooting basically it resets the filter
        pass1_emg1 = pass2_emg1 = pass3_emg1 = 0;
        v1_f1_emg1 = v2_f1_emg1 = v1_f2_emg1 = v2_f2_emg1 = 0;
        pass1_emg2 = pass2_emg2 = pass3_emg2 = 0;
        v1_f1_emg2 = v2_f1_emg2 = v1_f2_emg2 = v2_f2_emg2 = 0;
    }
}

void scopedata()
{
    scope.set(0,emg1_input.read()); // 
    scope.set(1,filteredsignal1); // 
   
    scope.send(); // send info to HIDScope server
}

int main()
{
    sample_timer.attach(&scopedata, 0.002);
    pc.baud(115200);
    
    while (true) {
      
      filtereverything(false);
      
       if(filteredsignal1 > 0.8){
           led_red = 0;
           }
        else{
            led_red = 1;            
            }
            
       
    }
}