/*programma per simulare la ricezione dei segnali da parte del robot.
Il robot legge una sequenza di valori e riesce a capire se corrispondono a una sirena
oppure no. Se secondo lui i valori che li stanno arrivando corrispondono a una sirena allora si ferma*/

#include "mbed.h"
#include "rtos.h"

/*---PIN CONTROLLO MOTORI---*/
#define PWMB PC_7  //D9
#define DIRB D8    //D8

#define PWMA PB_4  //D5
#define DIRA D4    //D4
/*--------------------------*/

#define PIN_SIRENA D11

#define MIN_CHECK 50

void check_sirena_thread(void const *args);
void fermo();
void avanti();
void setup();

/*---CONTROLLO MOTORI---*/
PwmOut motorBpower(PWMB); //oggetti controllo motori
DigitalOut motorBdirection(DIRB);

PwmOut motorApower(PWMA);
DigitalOut motorAdirection(DIRA);
/*---------------------*/

Serial pc(USBTX, USBRX); //istanzio oggetto per utilizzo monitor seriale
bool flagSirena = true;
DigitalIn sirena(PIN_SIRENA);

int main() {
    
    Thread sirenaThread(check_sirena_thread); // start Thread controllo sirena
    
    setup();
    
    while(true){
        while(flagSirena){
            avanti();
        }
        fermo();
    }
}

void check_sirena_thread(void const *args) 
{
    int val, conta = 0, contaPrec, ctrl = 0;
    while(true) {
        for(int i = 0; i < 500 && ( conta < MIN_CHECK ) && ( ctrl < MIN_CHECK+60 ); i++){
            val = sirena.read();
            pc.printf("recived: %d \r\n",conta); //stampa a video
            conta = ( val == 1 ) ? conta+1 :  conta ;
            if( conta == contaPrec )
                ctrl++;
            contaPrec = conta;
            wait_ms(2);
        }
        flagSirena = ( conta >= MIN_CHECK ) ? false : true ;
        conta = 0;
        ctrl = 0;
        /*val = sirena.read();
        if( val == 1 )
            flagSirena = false;
        else
            flagSirena = true;*/
    }
}

void setup()
{
    motorBpower.period_ms(10); //setto periodo per impulsi da inviare ai motori ( consiglio di non variare )
    motorApower.period_ms(10); //setto periodo per impulsi da inviare ai motori ( consiglio di non variare )
    fermo();
}

void fermo()
{
    motorBpower.pulsewidth(0); // fermo
    motorApower.pulsewidth(0); // fermo
}

void avanti()
{
    motorBdirection = 1; 
    motorAdirection = 0;
    motorBpower.pulsewidth(0.01); // 100%
    motorApower.pulsewidth(0.01); // 100%
}
