#include "mbed.h"

// DigitalOut eine Variable für ein Bit
// BusOut eine Variable für eine ganze Bitgruppe
// Warum ist es sinnvolll dass die Variablen D20_D19_... heissen
// Zusammenhang der untenstehenden Deklarationen mit der Boardbeschreibung (Skript M0)

// Alle 12-Leds des M0-Boards zu einer Bitgruppe zusammenfassen

//        LSB                                                      MSB
//        2^0   2^1   2^2                                          2^11
BusOut lb(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//        D20   D19   D18  D17  D16  D15  D14  D13  D4   D3   D2   D1

void RunLight1();     // Lauflicht nach Links
void RunLight2();    // Lauflicht mit 1en nachschieben
void RunLight3();    // Lauflicht nach links ein und wieder aus
void RunLight4();    // Lauflicht nach links und rechts
void RunLight5();    // Lauflicht mit 3 LEDs weiterschieben

int main() {
    
    while(1)
    {
    //LedBarTest();
    //RunLight1();
    //RunLight2();
    //RunLight3();
    //RunLight4();
    RunLight5(); 
    }
}

void RunLight1()
{
    lb=1;                       //erstes Bit setzen
    for(int i = 1; i<=12;i++)  
    {
        wait_ms(100);
        lb = lb << 1;  //ein Bit nach links schieben
    }
}

void RunLight2()
{
    lb=1;                       //erstes Bit setzen
    for(int i = 1; i<=12;i++)
    {
        wait_ms(100);
        lb = (lb << 1) | 1;  //ein Bit nach links schieben und 1 Bit verodern
    }
}

void RunLight3()
{
    lb=1;                       //erstes Bit setzen
    for(int i = 1; i<=12;i++)
    {
        wait_ms(100);
        lb = (lb << 1) | 1;  //ein Bit nach links schieben und mit 1 verodern
    }
                                
    for(int i = 1; i<=12;i++)
    {
        wait_ms(100);
        lb = (lb << 1) | 0;  //ein Bit nach links schieben und mit 0 verodern
    }
}

void RunLight4()
{
    lb=1;                       //erstes Bit setzen
    for(int i = 1; i<=12;i++)
    {
        wait_ms(100);
        lb = (lb << 1) | 1;  //ein Bit nach links schieben und mit 1 verodern
    }
                               
    for(int i = 1; i<=12;i++)
    {
        wait_ms(100);
        lb = (lb >> 1) | 1;  //ein Bit nach rechts schieben und mit 1 verodern
    }
}

void RunLight5()
{
    lb=1;                       //erstes Bit setzen
    for(int i = 1; i<=2 ;i++) 
    {
        wait_ms(100);
        lb = (lb << 1) | 1;  //ein Bit nach links schieben und mit 1 verodern
    }
                               
    for(int i = 1; i<=2;i++)
    {
        wait_ms(100);
        lb = (lb << 1) | 0;  //ein Bit nach links schieben und mit 0 verodern
    }
}
