// switch blue LEDs LED1 .. LED4 with external interrupt functionality
/* 
3 classes
Timeout - Call a function after a specified delay
Ticker - Repeatedly call a function
Timer - Create, start, stop and read a timer
*/

#include "mbed.h"

Timeout toFlipper;
DigitalOut doLed1(LED1);
DigitalOut doLed2(LED2);
Ticker tickBlinker; 
DigitalOut doLed3(LED3);
Timer tMyTimer;
Serial pc(USBTX, USBRX); // tx, rx

// functions 
void flip() {
    doLed1 = !doLed1;
}

void blink() {
    doLed3 = !doLed3;
}
 
int main() {
    doLed2 = 1;
    toFlipper.attach(&flip, 2.0);     // setup flipper to call flip after 2 seconds
    tickBlinker.attach(&blink, 0.5);    // setup blinker to call blink avery 500 msec
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        tMyTimer.reset();
        tMyTimer.start();
        pc.printf("Hello Timer-World!   ");
        doLed1 = !doLed1;
        wait(1.0);
        tMyTimer.stop();
        pc.printf("The time taken was %f seconds\r", tMyTimer.read());    
    }
}