#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

AnalogIn Kanal1(p19);
AnalogIn Kanal2(p20);

InterruptIn iiDown(p12);
InterruptIn iiUp(p15);

DigitalOut LED(LED1);

float Wert1 = 0;

Ticker tick1;

void lesen1()
{
    Wert1 = (Kanal1.read()*2000);

    LED = !LED;

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Messung gestartet");
    lcd.locate(0,15);
    lcd.printf("Drehzahl: %f RPM", Wert1);
}

void messen()
{
    tick1.attach(lesen1, 0.2);

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Messung gestartet");
}

void stoppen()
{
    tick1.detach();

    //LED = 0;

    lcd.cls();
    lcd.locate(0,15);
    lcd.printf("Drehzahlmessung");
    lcd.locate(0,0);
    lcd.printf("Messung gestoppt");
}



int main()
{

    iiUp.rise(messen);
    iiDown.rise(stoppen);

    stoppen();

    while(1) {

    }
}