#include "mbed.h"

#include "C12832.h"

// C12832 lcd(p5, p7, p6, p8, p11);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn aiPoti1(p19);
AnalogIn aiPoti2(p20);      // p20 oder p31

InterruptIn iiJsCenter(p14);
InterruptIn iiJsUp(p15);
InterruptIn iiJsDown(p12);
InterruptIn iiJsRight(p16);
InterruptIn iiJsLeft(p13);


int start = 0;      
float poti1Wert;
float poti2Wert;
float summe;

void lesen1()
{
    poti1Wert = (aiPoti1.read()*100)-39;
}

void lesen2()
{
    poti2Wert = (aiPoti2.read()*19.5)+1.5;
}

void go()
{
    
    if(start == 0)
    {
    lcd.locate(100,10);          
    lcd.printf("GO");
    start = 1;
    }
}

void addieren()
{
    if(start == 1) 
    {
        lesen1();
        lesen2();
        summe = poti1Wert + poti2Wert;
        lcd.cls();
        lcd.locate(0,00);
        lcd.printf("Poti1 = %.1f Poti2 = %.1f", poti1Wert, poti2Wert);
        lcd.locate(0,10);          
        lcd.printf("Plus: %.1f ", summe);
    }
}

void subtrahieren()
{
     if(start == 1) 
    {
        lesen1();
        lesen2();
        summe = poti1Wert - poti2Wert;
        lcd.cls();
        lcd.locate(0,00);
        lcd.printf("Poti1 = %.1f Poti2 = %.1f", poti1Wert, poti2Wert);
        lcd.locate(0,10);          
        lcd.printf("Minus: %.1f ", summe);
    }
}

void multiplizieren()
{
    if(start == 1) 
    {
        lesen1();
        lesen2();
        summe = poti1Wert * poti2Wert;
        lcd.cls();
        lcd.locate(0,00);
        lcd.printf("Poti1 = %.1f Poti2 = %.1f", poti1Wert, poti2Wert);
        lcd.locate(0,10);          
        lcd.printf("Multiplizieren: %.1f ", summe);
    }
}

void dividieren()
{
    if(start == 1) 
    {
        lesen1();
        lesen2();
        summe = poti1Wert / poti2Wert;
        lcd.cls();
        lcd.locate(0,00);
        lcd.printf("Poti1 = %.1f Poti2 = %.1f", poti1Wert, poti2Wert);
        lcd.locate(0,10);          
        lcd.printf("Division: %.1f ", summe);
    }
}

int main() {

    lcd.cls();                  
    lcd.locate(0,0);           
    lcd.printf("Poti-Calculator");
    lcd.locate(0,10);          
    lcd.printf("Christian Weiss");
    wait_ms(300);
    
    while(1) 
    {
       iiJsCenter.rise(&go);   
       iiJsUp.rise(&addieren); 
       iiJsDown.rise(&subtrahieren);  
       iiJsRight.rise(&multiplizieren);
       iiJsLeft.rise(&dividieren);
    }
}
