#include "mbed.h"
#include "C12832.h"

DigitalOut Led1(LED1, 0);
DigitalOut Led2(LED2, 0);
DigitalOut Led3(LED3, 0);
DigitalOut Led4(LED4, 0);
InterruptIn  SW1(p14);
InterruptIn  SW2(p15); 
InterruptIn  SW3(p12); 
InterruptIn  SW4(p16); 

//***** LCD *******

C12832 lcd(p5, p7, p6, p8, p11);

//***** VARIABLEN ******

enum State {ST_AUS=0, ST_EIN};
State state;

bool pressed = false;


//***** EREIGNISSE ******
 
void rise(void)
{  
    wait_ms(50);
    pressed = true;
}

bool CheckFlag() 
{
    if (pressed) {
        pressed=false;
        return true;
        }
    return false;
}

//***** STATES ******

void ST_Aus (void)
{
    //Status auf LCD
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 1 (Aus)");
    // entry
    
    // do
    while(true) {
        Led1 = 0;
    
        if(CheckFlag()) {
            state = ST_EIN;
            
    // exit
            return;
            }
        }
}

void ST_Ein (void)
{
    //Status auf LCD
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 2 (Ein)");
    
    // entry
    Led4 = 1;
    wait_ms(200);
    Led4 = 0;
    wait_ms(200);
    Led4 = 1;
    wait_ms(200);
    Led4 = 0;
    wait_ms(200);
    // do
    while(true) {
        Led1 = 1;
    
        if(CheckFlag()) {
            state = ST_AUS;
            
    // exit
            return;
            }
        }
    
}

void ST_Error (void)
{
    //Status auf LCD
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: ERROR");
    return;
}

void stateMachine()
{
    switch (state)
    {
    case ST_AUS: ST_Aus();
        break;
    case ST_EIN: ST_Ein();
        break;
    default: ST_Error();  // sollte nicht auftreten :-)
        break;
    }
}


 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    state = ST_AUS;
    while(true){
        stateMachine(); 
        }
    
    
}