#include "mbed.h"
#include "Serial_HL.h"
#include "MMA7660.h"
#include "TP1.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

// V2.0
// BusOut leds(LED1,LED2,LED3,LED4); Bertl14
// M0-Board
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);


void CommandHandler();

MMA7660 accel(p28, p27);

// 3 Filter anlegen
TP1Ord tpx, tpy, tpz;
int accVal[3];

void Do100Hz_Work();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);


    ua0.SvMessage("AccelTest"); // Meldung zum PC senden

    accel.setSampleRate(120);

    Timer stw;
    stw.start();
 

    while(1) {
        CommandHandler();
        if (stw.read_ms()>10) { // 100Hz
            stw.reset();
            Do100Hz_Work();
            if(ua0.acqON) {
                ua0.WriteSvI16(1, accVal[0]); // X,Y,Z zum PC senden
                ua0.WriteSvI16(2, tpx.y);                
                //ua0.WriteSvI16(3, accVal[1]);
                //ua0.WriteSvI16(4, tpy.y);
            }
        }
    }
}




void Do100Hz_Work()
{
    accel.readData(accVal); // X,Y,Z vom Sensor lesen
    tpx.CalcOneStep (accVal[0]);
    tpy.CalcOneStep (accVal[1]);
    tpz.CalcOneStep (accVal[2]);
    
}


void CommandHandler()
{
    uint8_t cmd;

    if( !pc.IsDataAvail() )
        return;

    cmd = ua0.GetCommand();

}


