#include "mbed.h"
#include "Serial_HL.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

// V2.0

BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

PwmOut LR(p23);
PwmOut LG(p24);
PwmOut LB(p25);


void CommandHandler();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);
    leds = 9;


    // PWM-Periode = 1ms = 1kHz
    LR.period_ms (1); LG.period_ms (1); LB.period_ms (1);

    // LR = 0.1;  10% Pulsweite   LR=0.9; 90% Pulsweite

    LR = (1-0.1); // 10% für invertierte Logik
    LG = (1-0.1); LB = (1-0.1);

    ua0.SvMessage("RGB1_2"); // Meldung zum PC senden

    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( ua0.acqON && (stw.read_ms()>100) ) { // 10Hz
            // dieser Teil wird mit 10Hz aufgerufen
            stw.reset();

            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde wird auch etwas gesendet

            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;

    if( !pc.IsDataAvail() )
        return;
    cmd = ua0.GetCommand();

    if( cmd == 2) 
    {
        LR = (1- ua0.ReadF()); LG = (1- ua0.ReadF()); LB = (1- ua0.ReadF());
        ua0.SvMessage("Set RGB1");
    }
    
    // Commands für Regler
    
    if( cmd == 3) 
    {
        LR = (1- ua0.ReadF());
        
    }

    if( cmd == 4) 
    {
        LG = (1- ua0.ReadF());        
    }


    if( cmd == 5) 
    {
        LB = (1- ua0.ReadF());        
    }
}


