#include "mbed.h"



InterruptIn iiUp(p15);
DigitalIn diUp(p15);

InterruptIn iiDown(p12);
DigitalIn diDown(p12);

BusOut leds(LED1, LED2, LED3, LED4);

// prototypes

// functions
// Diese Funktion ist zum Entprellen von Tastern geeignet:
// Durch den zusätzlichen Code kann eine Entprellzeit von durchschnittlich 1,5-4ms
// (mindestens 8*150us = 1,2ms) erreicht werden.
// Grundsätzlich prüft die Funktion den Pegel des Pins eines DigitalIn.
// Wenn der Pegel 8 Mal konstant war, wird die Schleife verlassen.
// Diese Funktion kann sehr gut eingesetzt werden, um in einer Endlosschleife Taster
// anzufragen, da sie, wie erwähnt, eine kurze Wartezeit hat.
uint8x_t debounce(DigitalIn myIn)
{
#define LEVEL_CHECKS 8
#define MAX_LOOPS 30                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8x_t loopCounter = 0;

    do {
        port_buffer = myIn;
        wait_us(150);
        loopCounter++;
        if(myIn == port_buffer)
            debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
            debounceCounter = 0;
    } while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}

// ISR
void cntUp()
{
    debounce(diUp);
    leds = leds + 1;
}

void cntDown()
{
    debounce(diDown);
    leds = leds - 1;
}


// main program
int main()
{
    iiUp.rise(&cntUp);
    iiDown.rise(&cntDown);
    while(1) {
    }
}
