#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                                      MSB
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

// Statusled zeigt uns in welchem Zustand die Statemachine gerade ist
BusOut stLED(P1_13,P1_12);

// BtnEventM0 erledigt für uns die Abfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw3(P0_23);
// sw4==forward sw3==backward


class Fahrradleuchte
{
    public:
        void Init();
    // Funktionen, die auch außerhalb einer Klasse aufgerufen werden können
        void State1Func();
        void State2Func();
        void State3Func();
    public:
    // Aktionen, die auch von außen aufgerufen werden können
        void State1Action(); // Bit2 (LED) mit 10Hz blinken
        void State2Action(); // Bit4 (LED) mit 5Hz blinken
        void State3Action(); // Bit6 (LED) mit 2Hz blinken
    public:
        int state; // state sagt uns in welchem Zustand sich die Fahrradleuchte gerade befindet
    private:
        Timer t1; // Kann nur in dieser Klasse aufgerufen werden
};

Fahrradleuchte fl; // eine Fahrradleuchte anlegen

int main(void)
{
    sw4.Init(); sw3.Init();
    fl.Init();
    while(1)
    {
        if(fl.state==1)
            fl.State1Func();
        if(fl.state==2)
            fl.State2Func();
        if(fl.state==3)
            fl.State3Func();
    }
}

void Fahrradleuchte::Init()
{
    t1.start(); state = 1;
}

void Fahrradleuchte::State1Func()
{
    // Einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 1; // Anzeigen das wir im State1 sind
    
    while(1)
    {
        State1Action();
            // Btn's abfragen und möglicherweise Zustand ändern
            if(sw4.CheckFlag())
                {
                    state = 2; return;
                }
            if(sw3.CheckFlag())
                {
                    state = 3; return;
                }
    }
}

void Fahrradleuchte::State1Action()
{
    if(t1.read_ms()>100) //10Hz
        {
            t1.reset();   
                if(lb==0)
                    lb = 2;
                else
                    lb = 0;
        }
        
}

void Fahrradleuchte::State2Action()
{
    if(t1.read_ms()>200) //5Hz
        {
            t1.reset();   
                if(lb==0)
                    lb = 4;
                else
                    lb = 0;
        }
        
}

void Fahrradleuchte::State3Action()
{
    if(t1.read_ms()>500) //2Hz
        {
            t1.reset();   
                if(lb==0)
                    lb = 8;
                else
                    lb = 0;
        }
        
}







