
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);
AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15

// Alle Funktionen die den Bertl bewegen werden mit
// ausgeschalteten Motoren betreten und mit ausgeschalteten Motoren
// wieder verlassen

void ForewardUntilWall();

void SomeStepsBack();

void TurnLeft();

void TurnRight();

void FrontBlinkerTask();

void BackBlinkerTask();

int direction = 0; //0= zurück, 1 = vorwärts

Timer t1;


int main(void)
{
    boardPow=3; wait_ms(10);
    InitBertl(); leds=9;
    pex.ClearLeds();
    t1.start();
    
    
    while(1)
    {
        ForewardUntilWall();
        FrontBlinkerTask();
        BackBlinkerTask();
                      
    }
    
    return 1;
}

void ForewardUntilWall()
{
     
    if(ls1.Read()<600)
    {
            mL.SetPow2(0.3);
            mR.SetPow2(0.25); 
            direction = 1;                
    }
    else if(ls1.Read()>600)
    {
            mL.SetPow2(0.0);
            mR.SetPow2(0.0);
            wait_ms(1000);
            SomeStepsBack();            
            wait_ms(1000);
            TurnRight();   
    }
    else if(ls4.Read()<600)
    {
            mL.SetPow2(0.3);
            mR.SetPow2(0.25);
            direction = 1;            
            
    }
    else if(ls4.Read()>600)
    {
            mL.SetPow2(0.0);
            mR.SetPow2(0.0);
            wait_ms(1000);
            SomeStepsBack();
            wait_ms(1000);
            TurnLeft();  
    }
}

void SomeStepsBack()
{
    // Motoren auf rückwärts
              
            mL.SetPow2(-0.2);
            mR.SetPow2(-0.2);            
            direction = 0;  
            wait_ms(800);            
    // Motoren ausschalten
            mL.SetPow2(0.0);
            mR.SetPow2(0.0);
 
}

void TurnLeft()
{
            
            mL.SetPow(0.0); mR.SetPow(0.4);//linkskurve            
            wait_ms(300);
            mL.SetPow2(0.0);
            mR.SetPow2(0.0);
            wait_ms(1000);
}

void TurnRight()
{
            mL.SetPow(0.4); mR.SetPow(0.0);//rechtskurve
            wait_ms(300);
            mL.SetPow2(0.0);
            mR.SetPow2(0.0);
            wait_ms(1000);
}

void FrontBlinkerTask()
{
    if (t1.read_ms()>100) // alle 100ms = 10Hz
    {
        t1.reset(); // timer neu starten
        if (direction == 1)
        {
            pex.ToggleLeds(LED_FL1 | LED_FL2);
            pex.ToggleLeds(LED_FR1 | LED_FR2);
        }
        
    }
    
}

void BackBlinkerTask()
{
    if (t1.read_ms()>100) // alle 100ms = 10Hz
    {
        t1.reset(); // timer neu starten
        if (direction == 0)
        {
            pex.ToggleLeds(LED_BL1 | LED_BL2);
            pex.ToggleLeds(LED_BR1 | LED_BR2);
        }
        
    }
   
}


