#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);
BusOut leds1(LED1,LED2,LED3,LED4);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15



int main(void)
{
    boardPow=3; wait_ms(10);        // boardPow = 3!
    InitBertl();
    
    while(1)
    {
        pex.ReadButtons();
        if(ls1.Read()>600 && pex.IsButton(BTN_FLL))
        leds1 = 1;
        if(ls2.Read()>600 && pex.IsButton(BTN_FL))
        leds1 = 2;
        if(ls4.Read()>600 && pex.IsButton(BTN_FR))
        leds1 = 4;
        if(ls5.Read()>600 && pex.IsButton(BTN_FRR))
        leds1 = 8;
        else
        leds1 = 0;
    }
    
    return 1;
}