#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15

void ButonBlinker();
void LineSensor();
void ButonMotor();


int main(void)
{
    boardPow=1; wait_ms(10);
    InitBertl();
    pex.useISR=0;
    pex.ClearLeds();
    
    while(1)
    {
        ButonBlinker();
        LineSensor();
        ButonMotor();

    }
    
    return 1;
}

// Linensensor ansteuern mit If abfrage
void LineSensor()
{
    if (ls1.Read()<600) // wenn Sensor 1 dunkel ist dann leuchtet die LED BL1
    {
        pex.SetLeds(LED_BL1);
    }
        if (ls2.Read()<600)
    {
        pex.SetLeds(LED_BL2);
    }
        if (ls4.Read()<600)
    {
        pex.SetLeds(LED_BR1);
    }
        if (ls5.Read()<600)
    {
        pex.SetLeds(LED_BR2);
    }

}

// Tastenabfrage mit LEDs anzeige
void ButonBlinker()
{
    pex.ReadButtons();
    
    if (pex.IsButton(BTN_FLL)) // wenn Taste vorne links gedrückt wird leuchtet die LED FL1
    {
        pex.SetLeds(LED_FL1);
    }
        if (pex.IsButton(BTN_FL))
    {
        pex.SetLeds(LED_FL2);
    }
        if (pex.IsButton(BTN_FRR))
    {
        pex.SetLeds(LED_FR1);
    }
        if (pex.IsButton(BTN_FR))
    {
        pex.SetLeds(LED_FR2);
    }

    wait_ms(500);
    pex.ClearLeds();
    wait_ms(50);
}

// Motor ansteuern mit taster
void ButonMotor()
{
    if(pex.IsButton(BTN_FM)) // wenn Taster gedrückt wird Motor start
    {
    mL.SetPow(0.2);
    mR.SetPow(0.2);
    wait_ms(1000);
    mL.SetPow(0.0);
    mR.SetPow(0.0);
    }
    
}