/**
 *     WebRadio player 2  (Icecast music streams player)
 *
 *     Listen to your favorite WebRadio music stations up to 320 kbps !
 *
 *     Used components: VS1053 MP3 decoder and WIZ-wiki-W7500 ARM Cortex-M0 board
 *
 *     5 September 2015 by Vassilis Serasidis
 *   
 *     Home: http://www.serasidis.gr
 *     email: avrsite@yahoo.gr
 *
 *     Edit the file "W7500x_toe.cpp" and add the following lines:
 *     
 *       **
 *       * Use only one socket with 16 kBytes of RAM for Tx and 16 kBytes of RAM for Rx 
 *       *
 *       sreg<uint8_t>(0, Sn_RXBUF_SIZE, 16); //Vassilis Serasidis
 *       sreg<uint8_t>(0, Sn_TXBUF_SIZE, 16); //Vassilis Serasidis
 *
 *     -= NOTE =-
 *     This project is provided as-is without any waranty, under the GNU General Public License v3 
 *     ( http://www.gnu.org/licenses/gpl-3.0.en.html )
 * 
 */

#include "mbed.h"
#include "VS1053.h" 
#include "EthernetInterface.h"

#define BUFFER_LENGTH    1024
#define BUFFER_LENGTH2     32
#define MAX_RADIO_STATIONS 4 // 18 pre-defined webradio station. You can increase the number if you want.

//VS1002 mp3(PB_3, PB_2, PB_1, PB_0,"sdc",D11, D12 ,D13, PC_12, PC_15, PC_14, PC_13); 
//VS1002::VS1002( mmosi,  mmiso,  ssck,  ccs, const char *name,  mosi,  miso,  sck,  cs,  rst,  dreq,  dcs)
//    : _DREQ(dreq), _RST(rst), _spi(mosi, miso, sck), _CS(cs), _DCS(dcs), _sd(mmosi, mmiso, ssck, ccs, name) {
//    }    

VS1053 player(D11, D12 ,D13, PC_12, PC_13, PC_14, PC_15); // mosi, miso, sck, cs, dcs, dreq, rst
//VS1002 player(PB_3, PB_2, PB_1, PB_0,"sdc",D11, D12 ,D13, PC_12, PC_15, PC_14, PC_13);               
char ramBuffer[BUFFER_LENGTH];
int radioStationNumber = 0; //Initial webradio station

Serial com(USBTX, USBRX); //Create a Serial Port instance.

DigitalIn dreq(PC_14); //Set DREQ pin as input (D8).
DigitalIn sw1(D2);  //Next webradio station selection button (D5).
//DigitalIn sw2(D6);  //Previous webradio station selection button (D6).
//int sw1 = 0;
//int sw2 = 0;    
typedef struct station {
    char const * rAddress;
    unsigned int port;
} STATION;

/**
 * 18 pre-defined webradio stations. 
 * You can increase the number of the stations because there is plenty of memory bytes.
 * Syntax: {"WebRadio_station_address", port_number}
 */
const STATION stations[MAX_RADIO_STATIONS] = {
   // {"radiolive.sbs.co.kr",80},
//    {"sc03.saycast.com",80},
//    {"72.232.255.92", 12978},
    {"ks386954.kimsufi.com", 8248},    // <01> La Grosse Radio Metal - Hard Heavy - From Paris ::  48 kbps :: aacp
    {"205.164.62.15",10032},           // <02> 1.FM - GAIA                                     ::  64-kbps :: aacp
    {"205.164.36.153",80},             // <03> BOM PSYTRANCE (1.FM TM)                         ::  64-kbps :: aacp
    {"topfm-st1.kbcnet.rs",80},        // <04> TOP FM Beograd 106,8                            ::  64-kpbs :: mpeg 
//    {"sc8.1.fm",8030},           //                                  ::  64-kbps :: aacp
//    {"www.inbalancemusic.com",80},             // <05> Cosmoradio 95.1 - Thessaloniki - Greece         :: 128 kbps :: mpeg
//    {"s10.voscast.com",9940},          // <06> Zoo Radio 90.8 Greece                           :: 128 kbps :: mpeg
//    {"radio.onweb.gr",8078},           // <07> 1055 ROCK - THESSALONIKI - GREECE               :: 128 kbps :: mpeg
//    {"149.255.59.162", 8030},          // <08> ORIGINUK.NET DRUM AND BASS AND OLDSKOOL         :: 128 kbps :: mpeg
//    {"uk3.internet-radio.com", 8060},  // <09> Champion 5768 FM - Non Stop Hits From All Eras  :: 128 kbps :: mpeg
//    {"46.41.129.195", 8000},           // <10> Trance1.FM                                      :: 128 kbps :: mpeg
//    {"uk3.internet-radio.com", 10523}, // <11> Tonik Radio Ireland                             :: 192 kbps :: mpeg
//    {"95.141.24.4", 80},               // <12> #MUSIK.CLUB (DANCE) - WWW.RAUTEMUSIK.FM         :: 192 kbps :: mpeg
//    {"193.34.51.33", 80},              // <13> WackenRadio.com - Metal Rock Alternative        :: 192 kbps :: mpeg
//    {"uk4.internet-radio.com",15938},  // <14> GoHamRadio - Trance Dance Progressive Chillout  :: 256 kbps :: mpeg
//    {"206.190.152.194", 8000},         // <15> PARTY VIBE RADIO: Reggae   Roots   Dancehall    :: 256 kbps :: mpeg
 //   {"213.251.157.145", 8016},         // <16> Audiophile Baroque Clasic Music                 :: 320 kbps :: mpeg
 //   {"83.137.145.141", 14280},         // <17> Nautic Radio - Beats 'n Breaks - drum and bass  :: 320 kbps :: mpeg
//    {"50.7.173.162", 8014}             // <18> Audiophile Jazz                                 :: 320 kbps :: mpeg
};


/*************************************
 *
 *************************************/
int main() {
    *(volatile uint32_t *)(0x41001014) = 0x0060100; //clock setting 48MHz
    com.baud(115200);   //Set the Serial port baud rate to 115200 bits/second
    
    com.printf("\r\n---------------------------------------");
    com.printf("\r\n          WebRadio player\n");
//    com.printf("\r\n(c) 05 Sept 2015 by Vassilis Serasidis");
//    com.printf("\r\n      Home: http://www.serasidis.gr");
    com.printf("\r\n---------------------------------------");
    com.printf("\r\nGetting IP address...");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x09}; //Ethernet MAC address
    
        
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    
    eth.connect();
    
    com.printf("\r\nLocal IP Address: %s\r\n", eth.getIPAddress()); //Print the local IP address.
    
    int i,m;        
    TCPSocketConnection client; //Create a client.
    
    player.hardwareReset(); //Do a reset to the VS1053 board.
//    player.clockUp();       //Set the VS1053 at faster SPI speed.
    player.modeSwitch();    //Patch the VS1053 board to play MP3 files (very important!).
//    player.setVolume(44);   //Set the VS1053 volume. Value 0 is MAX volume, 255 is mute.
//      player._RST = 1; 
//      player.cs_high();                                  //chip disabled 
//      player.sci_initialise();                           //initialise MBED
//      player.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF)); 
//      player.sci_write(0x03, 0x9800); 
//      player.sdi_initialise();
    
    while(1){
        com.printf("\r\n----------------------------------------------");
        com.printf("\r\nConnecting to [%s] ...",stations[radioStationNumber].rAddress);
        
        /* Connect to the Icecast server defined by 'radioStationNumber' variable (1-18) */
        client.connect(stations[radioStationNumber].rAddress, stations[radioStationNumber].port);
        
        /* Check if the client was connected to the server */
        if(client.is_connected()){
            com.printf("\r\nConnected!\r\n");    
        }else{
            //com.printf("Is NOT connected. Please try again.\n");
            for(;;); //Stay here for ever.
        }
        
        client.send("GET / HTTP/1.1\r\n",16); //Send the Header to the Server.
        client.send("\r\n",2);
        wait(0.5);
    
        com.printf("\r\nReading Icecast radiostation information...");
        /* Read the Icecast server information (station name, bit rate and more)*/
        client.receive(ramBuffer, BUFFER_LENGTH); //Store the received data to the RAM buffer.
        com.printf("\r\nDone!");
        com.printf("\r\n<%d> ",radioStationNumber + 1); //Print the station number (1-18)
        
        /**
         * From the 1024 received bytes extract only the WebRadio station information.
         * The information data ends with the bytes \r\n\r\n
         * In other words, ends with the four hexadecimal bytes [0x0d 0x0a 0x0d 0x0a] . 
         */
        for(i=0;i<(BUFFER_LENGTH - 4);i++){ 
          if((ramBuffer[i] == 0x0d)&&(ramBuffer[i+1] == 0x0a)&&(ramBuffer[i+2] == 0x0d)&&(ramBuffer[i+3] == 0x0a))
            break; //If you found the end-sequence then break the <for> loop.
          else
            com.putc(ramBuffer[i]);
        }
        com.printf("\r\n");
        
        
        /* Do that loop forever */  
    
        m = 1;
        
        while(m > 0){ 
            client.receive(ramBuffer, BUFFER_LENGTH2);        
            while(!dreq);
            if(sw1){ //If the NEXT button is pressed,
                if(radioStationNumber < MAX_RADIO_STATIONS - 1 )
                    radioStationNumber++; //select the NEXT webradio station. 
               else
                    radioStationNumber = 0;
                m = 0; //Exit from this loop.
            }
 //           
  //          if(sw2){ //If the PREVIOUS button is pressed,
 //               if(radioStationNumber > 0)
 //                   radioStationNumber--; //select the PREVIOUS webradio station. 
 //               else
 //                   radioStationNumber = MAX_RADIO_STATIONS - 1;
 //              m = 0; //Exit from this loop. 
 //           }
            player.sendDataBlock(ramBuffer, BUFFER_LENGTH2);    // and pass the data to the VS1053 MP3 decoder module.
        }
          
    }
}

