#include "mbed.h"   // blinky starts with mbed lib 76, however this was updated to lib 81
#include "Utility.h"
//#include "RawSerial.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
extern "C" void mbed_reset();

void* operator new(size_t size) throw()
{   
    void *ptr;
 
    ptr = malloc(size);
    return ptr;
}
 
void operator delete(void *ptr) throw()
{
   free(ptr);
}
 
void operator delete[](void *ptr) throw()
{
   free(ptr);
}

int main() {
    //pc.baud(460800);    // I like a snappy terminal, so crank it up!
    int f = Free();
    pc.printf("\r\nBlinky eating memory - Build " __DATE__ " " __TIME__ "\r\n");
    pc.printf("  %d bytes free\r\n", f);
    int i = 2000;
    int total = 0;
    
    while(1) {
        myled = 1;
        wait(0.2);
        pc.printf("Allocating %d bytes in addition to %d already allocated.\r\n", i, total);
        char * p = new char [i];      // This never returns after 24000
        //char * p = (char *)malloc(i);     // This fails gracefully with NULL return after 24000
        pc.printf("  %d bytes free.\r\n", Free());
        __heapvalid((__heapprt)fprintf, stdout, 0);
        if (p) {
            total += i;
            pc.printf("  Success! \r\n");
        } else {
            pc.printf("  Failed...\r\n");
            break;
        }
        myled = 0;
        wait(0.2);
    }
    pc.printf("done.\r\n");
    while (!pc.readable()) {}
    mbed_reset();
}
