
#ifndef X10SERVER_H
#define X10SERVER_H

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

/// The X10Server class, which will listen for X10 commands from
/// the network.
///
class X10Server
{
public:
    /// X10Server Constructor, which also assigns the port.
    ///
    /// This constructs the X10Server object, and sets it to
    /// listen for incoming messages.
    ///
    /// @param[in] fptr is an optional pointer to a function that can
    ///     accept and process the received message.
    ///     This function is called with a pointer to the message and
    ///     the size of the message as parameters.
    /// @param[in] port is an optional parameter to set the port
    ///     to listen to. The default is 10630.
    ///
    X10Server(void(*fptr)(char * buffer, int size) = NULL, uint16_t port = 10630);
    
    /// The process to call where there is free time, to see
    /// if there is a request, and to handle it.
    ///
    void poll(void);

private:
    void (*callback)(char * buffer, int size);
    uint16_t listenPort;
    TCPSocketServer svr;
    TCPSocketConnection client;
    bool serverIsListening;
    bool clientIsConnected;
};

#endif // X10SERVER_H