#include "X10Server.h"


//#define DEBUG "x10d"
#ifdef WIN32
#define LF "\n"
#else // mbed
#define LF "\r\n"
#endif // WIN32
#include <cstdio>
#if (defined(DEBUG) && !defined(TARGET_LPC11U24))
#define DBG(x, ...)  std::printf("[DBG %s %3d] " x LF, DEBUG, __LINE__, ##__VA_ARGS__)
#define WARN(x, ...) std::printf("[WRN %s %3d] " x LF, DEBUG, __LINE__, ##__VA_ARGS__)
#define ERR(x, ...)  std::printf("[ERR %s %3d] " x LF, DEBUG, __LINE__, ##__VA_ARGS__)
#define INFO(x, ...) std::printf("[INF %s %3d] " x LF, DEBUG, __LINE__, ##__VA_ARGS__)
#else
#define DBG(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#define INFO(x, ...)
#endif


X10Server::X10Server(void(*fptr)(char * buffer, int size), uint16_t port)
{
    listenPort = port;
    serverIsListening = false;
    clientIsConnected = false;
    callback = fptr;
    INFO("Server binding...");
    svr.set_blocking(false, 10);
    if (svr.bind(listenPort)< 0) {
        WARN("tcp server bind failed.");
    } else {
        INFO("tcp server bind successed.");
    }
    
    if (svr.listen(1) < 0) {
        WARN("tcp server listen failed.");
    } else {
        INFO("tcp server is listening...");
        serverIsListening = true;
    }
}

void X10Server::poll(void)
{
    //listening for a request
    if (serverIsListening) {
        //blocking mode(never timeout)
        if (svr.accept(client)<0) {
            ;   // WARN("failed to accept connection.");
        } else {
            INFO("connection success!IP: %s", client.get_address());
            clientIsConnected = true;

            while (clientIsConnected) {
                char buffer[1024] = {};
                    
                switch (client.receive(buffer, 1023)) {
                    case 0:
                        INFO("received buffer is empty.");
                        clientIsConnected = false;
                        break;
                    case -1:
                        WARN("failed to read data from client.");
                        clientIsConnected = false;
                        break;
                    default:
                        INFO("Received Data: %d bytes\r\n%s", strlen(buffer), buffer);
                        if (callback)
                            (*callback)(buffer, strlen(buffer));
                        break;
                }
            }
            INFO("close connection, tcp server is listening...");
            client.close();
        }
    }
}
