#include "EthernetInterface.h"


//#define DEBUG "WFLY"      //Debug is disabled by default

// How to use this debug macro
//
// ...
// INFO("Stuff to show %d", var); // new-line is automatically appended
// [I myfile  23] Stuff to show 23\r\n
//
#if (defined(DEBUG) && !defined(TARGET_LPC11U24))
#define INFO(x, ...) std::printf("[INF %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[WRN %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define ERR(x, ...)  std::printf("[ERR %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#else
#define INFO(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#endif

static char myName[33];    // name cannot exceed 32 chars

EthernetInterface::EthernetInterface( PinName tx, PinName rx, PinName reset, PinName tcp_status,
                                const char * ssid, const char * phrase, Security sec) :
    Wifly(tx, rx, reset, tcp_status, ssid, phrase, sec)
{
    ip_set = false;
    mac_set = false;
    myName[0] = '\0';
}

int EthernetInterface::init()
{
    state.dhcp = true;
    ip_set = false;
    reset();
    configure();
    return 0;
}

int EthernetInterface::init(const char* ip, const char* mask, const char* gateway)
{
    state.dhcp = false;
    this->ip = ip;
    strcpy(ip_string, ip);
    ip_set = true;
    this->netmask = mask;
    this->gateway = gateway;
    reset();
    configure();
    return 0;
}

void EthernetInterface::setSecurity(const char * ssid, const char * phrase, Security sec)
{
    Wifly::SetSecurity(ssid, phrase, sec);
}

int EthernetInterface::connect()
{
    return (join()) ? 0 : -1;
}

int EthernetInterface::disconnect()
{
    ip_set = false;
    return Wifly::disconnect();
}

// command   "get mac\r"
// response  "MAC Addr=##:##:##:##:##:##\n<4.40> "
char * EthernetInterface::getMACAddress()
{
    char buffer[50];
    char * match = buffer;
    char * p;
    if (!mac_set) {
        mac_string[0] = '\0';
        if (!sendCommand("get mac\r", NULL, buffer))
            return NULL;
        exit();
        flush();
        INFO("buffer is '%s'", buffer);
        // revised to find the mac address string, following a small
        // change where \r are permitted in the captured
        // reply to a command.
        while (*match && (*match != '='))
            match++;
        if (*match) {
            match++;    // Advance past '='
            p = match;
            while (strchr("0123456789abcdefABCDEF:", *p))
                p++;
            *p = '\0';
            if (strlen(match) <= 17) {  // 192.168.101.202
                strcpy(mac_string, match);
                mac_set = true;
            }
        }
    }
    return mac_string;
}

// typical response might be
// \r192.168.43.107\r
// <4.40>
char * EthernetInterface::getIPAddress()
{
    char buffer[50];
    char * match = buffer;
    char * p;
    if (!ip_set) {
        if (!sendCommand("get ip a\r", NULL, buffer))
            return NULL;
        exit();
        flush();
        // revised to find the IP string, following a small
        // change where \r are permitted in the captured
        // reply to a command.
        while (*match && (*match < '0' || *match > '9'))
            match++;
        p = match;
        while (strchr("0123456789.", *p))
            p++;
        *p = '\0';
        if (strlen(match) <= 15) {  // 192.168.101.202
            strcpy(ip_string, match);
            ip_set = true;
        }
    }
    return ip_string;
}

static bool inRange(char testChar, char minChar, char maxChar)
{
    if (testChar >= minChar && testChar <= maxChar) 
        return true;
    else
        return false;
}

int EthernetInterface::setName(const char * myname)
{
    char buffer[60];    // hold the whole command
    int i;
    
    strncpy(myName, myname, 32);
    myName[32] = '\0';  // be sure it is NULL terminated.
    // make the name 'safe'
    for (i=0; i<32 && myName[i]; i++) {
        if (!inRange(myName[i], '0', '9')
        &&  !inRange(myName[i], 'A', 'Z')
        &&  !inRange(myName[i], 'a', 'z'))
            myName[i] = '-';
    }
    sprintf(buffer, "set opt deviceid %s\r", myname);
    if (!sendCommand(buffer, "OK"))
        return -1;  // fail
    return 0;       // indicate success...
}

const char * EthernetInterface::getName(void)
{
    return myName;
}

int EthernetInterface::get_connection_speed(void)
{
    char bigbuf[200];   // big enough?
    int res = 0;
    
    if (sendCommand("get wlan\r", NULL, bigbuf)) {
        // "Rate=15, 54 Mb\r"
        char * p = strstr(bigbuf, "Rate=");
        
        if (p) {
            p += 5; // strlen("Rate=");
            while (*p && *p != ' ')
                p++;
            while (*p && *p == ' ')
                p++;
            res = atoi(p);
            
        }
    }
    return res;
}