


// Helper functions follow. These functions may exist in some environments and
// not in other combinations of libraries and compilers, so private versions
// are here to ensure consistent behavior.

/// mytolower exists because not all compiler libraries have this function
///
/// This takes a character and if it is upper-case, it converts it to
/// lower-case and returns it.
///
/// @param a is the character to convert
/// @returns the lower case equivalent to a
///
char mytolower(char a);

/// mystrnicmp exists because not all compiler libraries have this function.
///
/// Some have strnicmp, others _strnicmp, and others have C++ methods, which
/// is outside the scope of this C-portable set of functions.
///
/// @param l is a pointer to the string on the left
/// @param r is a pointer to the string on the right
/// @param n is the number of characters to compare
/// @returns -1 if l < r
/// @returns 0 if l == r
/// @returns +1 if l > r
///
int mystrnicmp(const char *l, const char *r, size_t n);

/// mystrcat exists because not all compiler libraries have this function
///
/// This function concatinates one string onto another. It is generally
/// considered unsafe, because of the potential for buffer overflow.
/// Some libraries offer a strcat_s as the safe version, and others may have
/// _strcat. Because this is needed only internal to the CommandProcessor,
/// this version was created.
///
/// @param dst is a pointer to the destination string
/// @param src is a pointer to the source string
/// @returns nothing
///
void mystrcat(char *dst, char *src);

/// myisprint exists because not all compiler libraries have this function
///
/// This function tests a character to see if it is printable (a member
/// of the standard ASCII set).
///
/// @param c is the character to test
/// @returns TRUE if the character is printable
/// @returns FALSE if the character is not printable
///
int myisprint(int c);


/// hextoi converts a hex string to an unsigned integer
///
/// This functions converts text to an unsigned integer, as long as 
/// the stream contains hex-ASCII characters
///
/// @param p is a pointer to the string
/// @returns unsigned long integer value
///
unsigned long hextoul(char *p) {
	unsigned long x = 0;
	while (*p) {
		x <<= 4;
		if (*p >= '0' && *p <= '9')
			x += *p - '0';
		else if (*p >= 'a' && *p <= 'f')
			x += *p - 'a' + 10;
		else if (*p >= 'A' && *p <= 'F')
			x += *p - 'A' + 10;
		p++;
	}
	return x;
}


