
#include "string.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

// Helper functions follow. These functions may exist in some environments and
// not in other combinations of libraries and compilers, so private versions
// are here to ensure consistent behavior.

/// mytolower exists because not all compiler libraries have this function
///
/// This takes a character and if it is upper-case, it converts it to
/// lower-case and returns it.
///
/// @param a is the character to convert
/// @returns the lower case equivalent to a
///
static char mytolower(char a) {
    if (a >= 'A' && a <= 'Z')
        return (a - 'A' + 'a');
    else
        return a;
}

/// mystrnicmp exists because not all compiler libraries have this function.
///
/// Some have strnicmp, others _strnicmp, and others have C++ methods, which
/// is outside the scope of this C-portable set of functions.
///
/// @param l is a pointer to the string on the left
/// @param r is a pointer to the string on the right
/// @param n is the number of characters to compare
/// @returns -1 if l < r
/// @returns 0 if l == r
/// @returns +1 if l > r
///
int mystrnicmp(const char *l, const char *r, size_t n) {
    int result = 0;

    if (n != 0) {
        do {
            result = mytolower(*l++) - mytolower(*r++);
        } while ((result == 0) && (*l != '\0') && (--n > 0));
    }
    if (result < -1)
        result = -1;
    else if (result > 1)
        result = 1;
    return result;
}

/// mystrcat exists because not all compiler libraries have this function
///
/// This function concatinates one string onto another. It is generally
/// considered unsafe, because of the potential for buffer overflow.
/// Some libraries offer a strcat_s as the safe version, and others may have
/// _strcat. Because this is needed only internal to the CommandProcessor,
/// this version was created.
///
/// @param dst is a pointer to the destination string
/// @param src is a pointer to the source string
/// @returns nothing
///
static void mystrcat(char *dst, char *src) {
    while (*dst)
        dst++;
    do
        *dst++ = *src;
    while (*src++);
}

/// myisprint exists because not all compiler libraries have this function
///
/// This function tests a character to see if it is printable (a member
/// of the standard ASCII set).
///
/// @param c is the character to test
/// @returns TRUE if the character is printable
/// @returns FALSE if the character is not printable
///
static int myisprint(int c) {
    if (c >= ' ' && c <= '~')
        return TRUE;
    else
        return FALSE;
}

