/// Utilities.h is an adapter to support easier transition from
/// the mbed cloud compiler to Visual Studio
///
#ifndef UTILITIES_H
#define UTILITIES_H
#include <string.h>

// Helper functions follow. These functions may exist in some environments and
// not in other combinations of libraries and compilers, so private versions
// are here to ensure consistent behavior.

/// Access to intentionally reset the mbed
///
extern "C" void mbed_reset();

#if 0
/// mytolower exists because not all compiler libraries have this function
///
/// This takes a character and if it is upper-case, it converts it to
/// lower-case and returns it.
///
/// @param a is the character to convert
/// @returns the lower case equivalent to a
///
char mytolower(char a);


/// mystrnicmp exists because not all compiler libraries have this function.
///
/// Some have strnicmp, others _strnicmp, and others have C++ methods, which
/// is outside the scope of this C-portable set of functions.
///
/// @param l is a pointer to the string on the left
/// @param r is a pointer to the string on the right
/// @param n is the number of characters to compare
/// @returns -1 if l < r
/// @returns 0 if l == r
/// @returns +1 if l > r
///
int mystrnicmp(const char *l, const char *r, size_t n);
#endif

/// mystrcat exists because not all compiler libraries have this function
///
/// This function concatinates one string onto another. It is generally
/// considered unsafe, because of the potential for buffer overflow.
/// Some libraries offer a strcat_s as the safe version, and others may have
/// _strcat. Because this is needed only internal to the CommandProcessor,
/// this version was created.
///
/// @param dst is a pointer to the destination string
/// @param src is a pointer to the source string
/// @returns nothing
///
void mystrcat(char *dst, char *src);

/// myisprint exists because not all compiler libraries have this function
///
/// This function tests a character to see if it is printable (a member
/// of the standard ASCII set).
///
/// @param c is the character to test
/// @returns TRUE if the character is printable
/// @returns FALSE if the character is not printable
///
int myisprint(int c);


/// hextoi converts a hex string to an unsigned integer
///
/// This functions converts text to an unsigned integer, as long as
/// the stream contains hex-ASCII characters
///
/// @param p is a pointer to the string
/// @returns unsigned long integer value
///
unsigned long hextoul(char *p);


#ifdef WIN32
//#######################################################################
//#######################################################################
//#######################################################################
//
// Everything from here forward is intended to "satisfy" the Visual
// Studio 2010 compiler. It isn't intended to necessarily run, since
// we're faking out hardware for the most part.
//

#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <conio.h>

#define __disable_irq()
#define __enable_irq()

enum {
    CANData,
    CANRemote
};

enum {
    CANStandard,
    CANExtended
};

enum {
    PullNone
};

typedef unsigned int uint32_t;
//typedef unsigned int PinName;
typedef enum {
    NC,
    USBTX,
    USBRX,
    LED1,
    LED2,
    LED3,
    LED4,
    p1, p2, p3, p4, p5, p6, p7, p8, p9, p10,
    p11, p12, p13, p14, p15, p16, p17, p18, p19, p20,
    p21, p22, p23, p24, p25, p26, p27, p28, p29, p30
} PinName;


#define SystemCoreClock 48000000

typedef struct {
    uint32_t WDMOD;
    uint32_t WDCLKSEL;
    uint32_t WDTC;
    uint32_t WDFEED;
} LPC_WDT_BASE;

extern LPC_WDT_BASE * LPC_WDT;

typedef struct {
    uint32_t MOD;
    uint32_t GSR;
    uint32_t ICR;
    uint32_t IER;
    uint32_t BTR;
    uint32_t EWL;
    uint32_t SR;
    uint32_t RFS;
    uint32_t RID;
    uint32_t RDA;
    uint32_t RDB;
    uint32_t TFI1;
    uint32_t TID1;
    uint32_t TDA1;
    uint32_t TDB1;
    uint32_t TFI2;
    uint32_t TID2;
    uint32_t TDA2;
    uint32_t TDB2;
    uint32_t TFI3;
    uint32_t TID3;
    uint32_t TDA3;
    uint32_t TDB3;
} LPC_CAN_BASE;

extern LPC_CAN_BASE * LPC_CAN1;
extern LPC_CAN_BASE * LPC_CAN2;


class CANMessage {
public:
    CANMessage();
    CANMessage(uint32_t _id, char * _pdata, int _len, int _type, int _format);
    ~CANMessage();
    uint32_t id;
    int dir;
    char data[8];
    int len;
    int format;
    int type;
};

class CAN {
public:
    CAN(PinName r, PinName t);
    ~CAN();
    int write(CANMessage msg);
    int read(CANMessage &msg);
    void attach(void(*fp)(void));
    void monitor(bool t);
    bool frequency(uint32_t f);
    uint32_t tderror();
    uint32_t rderror();
    void reset();
};

class PwmOut {
public:
    PwmOut(PinName p);
    ~PwmOut();
    double &PwmOut::operator=(double p);
private:
    double p;
};

class Timeout {
public:
    Timeout();
    ~Timeout();
    template <typename T> void attach(T * tptr, void (T::*mptr)(void), float t) {
        (void)tptr;
        (void)mptr;
        (void)t;
    }
};

class DigitalInOut {
public:
    DigitalInOut(PinName p);
    ~DigitalInOut();
    void output();
    void input();
    void write(bool v);
    void mode(int m);
};

class Serial {
public:
    Serial(PinName t, PinName r);
    ~Serial();
    int printf(char *fmt, ...);
    int readable();
    int getc();
    int putc(int c);
    void baud(uint32_t freq);
};

class Timer {
public:
    Timer();
    ~Timer();
    void start();
    uint32_t read_ms();
    uint32_t read_us();
};

void wait(float t);

#endif // WIN32

#endif // UTILITIES_H
/// Utilities.h is an adapter to support easier transition from
/// the mbed cloud compiler to Visual Studio
///
#ifndef UTILITIES_H
#define UTILITIES_H
#include <string.h>

// Helper functions follow. These functions may exist in some environments and
// not in other combinations of libraries and compilers, so private versions
// are here to ensure consistent behavior.

/// Access to intentionally reset the mbed
///
extern "C" void mbed_reset();


/// mytolower exists because not all compiler libraries have this function
///
/// This takes a character and if it is upper-case, it converts it to
/// lower-case and returns it.
///
/// @param a is the character to convert
/// @returns the lower case equivalent to a
///
char mytolower(char a);

/// mystrnicmp exists because not all compiler libraries have this function.
///
/// Some have strnicmp, others _strnicmp, and others have C++ methods, which
/// is outside the scope of this C-portable set of functions.
///
/// @param l is a pointer to the string on the left
/// @param r is a pointer to the string on the right
/// @param n is the number of characters to compare
/// @returns -1 if l < r
/// @returns 0 if l == r
/// @returns +1 if l > r
///
int mystrnicmp(const char *l, const char *r, size_t n);

/// mystrcat exists because not all compiler libraries have this function
///
/// This function concatinates one string onto another. It is generally
/// considered unsafe, because of the potential for buffer overflow.
/// Some libraries offer a strcat_s as the safe version, and others may have
/// _strcat. Because this is needed only internal to the CommandProcessor,
/// this version was created.
///
/// @param dst is a pointer to the destination string
/// @param src is a pointer to the source string
/// @returns nothing
///
void mystrcat(char *dst, char *src);

/// myisprint exists because not all compiler libraries have this function
///
/// This function tests a character to see if it is printable (a member
/// of the standard ASCII set).
///
/// @param c is the character to test
/// @returns TRUE if the character is printable
/// @returns FALSE if the character is not printable
///
int myisprint(int c);


/// hextoi converts a hex string to an unsigned integer
///
/// This functions converts text to an unsigned integer, as long as
/// the stream contains hex-ASCII characters
///
/// @param p is a pointer to the string
/// @returns unsigned long integer value
///
unsigned long hextoul(char *p);


#ifdef WIN32
//#######################################################################
//#######################################################################
//#######################################################################
//
// Everything from here forward is intended to "satisfy" the Visual
// Studio 2010 compiler. It isn't intended to necessarily run, since
// we're faking out hardware for the most part.
//

#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <conio.h>

#define __disable_irq()
#define __enable_irq()

enum {
    CANData,
    CANRemote
};

enum {
    CANStandard,
    CANExtended
};

enum {
    PullNone
};

typedef unsigned int uint32_t;
//typedef unsigned int PinName;
typedef enum {
    NC,
    USBTX,
    USBRX,
    LED1,
    LED2,
    LED3,
    LED4,
    p1, p2, p3, p4, p5, p6, p7, p8, p9, p10,
    p11, p12, p13, p14, p15, p16, p17, p18, p19, p20,
    p21, p22, p23, p24, p25, p26, p27, p28, p29, p30
} PinName;


#define SystemCoreClock 48000000

typedef struct {
    uint32_t WDMOD;
    uint32_t WDCLKSEL;
    uint32_t WDTC;
    uint32_t WDFEED;
} LPC_WDT_BASE;

extern LPC_WDT_BASE * LPC_WDT;

typedef struct {
    uint32_t MOD;
    uint32_t GSR;
    uint32_t ICR;
    uint32_t IER;
    uint32_t BTR;
    uint32_t EWL;
    uint32_t SR;
    uint32_t RFS;
    uint32_t RID;
    uint32_t RDA;
    uint32_t RDB;
    uint32_t TFI1;
    uint32_t TID1;
    uint32_t TDA1;
    uint32_t TDB1;
    uint32_t TFI2;
    uint32_t TID2;
    uint32_t TDA2;
    uint32_t TDB2;
    uint32_t TFI3;
    uint32_t TID3;
    uint32_t TDA3;
    uint32_t TDB3;
} LPC_CAN_BASE;

extern LPC_CAN_BASE * LPC_CAN1;
extern LPC_CAN_BASE * LPC_CAN2;


class CANMessage {
public:
    CANMessage();
    CANMessage(uint32_t _id, char * _pdata, int _len, int _type, int _format);
    ~CANMessage();
    uint32_t id;
    int dir;
    char data[8];
    int len;
    int format;
    int type;
};

class CAN {
public:
    CAN(PinName r, PinName t);
    ~CAN();
    int write(CANMessage msg);
    int read(CANMessage &msg);
    void attach(void(*fp)(void));
    void monitor(bool t);
    bool frequency(uint32_t f);
    uint32_t tderror();
    uint32_t rderror();
    void reset();
};

class PwmOut {
public:
    PwmOut(PinName p);
    ~PwmOut();
    double &PwmOut::operator=(double p);
private:
    double p;
};

class Timeout {
public:
    Timeout();
    ~Timeout();
    template <typename T> void attach(T * tptr, void (T::*mptr)(void), float t) {
        (void)tptr;
        (void)mptr;
        (void)t;
    }
};

class DigitalInOut {
public:
    DigitalInOut(PinName p);
    ~DigitalInOut();
    void output();
    void input();
    void write(bool v);
    void mode(int m);
};

class Serial {
public:
    Serial(PinName t, PinName r);
    ~Serial();
    int printf(char *fmt, ...);
    int readable();
    int getc();
    int putc(int c);
    void baud(uint32_t freq);
};

class Timer {
public:
    Timer();
    ~Timer();
    void start();
    uint32_t read_ms();
    uint32_t read_us();
};

void wait(float t);

#endif // WIN32

#endif // UTILITIES_H
