/// A collection of utilities that ease the migration to/from Visual Studio and mbed
/// cloud compiler.

#include "Utilities.h"        // mbed <-> Visual Studio


#include "string.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

// Helper functions follow. These functions may exist in some environments and
// not in other combinations of libraries and compilers, so private versions
// are here to ensure consistent behavior.

#if 0
/// mytolower exists because not all compiler libraries have this function
///
/// This takes a character and if it is upper-case, it converts it to
/// lower-case and returns it.
///
/// @param a is the character to convert
/// @returns the lower case equivalent to a
///
char mytolower(char a) {
    if (a >= 'A' && a <= 'Z')
        return (a - 'A' + 'a');
    else
        return a;
}


/// mystrnicmp exists because not all compiler libraries have this function.
///
/// Some have strnicmp, others _strnicmp, and others have C++ methods, which
/// is outside the scope of this C-portable set of functions.
///
/// @param l is a pointer to the string on the left
/// @param r is a pointer to the string on the right
/// @param n is the number of characters to compare
/// @returns -1 if l < r
/// @returns 0 if l == r
/// @returns +1 if l > r
///
int mystrnicmp(const char *l, const char *r, size_t n) {
    int result = 0;

    if (n != 0) {
        do {
            result = mytolower(*l++) - mytolower(*r++);
        } while ((result == 0) && (*l != '\0') && (--n > 0));
    }
    if (result < -1)
        result = -1;
    else if (result > 1)
        result = 1;
    return result;
}
#endif

/// mystrcat exists because not all compiler libraries have this function
///
/// This function concatinates one string onto another. It is generally
/// considered unsafe, because of the potential for buffer overflow.
/// Some libraries offer a strcat_s as the safe version, and others may have
/// _strcat. Because this is needed only internal to the CommandProcessor,
/// this version was created.
///
/// @param dst is a pointer to the destination string
/// @param src is a pointer to the source string
/// @returns nothing
///
void mystrcat(char *dst, char *src) {
    while (*dst)
        dst++;
    do
        *dst++ = *src;
    while (*src++);
}

/// myisprint exists because not all compiler libraries have this function
///
/// This function tests a character to see if it is printable (a member
/// of the standard ASCII set).
///
/// @param c is the character to test
/// @returns TRUE if the character is printable
/// @returns FALSE if the character is not printable
///
int myisprint(int c) {
    if (c >= ' ' && c <= '~')
        return TRUE;
    else
        return FALSE;
}


/// hextoi converts a hex string to an unsigned integer
///
/// This functions converts text to an unsigned integer, as long as
/// the stream contains hex-ASCII characters
///
/// @param p is a pointer to the string
/// @returns unsigned long integer value
///
unsigned long hextoul(char *p) {
    unsigned long x = 0;
    while (*p) {
        x <<= 4;
        if (*p >= '0' && *p <= '9')
            x += *p - '0';
        else if (*p >= 'a' && *p <= 'f')
            x += *p - 'a' + 10;
        else if (*p >= 'A' && *p <= 'F')
            x += *p - 'A' + 10;
        p++;
    }
    return x;
}



#ifdef WIN32
//#######################################################################
//#######################################################################
//#######################################################################
//
// Everything from here forward is intended to "satisfy" the Visual
// Studio 2010 compiler. It isn't intended to necessarily run, since
// we're faking out hardware for the most part.
//

LPC_WDT_BASE * LPC_WDT;

LPC_CAN_BASE * LPC_CAN1;
LPC_CAN_BASE * LPC_CAN2;


void wait(float t) {
    (void)t;
}


CANMessage::CANMessage() {
}

CANMessage::CANMessage(uint32_t _id, char *_pdata, int _len, int _type, int _format) {
    id = _id;
    dir = 0;
    len = _len;
    format = _format;
    type = _type;
    for (int i=0; i<len; i++)
        data[i] = _pdata[i];
}

CANMessage::~CANMessage() {
}


CAN::CAN(PinName r, PinName t) {
    (void)r;
    (void)t;
}
CAN::~CAN() {
}
int CAN::write(CANMessage msg) {
    (void)msg;
    return 1;
}
int CAN::read(CANMessage &msg) {
    (void)msg;
    return 1;
}
void CAN::attach(void(*fp)(void)) {
    (void)fp;
}
void CAN::monitor(bool t) {
    (void)t;
}
bool CAN::frequency(uint32_t f) {
    (void)f;
    return true;
}
uint32_t CAN::tderror() {
    return 0;
}
uint32_t CAN::rderror() {
    return 0;
}
void CAN::reset() {
}

PwmOut::PwmOut(PinName p) {
    (void)p;
}
PwmOut::~PwmOut() {
}
double &PwmOut::operator=(double _p) {
    return p = _p;
}

Timeout::Timeout() {
}
Timeout::~Timeout() {
}

DigitalInOut::DigitalInOut(PinName p) {
    (void)p;
}
DigitalInOut::~DigitalInOut() {
}
void DigitalInOut::output() {
}
void DigitalInOut::input() {
}
void DigitalInOut::write(bool v) {
    (void)v;
}
void DigitalInOut::mode(int m) {
    (void)m;
}

Serial::Serial(PinName t, PinName r) {
    (void)t;
    (void)r;
}
Serial::~Serial() {
}
void Serial::baud(uint32_t freq) {
    (void)freq;
}
int Serial::getc() {
    return _getch();
}
int Serial::putc(int c) {
    return _putch(c);
}
int Serial::readable() {
    return _kbhit();
}
int Serial::printf(char * fmt, ...) {
    return ::printf(fmt);
}

Timer::Timer() {
}
Timer::~Timer() {
}
void Timer::start() {
}
uint32_t Timer::read_ms() {
    return 0;
}
uint32_t Timer::read_us() {
    return 0;
}


extern "C" {
    void mbed_reset() {
    }
}

#endif // WIN32
