
#ifndef STATISTICQUEUE_H
#define STATISTICQUEUE_H
#include "mbed.h"

class StatisticQueue
{
public:
    StatisticQueue(int numEntries);
    ~StatisticQueue();
    
    void Clear(void);
    void EnterItem(float value);
    float Average(void);
    float StdDev(void);
    float Max(void);
    float Min(void);
    int QueueDepth()
        { return queueSize; }
    int QueueCount(void)
        { return currentCount; }
private:
    float * items;
    int queueSize;
    int nextIndex;
    int currentCount;
};

#endif // STATISTICQUEUE_H
