#include "mbed.h"
#ifndef UTILITY_H
#define UTILITY_H



/** Get amount of free memory.
*
* @returns number of bytes of unused memory on the heap.
*/
uint32_t Free();


extern "C" void mbed_reset();

// How to use this debug macro
//
// #define DEBUG "myfile"
// #include "Utility.h"
// ...
// INFO("Stuff to show %d", var); // new-line is automatically appended
// [I myfile  23] Stuff to show 23\r\n
//
#include <cstdio>
#if (defined(DEBUG) && !defined(TARGET_LPC11U24))
#define DBG(x, ...)  std::printf("[DBG %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[WRN %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define ERR(x, ...)  std::printf("[ERR %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define INFO(x, ...) std::printf("[INF %s %3d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#else
#define DBG(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#define INFO(x, ...)
#endif

#endif // UTILITY_H
