/// Demonstration of dynamic page creation using the Smartware Web Server
///
/// There are a few samples here of the dynamically generated web pages.
/// Read the header above each one for more details.
///
/// Status - very experimental. 
///
///         It reads the ini file, but is not reliably managing it.
///         have only tried on the local file system so far.
///
#include "mbed.h"

#include "SW_HTTPServer.h"
#include "DynamicPages.h"
#include "Utility.h"
#include "IniManager.h"



/// ServerConfig
///
/// ssid
/// pass code
/// Security
/// time server
/// time zone
///
HTTPServer::CallBackResults ServerConfig(HTTPServer *svr, HTTPServer::CallBackType type, const char * path, const HTTPServer::namevalue *params, int paramcount) {
    char buf[250];
    HTTPServer::CallBackResults ret = HTTPServer::ACCEPT_ERROR;
    char ssid[50] = "";
    char pass[50] = "";
    char security[10] = "";
    char timeserver[60] = "";
    char timezone[4] = "";       // -12
    //char *securityList[] = 
    //    { "NONE", "WEP_128", "WPA1", "WPA", "WPA2_PSK", "n/a", "ADHOC", "n/a", "WPE_64" };
    INI ini("/local/config.ini");

    switch (type) {
        case HTTPServer::SEND_PAGE:
            // svr->GetParameter("SSID");
            
            // ReadString(const char * section, const char * key, char * buffer, size_t bufferSize)
            ini.ReadString("Wifi", "ssid", ssid, sizeof(ssid), svr->GetParameter("ssid"));
            printf("svr ssid: %s\r\n", ssid);
            printf("web ssid: %s\r\n", svr->GetParameter("ssid"));
            if (svr->GetParameter("ssid") && strcmp(ssid, svr->GetParameter("ssid")) != 0)
                {
                strcpy(ssid, svr->GetParameter("ssid"));
                printf("==  ssid: %s\r\n", ssid);
                ini.WriteString("Wifi", "ssid", ssid);
                }
            printf("svr ssid: %s\r\n", ssid);
            ini.ReadString("Wifi", "pass", pass, sizeof(pass), svr->GetParameter("pass"));
            if (svr->GetParameter("pass") && strcmp(pass, svr->GetParameter("pass")) != 0)
                {
                strcpy(pass, svr->GetParameter("pass"));
                ini.WriteString("Wifi", "pass", pass);
                }
            printf("svr pass: %s\r\n", pass);
            ini.ReadString("Wifi", "security", security, sizeof(security), svr->GetParameter("security"));
            if (svr->GetParameter("security") && strcmp(security, svr->GetParameter("security")) != 0)
                {
                strcpy(security, svr->GetParameter("security"));
                ini.WriteString("Wifi", "security", security);
                }
            ini.ReadString("Clock", "timeserver", timeserver, sizeof(timeserver), svr->GetParameter("timeserver"));
            if (svr->GetParameter("timeserver") && strcmp(timeserver, svr->GetParameter("timeserver")) != 0)
                {
                strcpy(timeserver, svr->GetParameter("timeserver"));
                ini.WriteString("Clock", "timeserver", timeserver);
                }
            ini.ReadString("Clock", "timezone", timezone, sizeof(timezone), svr->GetParameter("timezone"));
            if (svr->GetParameter("timezone") && strcmp(timezone, svr->GetParameter("timezone")) != 0)
                {
                strcpy(timezone, svr->GetParameter("timezone"));
                ini.WriteString("Clock", "timezone", timezone);
                }
            
            // send the header
            svr->header(200, "OK", svr->GetSupportedType(".htm"));
            // send some data
            svr->send("<html><head><title>Server Config</title></head>\r\n");
            svr->send("<body>\r\n");
            svr->send("<h1>Smart WiFly Web Server - Server Config</h1>\r\n");
            svr->send("Configure options here.<br/>\r\n");
            // Create a user form for which they can post changes
            sprintf(buf, "<form method='post' action='%s'>\r\n", path);
            svr->send(buf);
            // show the parameters in a nice format
            svr->send("<table border='1'>\r\n");
            sprintf(buf, "<tr><td>Setting</td><td>Value</td><td>Description</td></tr>\r\n");
            svr->send(buf);
            sprintf(buf, "<tr><td>SSID</td><td><input type='text' name='ssid' value='%s'></td><td>Name of the Access Point</td></tr>\r\n", ssid);
            svr->send(buf);
            sprintf(buf, "<tr><td>PassCode</td><td><input type='text' name='pass' value='%s'></td><td>Passcode</td></tr>\r\n", pass);
            svr->send(buf);
            sprintf(buf, "<tr><td>Security</td><td><input type='text' name='security' value='%s'></td><td>Security Setting</td></tr>\r\n", security);
            svr->send(buf);
            sprintf(buf, "<tr><td>Time Server</td><td><input type='text' name='timeserver' value='%s'></td><td>Time Server</td></tr>\r\n", timeserver);
            svr->send(buf);
            sprintf(buf, "<tr><td>Time Zone</td><td><input type='text' name='timezone' value='%s'></td><td>Time Zone</td></tr>\r\n", timezone);
            svr->send(buf);
            //svr->send("<tr><td>&nbsp;</td><td>File</td><td><input type='file' name='InFile' size='40'></td></tr>\r\n");
            svr->send("<tr><td>&nbsp;</td><td colspan='2'><input type='submit' value='submit'><input type='reset' value='clear'></td></tr>\r\n");
            svr->send("</table>\r\n");
            svr->send("</form>\r\n");
            // see how we're doing with free memory
            svr->send("<br/><a href='/'>Back to main</a></body></html>\r\n");
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        case HTTPServer::CONTENT_LENGTH_REQUEST:
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        case HTTPServer::DATA_TRANSFER:
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        default:
            ret = HTTPServer::ACCEPT_ERROR;
            break;
    }
    return ret;
}

