
#include "mbed.h"

#include "SW_HTTPServer.h"
#include "DynamicPages.h"
#define DEBUG "Secr"
#include "Utility.h"
#include "Base64.h"


Base64 bc64;
char * converted = NULL;
size_t convertedLen = 0;
bool accessGranted = false;

bool CredentialCheck(char * user, char * pass)
{
    INFO("CredentialCheck(%s,%s)", user, pass);
    if (strcmp(user, "user1") == 0 && strcmp(pass, "pass1") == 0)
        return true;
    else
        return false;
}


/// SimpleSecurityCheck
HTTPServer::CallBackResults SimpleSecurityCheck(HTTPServer *svr, HTTPServer::CallBackType type, const char * path, const HTTPServer::namevalue *params, int paramcount)
{
    HTTPServer::CallBackResults ret = HTTPServer::ACCEPT_ERROR;
    char buf[150];
    INFO("SecurityCheck: %d", type);
    switch (type) {
        case HTTPServer::SEND_PAGE:
            accessGranted = false;
            INFO("hdr: %s.", svr->GetHeaderValue("Authorization"));
            if (svr->GetHeaderValue("Authorization") != NULL) {
                const char * p = svr->GetHeaderValue("Authorization");
                INFO("p: %s", p);
                if (p && strncmp(p, "Basic ", 6) == 0) {
                    p += 6;
                    if (converted)          // this should never be true, but is a nice safeguard
                        free(converted);
                    converted = bc64.Decode(p, strlen(p), &convertedLen);
                    INFO("converted{%s}", converted);
                    if (converted) {
                        // Now check the actual credentials...
                        char *colon;
                        converted[convertedLen] = '\0';
                        colon = strchr(converted, ':');
                        if (colon) {
                            *colon++ = '\0';
                            if (CredentialCheck(converted, colon))
                                accessGranted = true;
                        }
                    }
                }
            }
            if (!accessGranted)
                svr->header(401, "Access Denied", "WWW-Authenticate: Basic realm='Smart HTTPServer insecure logon'\r\n");
            else {
                svr->header(200, "OK", "Content-Type: text/html\r\n");
                svr->send("<html><head><title>Security Check</title></head>\r\n");
                svr->send("<body>\r\n");
                sprintf(buf, "<h1>Welcome %s</h1>\r\n", converted);
                svr->send(buf);
                svr->send("Authorization was approved.<p/>\r\n");
                svr->send("Your browser will now cache the credentials until you close it.");
                svr->send("So, be sure to close it for maximum security (and don't let it save your credentials).<p/>\r\n");
                svr->send("<a href='/'>back to main</a></body></html>\r\n");
            }
            if (converted)
                free(converted);    // don't leak memory
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        case HTTPServer::CONTENT_LENGTH_REQUEST:
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        case HTTPServer::DATA_TRANSFER:
            ret = HTTPServer::ACCEPT_COMPLETE;
            break;
        default:
            ret = HTTPServer::ACCEPT_ERROR;
            break;
    }
    return ret;
}

