
#include "mbed.h"
#include "RA8875.h"
#include "Watchdog.h"           // ver 2
//#include "IniManager.h"         // v19

#include "SignalGenDisplay.h"
#include "SignalGenDAC.h"

RA8875 lcd(p5,p6,p7,p12, NC, "tft");             // SPI:{MOSI,MISO,SCK,/ChipSelect,/reset}, name
//INI ini;

RawSerial pc(USBTX, USBRX);
LocalFileSystem local("local");
SignalGenDAC g_signal;            // defaults to LPC1768 mbed module (p18 and 3.3v)
SignalGenDisplay ui(&lcd, &g_signal);

Watchdog wd;

int main() {
    pc.baud(460800);

    if (wd.WatchdogCausedReset()) {
        pc.printf("**** Watchdog Event caused reset ****\r\n");
    }
    wd.Configure(30.0);
    //ini.SetFile("/local/SigGen.ini", 2);

    lcd.init(480,272,16, true, true, true);
    while (true)
    {
        wd.Service();
        if (pc.readable()) {
            int c = pc.getc();
            ui.Poll(c);
        } else {
            ui.Poll();
        }
    } // End of 'while' statement
} // End of main program
 

