//
// A simple SSDP example
//
#include "mbed.h"               // testing mbed v128, mbed-rtos v121
#include "EthernetInterface.h"  // ver 55
#include "SW_HTTPServer.h"      // ver 50
#include "TimeInterface.h"      // ver 23
#include "Watchdog.h"           // ver 6
#include "SW_String.h"          // ver 1
#include "SSDP.h"               // ver 0

#include "WebPages.h"           // Private handler for web queries

extern "C" void mbed_reset();

RawSerial pc(USBTX, USBRX);

EthernetInterface eth;
TimeInterface ntp(&eth);
Watchdog wd;
time_t lastboottime;

PwmOut signOfLife(LED4);        // LED sign of life. 100% WD reset, 20% restart, sine-wave: running

//FlashFileSystem flash("flash");             // static files here for reliability and speed
LocalFileSystem local("local");             // some place to hold settings and maybe the static web pages
const char * Server_Root = "/local";

// public for the WebPages handler to see
//
const char * BUILD_DATE = __DATE__ " " __TIME__;
const char * PROG_NAME = "SSDP Server";
const char * My_Name = "MBED SSDP Node";
const char * My_SerialNum = "0000001";
int Server_Port = 80;
// end public information




/// ShowSignOfLife
///
/// Pulse an LED to indicate a sign of life of the program.
/// This also has some moderate entertainment value.
///
void ShowSignOfLife(int degreeIncrement = 1)
{
#define PI 3.14159265359
    static int degrees = 0;
    float v;

    degrees += degreeIncrement;
    v = sin(degrees * PI / 180)/2 + 0.5;
    signOfLife = v;     // a little dimmer
}

int main() {
    pc.baud(460800);
    pc.printf("\r\n%s Build %s\r\n", PROG_NAME, BUILD_DATE);
    lastboottime = ntp.timelocal();
    if (wd.WatchdogCausedReset()) {
        pc.printf("**** Watchdog Event caused reset at %s ****\r\n", ntp.ctime(&lastboottime));
    }
    wd.Configure(45);       // very generous, but this is a network appliance, so a bit less deterministic.

    int eRes = eth.init(); //Use DHCP
    if (eRes < 0) {
        printf("eth.init() returned %d, rebooting in 5 s.\r\n", eRes);
        wait(5.0);
        mbed_reset();
    }
    eRes = eth.connect();
    if (eRes < 0) {
        printf("eth.connect() returned %d, rebooting in 5 s.\r\n", eRes);
        wait(5.0);
        mbed_reset();
    }
    printf("IP: %s\r\n", eth.getIPAddress());
    //Thread thr(SSDPListener, NULL, osPriorityLow);
    HTTPServer svr(Server_Port, Server_Root, 15, 30, 20, 50, &pc);
    svr.RegisterHandler("/", RootPage);
    svr.RegisterHandler("/setup.xml", Setup_xml);
    SSDP ssdp(My_Name, eth.getMACAddress(), eth.getIPAddress(), Server_Port);

    bool setTheClock = true;    // prime it

    while (1) {
        wd.Service();
        svr.Poll();         // non-blocking, but also not deterministic
        Thread::yield();
        ShowSignOfLife(10);
        if (setTheClock) {
            setTheClock = false;
            // Could read these from non-volatile
            ntp.set_dst("3/11,2:00","11/4,2:00");   // mm/dd,hh:mm
            ntp.set_tzo_min(-360);
            int res = ntp.setTime("pool.ntp.org");
            if (res == 0) {
                pc.printf("Time was just set\r\n");
            }
        }
        static time_t tLast;
        time_t tNow = ntp.timelocal();
        if (tNow != tLast) {
            printf("time is %s\r\n", ntp.ctime(&tNow));
            tLast = tNow;
            //printf("Mem: %5d, %5d %5d\n", Thread::used_stack(), Thread::max_stack(), Thread::stack_size());
        }
    }
}
