//                                                                               
//    This script modifies a font file which was generated with a tool by        
//    MikroElektronika - GLD Font Creator.                                       
//                                                                               
//    That tool creates the font data set for an embedded system from a Windows  
//    True Type font. The user is encouraged to ensure that the font used is     
//    properly licenses, or drawn from a source that does not have a license     
//    restriction.                                                               
//                                                                               
//    This script will read and then modify the file for a few specific purposes:
//      * <space>   character is redefined to set the width to 1/4 the height.   
//      * '0' - '9' characters are redefined to set the width equal to width('0')
//                  or to the user override value.                               
//                                                                               
//    And just because it can, it then improves upon the documentation in the    
//    resulting data structure.                                                  
//                                                                               
//    This script was created by Smartware Computing, and is provided 'as is'    
//    with no warranty or suitability of fitness for any purpose. Anyone may use 
//    or modify it subject to the agreement that:                                
//      * The Smartware copyright statement remains intact.                      
//      * Modifications for derivative use are clearly stated in this header.    
//                                                                               
//    Modifications from the original:                                           
//      * none.                                                                  
//                                                                               
// Script Activation:
//   ParseMikroeFont BPG_Arial31x32.h New_BPG_Arial31x32.h

//Font Generated by MikroElektronika GLCD Font Creator 1.2.0.0
//MikroElektrnika 2011 
//http://www.mikroe.com 

//GLCD FontName : BPG_Arial31x32
//GLCD FontSize : 31 x 32

const unsigned char BPG_Arial31x32[] = {
    // Font Info
    0x00,                   // Unknown #1
    0x00,                   // Unknown #2
    0x20,0x00,              // FirstChar
    0x7F,0x00,              // LastChar
    0x20,                   // FontHeight
    0x00,                   // Unknown #3
    // Directory of Chars  [Width] [Offset-L] [Offset-M] [Offset-H]
    0x08,0x88,0x01,0x00,    // 0x20 ' ' 
    0x06,0xA8,0x01,0x00,    // 0x21 '!' 
    0x0A,0xC8,0x01,0x00,    // 0x22 '"' 
    0x11,0x08,0x02,0x00,    // 0x23 '#' 
    0x10,0x68,0x02,0x00,    // 0x24 '$' 
    0x1A,0xA8,0x02,0x00,    // 0x25 '%' 
    0x14,0x28,0x03,0x00,    // 0x26 '&' 
    0x05,0x88,0x03,0x00,    // 0x27 ''' 
    0x09,0xA8,0x03,0x00,    // 0x28 '(' 
    0x09,0xE8,0x03,0x00,    // 0x29 ')' 
    0x0B,0x28,0x04,0x00,    // 0x2A '*' 
    0x11,0x68,0x04,0x00,    // 0x2B '+' 
    0x06,0xC8,0x04,0x00,    // 0x2C ',' 
    0x0A,0xE8,0x04,0x00,    // 0x2D '-' 
    0x06,0x28,0x05,0x00,    // 0x2E '.' 
    0x09,0x48,0x05,0x00,    // 0x2F '/' 
    0x11,0x88,0x05,0x00,    // 0x30 '0' 
    0x11,0xE8,0x05,0x00,    // 0x31 '1' 
    0x11,0x48,0x06,0x00,    // 0x32 '2' 
    0x11,0xA8,0x06,0x00,    // 0x33 '3' 
    0x11,0x08,0x07,0x00,    // 0x34 '4' 
    0x11,0x68,0x07,0x00,    // 0x35 '5' 
    0x11,0xC8,0x07,0x00,    // 0x36 '6' 
    0x11,0x28,0x08,0x00,    // 0x37 '7' 
    0x11,0x88,0x08,0x00,    // 0x38 '8' 
    0x11,0xE8,0x08,0x00,    // 0x39 '9' 
    0x06,0x48,0x09,0x00,    // 0x3A ':' 
    0x06,0x68,0x09,0x00,    // 0x3B ';' 
    0x11,0x88,0x09,0x00,    // 0x3C '<' 
    0x11,0xE8,0x09,0x00,    // 0x3D '=' 
    0x11,0x48,0x0A,0x00,    // 0x3E '>' 
    0x10,0xA8,0x0A,0x00,    // 0x3F '?' 
    0x1F,0xE8,0x0A,0x00,    // 0x40 '@' 
    0x15,0x68,0x0B,0x00,    // 0x41 'A' 
    0x14,0xC8,0x0B,0x00,    // 0x42 'B' 
    0x16,0x28,0x0C,0x00,    // 0x43 'C' 
    0x15,0x88,0x0C,0x00,    // 0x44 'D' 
    0x14,0xE8,0x0C,0x00,    // 0x45 'E' 
    0x12,0x48,0x0D,0x00,    // 0x46 'F' 
    0x17,0xA8,0x0D,0x00,    // 0x47 'G' 
    0x15,0x08,0x0E,0x00,    // 0x48 'H' 
    0x06,0x68,0x0E,0x00,    // 0x49 'I' 
    0x0E,0x88,0x0E,0x00,    // 0x4A 'J' 
    0x15,0xC8,0x0E,0x00,    // 0x4B 'K' 
    0x11,0x28,0x0F,0x00,    // 0x4C 'L' 
    0x18,0x88,0x0F,0x00,    // 0x4D 'M' 
    0x14,0xE8,0x0F,0x00,    // 0x4E 'N' 
    0x17,0x48,0x10,0x00,    // 0x4F 'O' 
    0x14,0xA8,0x10,0x00,    // 0x50 'P' 
    0x17,0x08,0x11,0x00,    // 0x51 'Q' 
    0x16,0x68,0x11,0x00,    // 0x52 'R' 
    0x14,0xC8,0x11,0x00,    // 0x53 'S' 
    0x13,0x28,0x12,0x00,    // 0x54 'T' 
    0x15,0x88,0x12,0x00,    // 0x55 'U' 
    0x15,0xE8,0x12,0x00,    // 0x56 'V' 
    0x1E,0x48,0x13,0x00,    // 0x57 'W' 
    0x15,0xC8,0x13,0x00,    // 0x58 'X' 
    0x15,0x28,0x14,0x00,    // 0x59 'Y' 
    0x13,0x88,0x14,0x00,    // 0x5A 'Z' 
    0x08,0xE8,0x14,0x00,    // 0x5B '[' 
    0x09,0x08,0x15,0x00,    // 0x5C '\\' 
    0x07,0x48,0x15,0x00,    // 0x5D ']' 
    0x0E,0x68,0x15,0x00,    // 0x5E '^' 
    0x12,0xA8,0x15,0x00,    // 0x5F '_' 
    0x07,0x08,0x16,0x00,    // 0x60 '`' 
    0x10,0x28,0x16,0x00,    // 0x61 'a' 
    0x10,0x68,0x16,0x00,    // 0x62 'b' 
    0x10,0xA8,0x16,0x00,    // 0x63 'c' 
    0x0F,0xE8,0x16,0x00,    // 0x64 'd' 
    0x10,0x28,0x17,0x00,    // 0x65 'e' 
    0x0A,0x68,0x17,0x00,    // 0x66 'f' 
    0x10,0xA8,0x17,0x00,    // 0x67 'g' 
    0x10,0xE8,0x17,0x00,    // 0x68 'h' 
    0x05,0x28,0x18,0x00,    // 0x69 'i' 
    0x05,0x48,0x18,0x00,    // 0x6A 'j' 
    0x10,0x68,0x18,0x00,    // 0x6B 'k' 
    0x05,0xA8,0x18,0x00,    // 0x6C 'l' 
    0x19,0xC8,0x18,0x00,    // 0x6D 'm' 
    0x10,0x48,0x19,0x00,    // 0x6E 'n' 
    0x11,0x88,0x19,0x00,    // 0x6F 'o' 
    0x10,0xE8,0x19,0x00,    // 0x70 'p' 
    0x10,0x28,0x1A,0x00,    // 0x71 'q' 
    0x0B,0x68,0x1A,0x00,    // 0x72 'r' 
    0x0F,0xA8,0x1A,0x00,    // 0x73 's' 
    0x09,0xE8,0x1A,0x00,    // 0x74 't' 
    0x10,0x28,0x1B,0x00,    // 0x75 'u' 
    0x10,0x68,0x1B,0x00,    // 0x76 'v' 
    0x17,0xA8,0x1B,0x00,    // 0x77 'w' 
    0x0F,0x08,0x1C,0x00,    // 0x78 'x' 
    0x10,0x48,0x1C,0x00,    // 0x79 'y' 
    0x0F,0x88,0x1C,0x00,    // 0x7A 'z' 
    0x0A,0xC8,0x1C,0x00,    // 0x7B '{' 
    0x05,0x08,0x1D,0x00,    // 0x7C '|' 
    0x0A,0x28,0x1D,0x00,    // 0x7D '}' 
    0x11,0x68,0x1D,0x00,    // 0x7E '~' 
    0x08,0xC8,0x1D,0x00,    // 0x7F '<non-printable>' 
    // Chars Bitstream
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x20 ' '
    0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x10,0x00,0x00,0x00,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x21 '!'
    0x00,0x00,0x00,0x00,0x9E,0x03,0x9E,0x03,0x9E,0x03,0x9E,0x03,0x9C,0x03,0x8C,0x03,0x8C,0x01,0x8C,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x22 '"'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC1,0x00,0xC0,0xE0,0x00,0xC0,0x60,0x00,0xC0,0x60,0x00,0xE0,0x60,0x00,0xE0,0x60,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x70,0x30,0x00,0x70,0x38,0x00,0x30,0x38,0x00,0x30,0x18,0x00,0x30,0x18,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x18,0x0C,0x00,0x18,0x0C,0x00,0x1C,0x0C,0x00,0x1C,0x0E,0x00,0x0C,0x0E,0x00,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x23 '#'
    0x00,0x03,0x80,0x07,0xF0,0x1F,0xF8,0x3F,0x3C,0x7B,0x1C,0x73,0x1C,0xE3,0x0C,0x03,0x1C,0x03,0x1C,0x03,0x3C,0x03,0xF8,0x03,0xF0,0x0F,0xC0,0x3F,0x00,0x7F,0x00,0xF3,0x00,0xE3,0x00,0xE3,0x0C,0xE3,0x0E,0xE3,0x1E,0xE3,0x1C,0xF3,0x3C,0x7B,0xF8,0x3F,0xF0,0x1F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x24 '$'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x18,0x00,0xF8,0x03,0x1C,0x00,0x1C,0x07,0x0C,0x00,0x1C,0x06,0x0E,0x00,0x0C,0x0E,0x06,0x00,0x0C,0x0E,0x07,0x00,0x0C,0x0E,0x03,0x00,0x0C,0x8E,0x03,0x00,0x1C,0x86,0x01,0x00,0x38,0xC7,0x01,0x00,0xF8,0xC3,0x00,0x00,0xE0,0x60,0x00,0x00,0x00,0x60,0xF8,0x00,0x00,0x30,0xFC,0x01,0x00,0x30,0x8E,0x03,0x00,0x18,0x06,0x03,0x00,0x18,0x06,0x03,0x00,0x0C,0x06,0x03,0x00,0x0C,0x06,0x03,0x00,0x06,0x06,0x03,0x00,0x06,0x0E,0x03,0x00,0x03,0x8C,0x03,0x80,0x03,0xFC,0x01,0x80,0x01,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x25 '%'
    0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xE0,0x78,0x00,0x70,0x70,0x00,0x70,0x70,0x00,0x70,0x70,0x00,0xE0,0x70,0x00,0xE0,0x39,0x00,0xC0,0x1F,0x00,0x80,0x0F,0x00,0xC0,0x07,0x00,0xF0,0x0F,0x00,0x78,0x1E,0x01,0x3C,0x3C,0x07,0x1C,0xB8,0x07,0x1E,0xF8,0x03,0x0E,0xF0,0x03,0x1E,0xE0,0x01,0x1C,0xE0,0x03,0x3C,0xF0,0x07,0x78,0xF8,0x0F,0xF0,0x3F,0x0F,0xE0,0x0F,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x26 '&'
    0x00,0x00,0x1E,0x1E,0x1E,0x1E,0x1C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x27 '''
    0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x00,0xC0,0x00,0x60,0x00,0x70,0x00,0x70,0x00,0x30,0x00,0x38,0x00,0x38,0x00,0x18,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x30,0x00,0x70,0x00,0x60,0x00,0xE0,0x00,0xC0,0x00,0x80,0x01,0x80,0x01,  // 0x28 '('
    0x00,0x00,0x00,0x00,0x1C,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xE0,0x00,0xC0,0x00,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0xE0,0x00,0xE0,0x00,0x60,0x00,0x70,0x00,0x30,0x00,0x38,0x00,0x18,0x00,0x0C,0x00,  // 0x29 ')'
    0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x64,0x06,0xFE,0x07,0xFC,0x07,0xF0,0x00,0xF0,0x01,0x98,0x03,0x18,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2A '*'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2B '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x30,0x30,0x30,0x18,0x08,0x00,0x00,  // 0x2C ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x03,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2D '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2E '.'
    0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xE0,0x00,0x60,0x00,0x60,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x38,0x00,0x18,0x00,0x18,0x00,0x1C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2F '/'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xF0,0x1F,0x00,0xF0,0x3C,0x00,0x38,0x78,0x00,0x1C,0x70,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x0C,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0C,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0x70,0x00,0x38,0x70,0x00,0x78,0x38,0x00,0xF0,0x3F,0x00,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x30 '0'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0xC0,0x0F,0x00,0xF0,0x0F,0x00,0x78,0x0E,0x00,0x38,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x31 '1'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xF0,0x3F,0x00,0x78,0x7C,0x00,0x3C,0x70,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x0C,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0xFC,0xFF,0x00,0xFE,0xFF,0x00,0xFE,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x32 '2'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0xF0,0x1F,0x00,0x78,0x3C,0x00,0x3C,0x78,0x00,0x1C,0x70,0x00,0x1C,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x3E,0x00,0x80,0x0F,0x00,0x80,0x3F,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x0E,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0xF0,0x00,0x38,0x78,0x00,0xF0,0x3F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x33 '3'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x1D,0x00,0xC0,0x1C,0x00,0xE0,0x1C,0x00,0x70,0x1C,0x00,0x30,0x1C,0x00,0x38,0x1C,0x00,0x1C,0x1C,0x00,0x0E,0x1C,0x00,0x06,0x1C,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x34 '4'
    0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x7F,0x00,0xF0,0x7F,0x00,0xF0,0x7F,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x18,0x00,0x00,0xD8,0x1F,0x00,0xFC,0x3F,0x00,0x7C,0x7C,0x00,0x1C,0xF0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xC0,0x01,0x00,0xE0,0x00,0x0E,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0x70,0x00,0x38,0x78,0x00,0xF8,0x3F,0x00,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x35 '5'
    0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0F,0x00,0xE0,0x3F,0x00,0xF0,0x7C,0x00,0x38,0x70,0x00,0x38,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0x00,0x00,0x0C,0x00,0x00,0x8E,0x0F,0x00,0xCE,0x3F,0x00,0xEE,0x7F,0x00,0x3E,0x70,0x00,0x1E,0xE0,0x00,0x1E,0xE0,0x00,0x1E,0xE0,0x00,0x0E,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x38,0x70,0x00,0x78,0x78,0x00,0xF0,0x3F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x36 '6'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x00,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x01,0x00,0xC0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x37 '7'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xF0,0x1F,0x00,0xF8,0x3C,0x00,0x38,0x70,0x00,0x1C,0x70,0x00,0x1C,0x60,0x00,0x1C,0x60,0x00,0x1C,0x70,0x00,0x38,0x78,0x00,0xF0,0x3F,0x00,0xE0,0x0F,0x00,0xF0,0x3F,0x00,0x38,0x78,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xC0,0x00,0x0E,0xE0,0x00,0x1C,0xE0,0x00,0x1C,0xF0,0x00,0x78,0x78,0x00,0xF0,0x3F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x38 '8'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0xF0,0x1F,0x00,0xF8,0x3C,0x00,0x3C,0x70,0x00,0x1C,0x60,0x00,0x1C,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x0E,0xE0,0x00,0x1C,0xE0,0x00,0x3C,0xF0,0x00,0x78,0xDC,0x00,0xF0,0xDF,0x00,0xE0,0xE7,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x1C,0x70,0x00,0x1C,0x70,0x00,0x38,0x38,0x00,0xF8,0x1F,0x00,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x39 '9'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3A ':'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x30,0x30,0x30,0x18,0x08,0x00,0x00,  // 0x3B ';'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0xE0,0x01,0x00,0xF8,0x01,0x00,0x7E,0x00,0xC0,0x1F,0x00,0xF0,0x03,0x00,0xFC,0x00,0x00,0x1C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x01,0x00,0xE0,0x0F,0x00,0x00,0x3F,0x00,0x00,0xFC,0x01,0x00,0xF0,0x01,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3C '<'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3D '='
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x1C,0x00,0x00,0xFC,0x00,0x00,0xF0,0x03,0x00,0xC0,0x1F,0x00,0x00,0x7F,0x00,0x00,0xF8,0x01,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,0xFE,0x00,0x80,0x1F,0x00,0xE0,0x07,0x00,0xFC,0x01,0x00,0x3C,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3E '>'
    0x00,0x00,0x00,0x00,0xE0,0x1F,0xF0,0x3F,0x78,0x78,0x3C,0xF0,0x1C,0xE0,0x1C,0xE0,0x08,0xE0,0x00,0xE0,0x00,0xF0,0x00,0x78,0x00,0x3C,0x00,0x1E,0x00,0x0F,0x00,0x07,0x00,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3F '?'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x3F,0x00,0x00,0xFE,0xFF,0x01,0x00,0x1F,0xE0,0x03,0x80,0x07,0x80,0x07,0xC0,0x01,0x00,0x0E,0xE0,0x00,0x00,0x1C,0x70,0xC0,0x03,0x18,0x30,0xF0,0xE7,0x38,0x38,0x78,0x6E,0x30,0x18,0x1C,0x78,0x30,0x18,0x0E,0x78,0x30,0x1C,0x0E,0x78,0x70,0x0C,0x07,0x70,0x70,0x0C,0x07,0x30,0x30,0x0C,0x07,0x38,0x30,0x0C,0x07,0x38,0x30,0x0C,0x07,0x38,0x38,0x0C,0x07,0x1C,0x1C,0x0C,0x07,0x1C,0x0C,0x1C,0x0F,0x1E,0x0F,0x1C,0x9E,0xFF,0x07,0x18,0xFC,0xFD,0x03,0x38,0xF8,0xF8,0x00,0x70,0x00,0x00,0x70,0xE0,0x00,0x00,0x38,0xE0,0x01,0x00,0x1E,0x80,0x0F,0x80,0x0F,0x00,0xFF,0xFF,0x07,0x00,0xFC,0xFF,0x01,0x00,0xC0,0x1F,0x00,  // 0x40 '@'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x1B,0x00,0x80,0x3B,0x00,0x80,0x3B,0x00,0xC0,0x71,0x00,0xC0,0x71,0x00,0xC0,0x70,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x70,0xC0,0x01,0x70,0xC0,0x01,0x70,0xC0,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x3C,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x0F,0x0E,0x00,0x0E,0x0E,0x00,0x0E,0x0E,0x00,0x1E,0x07,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x41 'A'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x01,0x1C,0xC0,0x03,0x1C,0x80,0x03,0x1C,0x80,0x07,0x1C,0x00,0x07,0x1C,0x80,0x03,0x1C,0x80,0x03,0x1C,0xE0,0x01,0xFC,0xFF,0x00,0xFC,0xFF,0x01,0x1C,0xF0,0x03,0x1C,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x0F,0x1C,0x00,0x0F,0x1C,0x00,0x07,0x1C,0x80,0x07,0xFC,0xFF,0x03,0xFC,0xFF,0x01,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x42 'B'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xC0,0xFF,0x03,0xE0,0xC3,0x07,0xF0,0x00,0x0F,0x78,0x00,0x1E,0x38,0x00,0x1C,0x3C,0x00,0x1C,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x18,0x3C,0x00,0x3C,0x38,0x00,0x1C,0x78,0x00,0x1E,0xF0,0x00,0x0F,0xE0,0xC3,0x07,0xC0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x43 'C'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x7F,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x0E,0x3C,0x00,0x1E,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1C,0x3C,0x00,0x1E,0x3C,0x00,0x0E,0x3C,0x00,0x0F,0x3C,0x80,0x07,0xFC,0xFF,0x03,0xFC,0xFF,0x01,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x44 'D'
    0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0xF8,0xFF,0x07,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0xF8,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x45 'E'
    0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0xF8,0xFF,0x03,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0xF8,0xFF,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x46 'F'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0xC0,0xFF,0x0F,0xE0,0x87,0x1F,0xF0,0x00,0x1E,0x70,0x00,0x38,0x38,0x00,0x38,0x38,0x00,0x70,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0xE0,0x7F,0x1C,0xE0,0x7F,0x1C,0xE0,0x7F,0x1C,0x00,0x70,0x1C,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x70,0x70,0x00,0x70,0xF0,0x01,0x7C,0xE0,0x87,0x3F,0x80,0xFF,0x0F,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x47 'G'
    0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0xF8,0xFF,0x1F,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x48 'H'
    0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x49 'I'
    0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x0E,0x3C,0x0E,0x1C,0x0E,0x1C,0x0E,0x1C,0x3C,0x1F,0xFC,0x0F,0xF8,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4A 'J'
    0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x0F,0x1C,0x80,0x07,0x1C,0xC0,0x03,0x1C,0xE0,0x01,0x1C,0xF0,0x00,0x1C,0x78,0x00,0x1C,0x3C,0x00,0x1C,0x1E,0x00,0x1C,0x0F,0x00,0x9C,0x07,0x00,0xDC,0x0F,0x00,0xFC,0x1F,0x00,0xFC,0x3C,0x00,0x7C,0x38,0x00,0x3C,0x78,0x00,0x1C,0xF0,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x01,0x1C,0xC0,0x03,0x1C,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x0F,0x1C,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4B 'K'
    0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4C 'L'
    0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0xF0,0x7C,0x00,0xF0,0xFC,0x00,0xF8,0xFC,0x00,0xF8,0xDC,0x00,0xF8,0xDC,0x01,0xFC,0xDC,0x01,0xEC,0x9C,0x01,0xEC,0x9C,0x03,0xEE,0x9C,0x03,0xE6,0x1C,0x03,0xE6,0x1C,0x07,0xE7,0x1C,0x07,0xE3,0x1C,0x06,0xE3,0x1C,0x8E,0xE3,0x1C,0x8E,0xE1,0x1C,0x8C,0xE1,0x1C,0xDC,0xE1,0x1C,0xDC,0xE0,0x1C,0xD8,0xE0,0x1C,0xF8,0xE0,0x1C,0x78,0xE0,0x1C,0x70,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4D 'M'
    0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0C,0x3C,0x00,0x0C,0x7C,0x00,0x0C,0xFC,0x00,0x0C,0xFC,0x00,0x0C,0xDC,0x01,0x0C,0xDC,0x03,0x0C,0x9C,0x07,0x0C,0x1C,0x07,0x0C,0x1C,0x0F,0x0C,0x1C,0x1E,0x0C,0x1C,0x1C,0x0C,0x1C,0x3C,0x0C,0x1C,0x78,0x0C,0x1C,0x70,0x0C,0x1C,0xF0,0x0C,0x1C,0xE0,0x0D,0x1C,0xC0,0x0D,0x1C,0xC0,0x0F,0x1C,0x80,0x0F,0x1C,0x00,0x0F,0x1C,0x00,0x0F,0x1C,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4E 'N'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xC0,0xFF,0x07,0xE0,0xC7,0x0F,0xF0,0x00,0x1E,0x78,0x00,0x3C,0x38,0x00,0x38,0x3C,0x00,0x78,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x3C,0x00,0x78,0x38,0x00,0x38,0x78,0x00,0x3C,0xF0,0x00,0x1E,0xE0,0x83,0x0F,0xC0,0xFF,0x07,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4F 'O'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x7F,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x07,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x0E,0x3C,0x00,0x0E,0x3C,0x00,0x0E,0x3C,0x00,0x0E,0x3C,0x00,0x07,0x3C,0x80,0x07,0xFC,0xFF,0x03,0xFC,0xFF,0x01,0xFC,0x3F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x50 'P'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xC0,0xFF,0x07,0xE0,0xC3,0x0F,0xF0,0x00,0x1E,0x78,0x00,0x1C,0x38,0x00,0x38,0x1C,0x00,0x38,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1E,0x00,0x70,0x1E,0x00,0x70,0x1E,0x00,0x70,0x1E,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x38,0x38,0x60,0x38,0x78,0xE0,0x1D,0xF0,0xC0,0x1F,0xE0,0x83,0x0F,0xC0,0xFF,0x1F,0x00,0xFF,0x79,0x00,0x00,0x70,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x51 'Q'
    0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0x01,0xF8,0xFF,0x07,0xF8,0xFF,0x0F,0x38,0x00,0x0F,0x38,0x00,0x1E,0x38,0x00,0x1C,0x38,0x00,0x1C,0x38,0x00,0x1C,0x38,0x00,0x0E,0x38,0x00,0x0F,0xF8,0xFF,0x07,0xF8,0xFF,0x03,0xF8,0x7F,0x00,0x38,0xF0,0x00,0x38,0xE0,0x01,0x38,0xC0,0x03,0x38,0x80,0x07,0x38,0x80,0x07,0x38,0x00,0x0F,0x38,0x00,0x0E,0x38,0x00,0x1E,0x38,0x00,0x3C,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x52 'R'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x7F,0x00,0xF0,0xFF,0x01,0xF8,0xF1,0x03,0x38,0x80,0x03,0x38,0x80,0x07,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x07,0x00,0xE0,0x7F,0x00,0x80,0xFF,0x01,0x00,0xFC,0x03,0x00,0xC0,0x07,0x00,0x00,0x07,0x08,0x00,0x0F,0x1C,0x00,0x0E,0x1C,0x00,0x0E,0x1C,0x00,0x07,0x78,0x80,0x07,0xF8,0xE1,0x03,0xF0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x53 'S'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x54 'T'
    0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x1E,0x38,0x00,0x0E,0x38,0x00,0x0E,0x38,0x00,0x0E,0x78,0x00,0x0E,0x70,0x00,0x07,0xF0,0xE3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x55 'U'
    0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x1C,0x0E,0x00,0x1E,0x0E,0x00,0x0E,0x1E,0x00,0x0E,0x1C,0x00,0x07,0x1C,0x00,0x07,0x38,0x00,0x07,0x38,0x80,0x03,0x38,0x80,0x03,0x70,0x80,0x01,0x70,0xC0,0x01,0xE0,0xC0,0x01,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0xC0,0x61,0x00,0xC0,0x71,0x00,0xC0,0x71,0x00,0x80,0x33,0x00,0x80,0x3B,0x00,0x00,0x1B,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x56 'V'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xE0,0x01,0x38,0x0E,0xE0,0x01,0x1C,0x0E,0xE0,0x03,0x1C,0x0E,0xF0,0x03,0x1C,0x1C,0x70,0x03,0x1C,0x1C,0x30,0x07,0x0E,0x1C,0x30,0x07,0x0E,0x1C,0x38,0x07,0x0E,0x18,0x38,0x06,0x0E,0x38,0x18,0x0E,0x06,0x38,0x1C,0x0E,0x07,0x38,0x1C,0x0E,0x07,0x30,0x0C,0x1C,0x03,0x70,0x0C,0x1C,0x03,0x70,0x0E,0x9C,0x03,0x70,0x0E,0x98,0x03,0x60,0x06,0x98,0x01,0xE0,0x06,0xB8,0x01,0xE0,0x07,0xF8,0x01,0xC0,0x07,0xF0,0x01,0xC0,0x03,0xF0,0x00,0xC0,0x03,0xF0,0x00,0xC0,0x03,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x57 'W'
    0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x0E,0x3C,0x00,0x07,0x38,0x80,0x07,0x70,0x80,0x03,0xF0,0xC0,0x01,0xE0,0xE1,0x00,0xC0,0xF1,0x00,0xC0,0x73,0x00,0x80,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3F,0x00,0x80,0x3F,0x00,0xC0,0x7B,0x00,0xC0,0xF1,0x00,0xE0,0xE0,0x00,0xF0,0xC0,0x01,0x78,0xC0,0x03,0x38,0x80,0x07,0x3C,0x00,0x07,0x1E,0x00,0x0F,0x0E,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x58 'X'
    0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x1E,0x1E,0x00,0x0E,0x1C,0x00,0x07,0x3C,0x80,0x07,0x78,0x80,0x03,0x70,0xC0,0x01,0xF0,0xE0,0x01,0xE0,0xE1,0x00,0xC0,0x71,0x00,0xC0,0x7B,0x00,0x80,0x3B,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x59 'Y'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0xFE,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5A 'Z'
    0x00,0x00,0xFC,0xFC,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0xFC,0xFC,0x00,  // 0x5B '['
    0x00,0x00,0x00,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x1C,0x00,0x18,0x00,0x18,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0xE0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5C '\\'
    0x00,0x00,0x7E,0x7E,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x7E,0x7E,0x00,  // 0x5D ']'
    0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xE0,0x03,0x60,0x03,0x70,0x07,0x30,0x06,0x38,0x0E,0x38,0x0E,0x1C,0x1C,0x1C,0x1C,0x0C,0x18,0x0E,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5E '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x03,0xFF,0xFF,0x03,0x00,0x00,0x00,  // 0x5F '_'
    0x00,0x00,0x1C,0x38,0x38,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x60 '`'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xF0,0x3F,0x78,0x7C,0x1C,0x70,0x1C,0x60,0x00,0xE0,0x00,0xE0,0x80,0xFF,0xF0,0xFF,0xFC,0xE3,0x1C,0xE0,0x0E,0xE0,0x0E,0xF0,0x0E,0xF0,0x1C,0xFC,0xFC,0xEF,0xF8,0xE7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x61 'a'
    0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x9C,0x0F,0xFC,0x1F,0xFC,0x3C,0x3C,0x70,0x1C,0x70,0x1C,0xE0,0x1C,0xE0,0x0C,0xE0,0x0C,0xE0,0x0C,0xE0,0x0C,0xE0,0x1C,0xE0,0x1C,0xE0,0x3C,0x70,0x7C,0x38,0xEC,0x3F,0xCC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x62 'b'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xF0,0x1F,0xF8,0x3C,0x3C,0x70,0x1C,0x70,0x1C,0x20,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0C,0xE0,0x1C,0x60,0x1C,0x70,0x78,0x38,0xF0,0x3F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x63 'c'
    0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0xC0,0x63,0xF0,0x6F,0x78,0x7E,0x3C,0x78,0x1C,0x70,0x0E,0x70,0x0E,0x60,0x0E,0x60,0x0E,0x60,0x0E,0x60,0x0E,0x60,0x0E,0x60,0x1C,0x70,0x1C,0x70,0x38,0x78,0xF0,0x6F,0xE0,0x67,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x64 'd'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xF0,0x1F,0xF8,0x7C,0x3C,0x70,0x1C,0xE0,0x1C,0xE0,0x0E,0xE0,0xFE,0xFF,0xFE,0xFF,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x1C,0xE0,0x3C,0xF0,0x78,0x78,0xF0,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x65 'e'
    0x00,0x00,0x00,0x00,0xF0,0x03,0xF8,0x03,0x78,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xFF,0x01,0xFF,0x01,0xFF,0x01,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x66 'f'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xE7,0xF0,0xEF,0x78,0xFC,0x3C,0xF8,0x1C,0xF0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x1C,0xF0,0x3C,0xF8,0x78,0xFC,0xF0,0xEF,0xE0,0xE7,0x00,0xE0,0x00,0x60,0x0C,0x70,0x1C,0x78,0xFC,0x3F,0xF0,0x1F,0xC0,0x03,  // 0x67 'g'
    0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x9C,0x1F,0xDC,0x3F,0xFC,0x7D,0x3C,0x70,0x3C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x68 'h'
    0x00,0x00,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x69 'i'
    0x00,0x00,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x0F,0x0F,0x03,  // 0x6A 'j'
    0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x70,0x1C,0x38,0x1C,0x1C,0x1C,0x0E,0x1C,0x07,0x9C,0x03,0xDC,0x01,0xFC,0x03,0xFC,0x03,0x3C,0x07,0x1C,0x0F,0x1C,0x0E,0x1C,0x1E,0x1C,0x3C,0x1C,0x38,0x1C,0x78,0x1C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6B 'k'
    0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6C 'l'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x0F,0x3E,0x00,0xDC,0x3F,0x7F,0x00,0xFC,0xBD,0xFB,0x00,0x3C,0xF8,0xE0,0x00,0x3C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x1C,0x70,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6D 'm'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x1F,0xDC,0x3F,0xFC,0x7D,0x3C,0x70,0x3C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6E 'n'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0xF0,0x3F,0x00,0xF8,0x7C,0x00,0x3C,0xF0,0x00,0x1C,0xE0,0x00,0x1C,0xE0,0x00,0x0E,0xC0,0x01,0x0E,0xC0,0x01,0x0E,0xC0,0x01,0x0E,0xC0,0x01,0x0E,0xC0,0x01,0x0C,0xC0,0x01,0x1C,0xE0,0x00,0x3C,0xF0,0x00,0x78,0x78,0x00,0xF0,0x3F,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6F 'o'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCE,0x07,0xEE,0x1F,0x7E,0x3C,0x3E,0x38,0x1E,0x70,0x0E,0x70,0x0E,0x60,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0x70,0x0E,0x70,0x1E,0x78,0x3E,0x3C,0xFE,0x1F,0xEE,0x0F,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,  // 0x70 'p'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xE7,0xF0,0xEF,0x78,0xFC,0x3C,0xF8,0x1C,0xF0,0x1C,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0C,0xE0,0x1C,0xF0,0x3C,0xF0,0x78,0xF8,0xF0,0xFF,0xE0,0xE7,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x00,  // 0x71 'q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x03,0xDC,0x07,0xFC,0x07,0x3C,0x00,0x3C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x72 'r'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF8,0x1F,0x3C,0x1E,0x0C,0x38,0x0E,0x38,0x1C,0x00,0x7C,0x00,0xFC,0x03,0xF0,0x1F,0xC0,0x3F,0x00,0x3C,0x00,0x70,0x0E,0x70,0x0E,0x70,0x3C,0x38,0xF8,0x1F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x73 's'
    0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xFE,0x00,0xFE,0x00,0xFE,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x38,0x00,0xF8,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x74 't'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xE0,0x1C,0xF0,0x1C,0xF0,0x38,0xFC,0xF8,0xEF,0xF0,0xE7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x75 'u'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x0E,0x70,0x0E,0x70,0x0C,0x30,0x1C,0x38,0x1C,0x38,0x38,0x18,0x38,0x1C,0x38,0x1C,0x70,0x0E,0x70,0x0E,0x60,0x06,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x76 'v'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x1C,0x70,0x07,0x1C,0x70,0x0E,0x3C,0x30,0x0E,0x3E,0x38,0x0E,0x36,0x38,0x0C,0x36,0x18,0x1C,0x77,0x1C,0x1C,0x77,0x1C,0x18,0x73,0x0C,0x38,0x63,0x0E,0xB8,0xE3,0x0E,0xB8,0xE3,0x06,0xB0,0xC1,0x06,0xF0,0xC1,0x07,0xF0,0xC1,0x03,0xE0,0xC1,0x03,0xE0,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x77 'w'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x70,0x1E,0x78,0x3C,0x3C,0x38,0x1C,0x70,0x0E,0xF0,0x0F,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xE0,0x07,0x70,0x0E,0x78,0x1E,0x38,0x1C,0x1C,0x38,0x1E,0x78,0x0E,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x78 'x'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0xE0,0x0E,0x60,0x0E,0x70,0x1C,0x70,0x1C,0x38,0x1C,0x38,0x38,0x18,0x38,0x1C,0x30,0x1C,0x70,0x0C,0x70,0x0E,0xE0,0x0E,0xE0,0x06,0xE0,0x07,0xC0,0x03,0xC0,0x03,0x80,0x03,0x80,0x01,0xC0,0x01,0xC0,0x01,0xE0,0x00,0xFC,0x00,0x7C,0x00,0x1C,0x00,  // 0x79 'y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x7F,0xFE,0x7F,0xFE,0x7F,0x00,0x3C,0x00,0x1C,0x00,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x01,0xF0,0x00,0x78,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7A 'z'
    0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x03,0xE0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x30,0x00,0x38,0x00,0x1E,0x00,0x0E,0x00,0x1E,0x00,0x38,0x00,0x30,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xE0,0x03,0xE0,0x03,0x80,0x03,  // 0x7B '{'
    0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,  // 0x7C '|'
    0x00,0x00,0x00,0x00,0x1E,0x00,0x3E,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xE0,0x00,0xE0,0x03,0x80,0x03,0xC0,0x03,0xE0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x3E,0x00,0x1E,0x00,0x0E,0x00,  // 0x7D '}'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xFC,0x03,0x01,0xFE,0xFF,0x01,0x8E,0xFF,0x01,0x02,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7E '~'
    0x00,0x00,0xFE,0xFE,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xC2,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00  // 0x7F '<non-printable>'
};