//
// RA8875 Display Controller Register Definitions.
//
//
#ifndef RA8875_REGS_H
#define RA8875_REGS_H

// Touch Panel public macros
#define RESISTIVE_TOUCH_POINTS 1

/* Touch Panel Enable/Disable Reg TPCR0[7] */
#define TP_ENABLE   ((uint8_t)(1<<7))
#define TP_DISABLE  ((uint8_t)(0<<7))

/* Touch Panel operating mode Reg TPCR1[6] */
#define TP_MODE_AUTO    ((uint8_t)(0<<6))
#define TP_MODE_MANUAL  ((uint8_t)(1<<6))

/* Touch Panel debounce Reg TPCR1[2]    */
#define TP_DEBOUNCE_OFF ((uint8_t)(0<<2))
#define TP_DEBOUNCE_ON  ((uint8_t)(1<<2))

/* Touch Panel manual modes Reg TPCR1[1:0]  */
#define TP_MANUAL_IDLE      0
#define TP_MANUAL_WAIT      1
#define TP_MANUAL_LATCH_X   2
#define TP_MANUAL_LATCH_Y   3

/* Touch Panel ADC Clock modes Reg TPCR0[2:0] */
#define TP_ADC_CLKDIV_1            0
#define TP_ADC_CLKDIV_2            1
#define TP_ADC_CLKDIV_4            2
#define TP_ADC_CLKDIV_8            3
#define TP_ADC_CLKDIV_16           4
#define TP_ADC_CLKDIV_32           5
#define TP_ADC_CLKDIV_64           6
#define TP_ADC_CLKDIV_128          7


/* Touch Panel Sample Time Reg TPCR0[6:4] */
#define TP_ADC_SAMPLE_512_CLKS     ((uint8_t)(0<<4))
#define TP_ADC_SAMPLE_1024_CLKS    ((uint8_t)(1<<4))
#define TP_ADC_SAMPLE_2048_CLKS    ((uint8_t)(2<<4))
#define TP_ADC_SAMPLE_4096_CLKS    ((uint8_t)(3<<4))
#define TP_ADC_SAMPLE_8192_CLKS    ((uint8_t)(4<<4))
#define TP_ADC_SAMPLE_16384_CLKS   ((uint8_t)(5<<4))
#define TP_ADC_SAMPLE_32768_CLKS   ((uint8_t)(6<<4))
#define TP_ADC_SAMPLE_65536_CLKS   ((uint8_t)(7<<4))

/* RA8875 interrupt enable/flag/clear masks */
#define RA8875_INT_KEYSCAN          ((uint8_t)(1<<4))    /**< KEYSCAN interrupts  */
#define RA8875_INT_DMA              ((uint8_t)(1<<3))    /**< DMA interrupts  */
#define RA8875_INT_TP               ((uint8_t)(1<<2))    /**< Touch panel interrupts  */
#define RA8875_INT_BTE              ((uint8_t)(1<<1))    /**< BTE process complete interrupts  */
#define RA8875_INT_BTEMCU_FONTWR    ((uint8_t)(1<<0))    /**< BTE-MCU-R/W or Font-Write interrupts  */


// RA8875 Register Names and Bit-Values
//
// Leveraged from Adafruit library for register names that match
// the RA8875 PDF documentation.
//
// Missing registered that are used herein have been added

// Command/Data pins for SPI
//#define RA8875_DATAWRITE            0x00
//#define RA8875_DATAREAD             0x40
//#define RA8875_CMDWRITE             0x80
//#define RA8875_CMDREAD              0xC0

// Registers & bits
#define RA8875_PWRR                   0x01
#define RA8875_PWRR_DISPON            0x80
#define RA8875_PWRR_DISPOFF           0x00
#define RA8875_PWRR_SLEEP             0x02
#define RA8875_PWRR_NORMAL            0x00
#define RA8875_PWRR_SOFTRESET         0x01

#define RA8875_MRWC                   0x02

#define RA8875_GPIOX                  0xC7

#define RA8875_SYSR                   0x10
#define RA8875_SYSR_8BPP              0x00
#define RA8875_SYSR_16BPP             0x0C
#define RA8875_SYSR_MCU8              0x00
#define RA8875_SYSR_MCU16             0x03

#define RA8875_PCSR                   0x04
#define RA8875_PCSR_PDATR             0x00
#define RA8875_PCSR_PDATL             0x80
#define RA8875_PCSR_CLK               0x00
#define RA8875_PCSR_2CLK              0x01
#define RA8875_PCSR_4CLK              0x02
#define RA8875_PCSR_8CLK              0x03

#define RA8875_HDWR                   0x14

#define RA8875_HNDFTR                 0x15
#define RA8875_HNDFTR_DE_HIGH         0x00
#define RA8875_HNDFTR_DE_LOW          0x80

#define RA8875_HNDR                   0x16
#define RA8875_HSTR                   0x17
#define RA8875_HPWR                   0x18
#define RA8875_HPWR_LOW               0x00
#define RA8875_HPWR_HIGH              0x80

#define RA8875_VDHR0                  0x19
#define RA8875_VDHR1                  0x1A
#define RA8875_VNDR0                  0x1B
#define RA8875_VNDR1                  0x1C
#define RA8875_VSTR0                  0x1D
#define RA8875_VSTR1                  0x1E
#define RA8875_VPWR                   0x1F
#define RA8875_VPWR_LOW               0x00
#define RA8875_VPWR_HIGH              0x80

#define RA8875_DPCR                   0x20
#define RA8875_FNCR0                  0x21

#define RA8875_FNCR1                  0x22
#define RA8875_CGSR                   0x23
#define RA8875_HOFS0                  0x24
#define RA8875_HOFS1                  0x25
#define RA8875_VOFS0                  0x26
#define RA8875_VOFS1                  0x27

#define RA8875_FLDR                   0x29
#define RA8875_FCURXL                 0x2A
#define RA8875_FCURXH                 0x2B
#define RA8875_FCURYL                 0x2C
#define RA8875_FCURYH                 0x2D
#define RA8875_FWTYPSR                0x2E
#define RA8875_SFROMS                 0x2F

#define RA8875_HSAW0                  0x30
#define RA8875_HSAW1                  0x31
#define RA8875_VSAW0                  0x32
#define RA8875_VSAW1                  0x33

#define RA8875_HEAW0                  0x34
#define RA8875_HEAW1                  0x35
#define RA8875_VEAW0                  0x36
#define RA8875_VEAW1                  0x37

#define RA8875_MWCR0                  0x40
#define RA8875_MWCR0_GFXMODE          0x00
#define RA8875_MWCR0_TXTMODE          0x80

#define RA8875_MWCR1                  0x41
#define RA8875_MWCR1_GFXCURDIS        0x00
#define RA8875_MWCR1_GFXCURENA        0x80

#define RA8875_BTCR                   0x44
#define RA8875_MRCD                   0x45
#define RA8875_CURH0                  0x46
#define RA8875_CURH1                  0x47
#define RA8875_CURV0                  0x48
#define RA8875_CURV1                  0x49

#define RA8875_RCURH0                 0x4A
#define RA8875_RCURH1                 0x4B
#define RA8875_RCURV0                 0x4C
#define RA8875_RCURV1                 0x4D
#define RA8875_CURHS                  0x4E
#define RA8875_CURVS                  0x4F

#define RA8875_BECR0                  0x50
#define RA8875_BECR1                  0x51

#define RA8875_LTPR0                  0x52
#define RA8875_LTPR1                  0x53

#define RA8875_HSBE0                  0x54
#define RA8875_HSBE1                  0x55
#define RA8875_VSBE0                  0x56
#define RA8875_VSBE1                  0x57
#define RA8875_HDBE0                  0x58
#define RA8875_HDBE1                  0x59
#define RA8875_VDBE0                  0x5A
#define RA8875_VDBE1                  0x5B
#define RA8875_BEWR0                  0x5C
#define RA8875_BEWR1                  0x5D
#define RA8875_BEHR0                  0x5E
#define RA8875_BEHR1                  0x5F




#define RA8875_TPCR0                  0x70
#define RA8875_TPCR0_ENABLE           0x80
#define RA8875_TPCR0_DISABLE          0x00
#define RA8875_TPCR0_WAIT_512CLK      0x00
#define RA8875_TPCR0_WAIT_1024CLK     0x10
#define RA8875_TPCR0_WAIT_2048CLK     0x20
#define RA8875_TPCR0_WAIT_4096CLK     0x30
#define RA8875_TPCR0_WAIT_8192CLK     0x40
#define RA8875_TPCR0_WAIT_16384CLK    0x50
#define RA8875_TPCR0_WAIT_32768CLK    0x60
#define RA8875_TPCR0_WAIT_65536CLK    0x70
#define RA8875_TPCR0_WAKEENABLE       0x08
#define RA8875_TPCR0_WAKEDISABLE      0x00
#define RA8875_TPCR0_ADCCLK_DIV1      0x00
#define RA8875_TPCR0_ADCCLK_DIV2      0x01
#define RA8875_TPCR0_ADCCLK_DIV4      0x02
#define RA8875_TPCR0_ADCCLK_DIV8      0x03
#define RA8875_TPCR0_ADCCLK_DIV16     0x04
#define RA8875_TPCR0_ADCCLK_DIV32     0x05
#define RA8875_TPCR0_ADCCLK_DIV64     0x06
#define RA8875_TPCR0_ADCCLK_DIV128    0x07

#define RA8875_TPCR1                  0x71
#define RA8875_TPCR1_AUTO             0x00
#define RA8875_TPCR1_MANUAL           0x40
#define RA8875_TPCR1_VREFINT          0x00
#define RA8875_TPCR1_VREFEXT          0x20
#define RA8875_TPCR1_DEBOUNCE         0x04
#define RA8875_TPCR1_NODEBOUNCE       0x00
#define RA8875_TPCR1_IDLE             0x00
#define RA8875_TPCR1_WAIT             0x01
#define RA8875_TPCR1_LATCHX           0x02
#define RA8875_TPCR1_LATCHY           0x03

#define RA8875_TPXH                   0x72
#define RA8875_TPYH                   0x73
#define RA8875_TPXYL                  0x74
#define RA8875_TPXYL_ADET             0x80

#define RA8875_PLLC1                  0x88
#define RA8875_PLLC1_PLLDIV2          0x80
#define RA8875_PLLC1_PLLDIV1          0x00

#define RA8875_PLLC2                  0x89
#define RA8875_PLLC2_DIV1             0x00
#define RA8875_PLLC2_DIV2             0x01
#define RA8875_PLLC2_DIV4             0x02
#define RA8875_PLLC2_DIV8             0x03
#define RA8875_PLLC2_DIV16            0x04
#define RA8875_PLLC2_DIV32            0x05
#define RA8875_PLLC2_DIV64            0x06
#define RA8875_PLLC2_DIV128           0x07

#define RA8875_MCLR                   0x8E
#define RA8875_MCLR_START             0x80
#define RA8875_MCLR_STOP              0x00
#define RA8875_MCLR_READSTATUS        0x80
#define RA8875_MCLR_FULL              0x00
#define RA8875_MCLR_ACTIVE            0x40

#define RA8875_P1CR                   0x8A
#define RA8875_P1CR_ENABLE            0x80
#define RA8875_P1CR_DISABLE           0x00
#define RA8875_P1CR_CLKOUT            0x10
#define RA8875_P1CR_PWMOUT            0x00

#define RA8875_P1DCR                  0x8B

#define RA8875_P2CR                   0x8C
#define RA8875_P2CR_ENABLE            0x80
#define RA8875_P2CR_DISABLE           0x00
#define RA8875_P2CR_CLKOUT            0x10
#define RA8875_P2CR_PWMOUT            0x00

#define RA8875_PWM_CLK_DIV1           0x00
#define RA8875_PWM_CLK_DIV2           0x01
#define RA8875_PWM_CLK_DIV4           0x02
#define RA8875_PWM_CLK_DIV8           0x03
#define RA8875_PWM_CLK_DIV16          0x04
#define RA8875_PWM_CLK_DIV32          0x05
#define RA8875_PWM_CLK_DIV64          0x06
#define RA8875_PWM_CLK_DIV128         0x07
#define RA8875_PWM_CLK_DIV256         0x08
#define RA8875_PWM_CLK_DIV512         0x09
#define RA8875_PWM_CLK_DIV1024        0x0A
#define RA8875_PWM_CLK_DIV2048        0x0B
#define RA8875_PWM_CLK_DIV4096        0x0C
#define RA8875_PWM_CLK_DIV8192        0x0D
#define RA8875_PWM_CLK_DIV16384       0x0E
#define RA8875_PWM_CLK_DIV32768       0x0F

#define RA8875_P2DCR                  0x8D

#define RA8875_DCR                    0x90
#define RA8875_DCR_LINESQUTRI_START   0x80
#define RA8875_DCR_LINESQUTRI_STOP    0x00
#define RA8875_DCR_LINESQUTRI_STATUS  0x80
#define RA8875_DCR_CIRCLE_START       0x40
#define RA8875_DCR_CIRCLE_STATUS      0x40
#define RA8875_DCR_CIRCLE_STOP        0x00
#define RA8875_DCR_FILL               0x20
#define RA8875_DCR_NOFILL             0x00
#define RA8875_DCR_DRAWSQUARE         0x10
#define RA8875_DCR_DRAWTRIANGLE       0x01
#define RA8875_DCR_DRAWLINE           0x00

#define RA8875_DLHSR0                 0x91
#define RA8875_DLHSR1                 0x92
#define RA8875_DLVSR0                 0x93
#define RA8875_DLVSR1                 0x94
#define RA8875_DLHER0                 0x95
#define RA8875_DLHER1                 0x96
#define RA8875_DLVER0                 0x97
#define RA8875_DLVER1                 0x98
#define RA8875_DCHR0                  0x99
#define RA8875_DCHHR1                 0x9A
#define RA8875_DCVR0                  0x9B
#define RA8875_DCVR1                  0x9C

#define RA8875_DCRR                   0x9D

#define RA8875_ELLIPSE                0xA0
#define RA8875_ELLIPSE_STATUS         0x80

#define RA8875_ELLA0                  0xA1
#define RA8875_ELLA1                  0xA2
#define RA8875_ELLB0                  0xA3
#define RA8875_ELLB1                  0xA4
#define RA8875_DEHR0                  0xA5
#define RA8875_DEHR1                  0xA6
#define RA8875_DEVR0                  0xA7
#define RA8875_DEVR1                  0xA8

#define RA8875_DTPH0                  0xA9
#define RA8875_DTPH1                  0xAA
#define RA8875_DTPV0                  0xAB
#define RA8875_DTPV1                  0xAC

#define RA8875_KSCR1                  0xC0
#define RA8875_KSCR2                  0xC1

#define RA8875_INTC1                  0xF0
#define RA8875_INTC1_KEY              0x10
#define RA8875_INTC1_DMA              0x08
#define RA8875_INTC1_TP               0x04
#define RA8875_INTC1_BTE              0x02

#define RA8875_INTC2                  0xF1
#define RA8875_INTC2_KEY              0x10
#define RA8875_INTC2_DMA              0x08
#define RA8875_INTC2_TP               0x04
#define RA8875_INTC2_BTE              0x02

#endif // RA8875_REGS_H
