//                                                                               
//    This script modifies a font file which was generated with a tool by        
//    MikroElektronika - GLD Font Creator.                                       
//                                                                               
//    That tool creates the font data set for an embedded system from a Windows  
//    True Type font. The user is encouraged to ensure that the font used is     
//    properly licensed, or drawn from a source that does not have a license     
//    restriction.                                                               
//                                                                               
//    This script will read and then modify the file for a few specific purposes:
//      * <space>   character is redefined to set the width to 1/4 the height,   
//                  because the normal behavior sets it much too narrow.         
//      * '0' - '9' characters are redefined to set the width equal to the width 
//                  of the widest digit, or to the user override value.          
//                                                                               
//    And just because it can, it then improves upon the documentation in the    
//    resulting data structure.                                                  
//                                                                               
//    This script was created by Smartware Computing, and is provided 'as is'    
//    with no warranty or suitability of fitness for any purpose. Anyone may use 
//    or modify it subject to the agreement that:                                
//      * The Smartware copyright statement remains intact.                      
//      * Modifications for derivative use are clearly stated in this header.    
//                                                                               
//    Modifications from the original:                                           
//      * automatically change 'unsigned short' to 'unsigned char'.              
//                                                                               
// Script Activation:
//   ParseMikroeFont -0=16 BPG_Arial29x32.h New_BPG_Arial29x32.h


//Font Generated by MikroElektronika GLCD Font Creator 1.2.0.0
//MikroElektrnika 2011 
//http://www.mikroe.com 

//GLCD FontName : BPG_Arial29x32
//GLCD FontSize : 29 x 32

const unsigned char BPG_Arial29x32[] = {
    // Font Info
    0x00,                   // Unknown #1
    0x00,                   // Unknown #2
    0x20,0x00,              // FirstChar
    0xFF,0x00,              // LastChar
    0x20,                   // FontHeight
    0x00,                   // Unknown #3
    // Directory of Chars  [Width] [Offset-L] [Offset-M] [Offset-H]
    0x08,0x88,0x03,0x00,    // 0x20 ' ' 
    0x07,0xA8,0x03,0x00,    // 0x21 '!' 
    0x0A,0xC8,0x03,0x00,    // 0x22 '"' 
    0x11,0x08,0x04,0x00,    // 0x23 '#' 
    0x10,0x68,0x04,0x00,    // 0x24 '$' 
    0x19,0xA8,0x04,0x00,    // 0x25 '%' 
    0x14,0x28,0x05,0x00,    // 0x26 '&' 
    0x05,0x88,0x05,0x00,    // 0x27 ''' 
    0x0A,0xA8,0x05,0x00,    // 0x28 '(' 
    0x0A,0xE8,0x05,0x00,    // 0x29 ')' 
    0x0B,0x28,0x06,0x00,    // 0x2A '*' 
    0x10,0x68,0x06,0x00,    // 0x2B '+' 
    0x06,0xA8,0x06,0x00,    // 0x2C ',' 
    0x0A,0xC8,0x06,0x00,    // 0x2D '-' 
    0x07,0x08,0x07,0x00,    // 0x2E '.' 
    0x09,0x28,0x07,0x00,    // 0x2F '/' 
    0x10,0x68,0x07,0x00,    // 0x30 '0' 
    0x10,0xA8,0x07,0x00,    // 0x31 '1' 
    0x10,0xE8,0x07,0x00,    // 0x32 '2' 
    0x10,0x28,0x08,0x00,    // 0x33 '3' 
    0x10,0x68,0x08,0x00,    // 0x34 '4' 
    0x10,0xA8,0x08,0x00,    // 0x35 '5' 
    0x10,0xE8,0x08,0x00,    // 0x36 '6' 
    0x10,0x28,0x09,0x00,    // 0x37 '7' 
    0x10,0x68,0x09,0x00,    // 0x38 '8' 
    0x10,0xA8,0x09,0x00,    // 0x39 '9' 
    0x07,0xE8,0x09,0x00,    // 0x3A ':' 
    0x06,0x08,0x0A,0x00,    // 0x3B ';' 
    0x10,0x28,0x0A,0x00,    // 0x3C '<' 
    0x10,0x68,0x0A,0x00,    // 0x3D '=' 
    0x10,0xA8,0x0A,0x00,    // 0x3E '>' 
    0x10,0xE8,0x0A,0x00,    // 0x3F '?' 
    0x1D,0x28,0x0B,0x00,    // 0x40 '@' 
    0x14,0xA8,0x0B,0x00,    // 0x41 'A' 
    0x13,0x08,0x0C,0x00,    // 0x42 'B' 
    0x15,0x68,0x0C,0x00,    // 0x43 'C' 
    0x14,0xC8,0x0C,0x00,    // 0x44 'D' 
    0x13,0x28,0x0D,0x00,    // 0x45 'E' 
    0x11,0x88,0x0D,0x00,    // 0x46 'F' 
    0x16,0xE8,0x0D,0x00,    // 0x47 'G' 
    0x14,0x48,0x0E,0x00,    // 0x48 'H' 
    0x06,0xA8,0x0E,0x00,    // 0x49 'I' 
    0x0D,0xC8,0x0E,0x00,    // 0x4A 'J' 
    0x14,0x08,0x0F,0x00,    // 0x4B 'K' 
    0x10,0x68,0x0F,0x00,    // 0x4C 'L' 
    0x17,0xA8,0x0F,0x00,    // 0x4D 'M' 
    0x14,0x08,0x10,0x00,    // 0x4E 'N' 
    0x16,0x68,0x10,0x00,    // 0x4F 'O' 
    0x13,0xC8,0x10,0x00,    // 0x50 'P' 
    0x17,0x28,0x11,0x00,    // 0x51 'Q' 
    0x16,0x88,0x11,0x00,    // 0x52 'R' 
    0x13,0xE8,0x11,0x00,    // 0x53 'S' 
    0x12,0x48,0x12,0x00,    // 0x54 'T' 
    0x14,0xA8,0x12,0x00,    // 0x55 'U' 
    0x14,0x08,0x13,0x00,    // 0x56 'V' 
    0x1C,0x68,0x13,0x00,    // 0x57 'W' 
    0x14,0xE8,0x13,0x00,    // 0x58 'X' 
    0x14,0x48,0x14,0x00,    // 0x59 'Y' 
    0x12,0xA8,0x14,0x00,    // 0x5A 'Z' 
    0x09,0x08,0x15,0x00,    // 0x5B '[' 
    0x09,0x48,0x15,0x00,    // 0x5C '\\' 
    0x07,0x88,0x15,0x00,    // 0x5D ']' 
    0x0E,0xA8,0x15,0x00,    // 0x5E '^' 
    0x11,0xE8,0x15,0x00,    // 0x5F '_' 
    0x08,0x48,0x16,0x00,    // 0x60 '`' 
    0x10,0x68,0x16,0x00,    // 0x61 'a' 
    0x10,0xA8,0x16,0x00,    // 0x62 'b' 
    0x0F,0xE8,0x16,0x00,    // 0x63 'c' 
    0x0F,0x28,0x17,0x00,    // 0x64 'd' 
    0x10,0x68,0x17,0x00,    // 0x65 'e' 
    0x0A,0xA8,0x17,0x00,    // 0x66 'f' 
    0x0F,0xE8,0x17,0x00,    // 0x67 'g' 
    0x0F,0x28,0x18,0x00,    // 0x68 'h' 
    0x05,0x68,0x18,0x00,    // 0x69 'i' 
    0x05,0x88,0x18,0x00,    // 0x6A 'j' 
    0x0F,0xA8,0x18,0x00,    // 0x6B 'k' 
    0x05,0xE8,0x18,0x00,    // 0x6C 'l' 
    0x17,0x08,0x19,0x00,    // 0x6D 'm' 
    0x0F,0x68,0x19,0x00,    // 0x6E 'n' 
    0x10,0xA8,0x19,0x00,    // 0x6F 'o' 
    0x0F,0xE8,0x19,0x00,    // 0x70 'p' 
    0x0F,0x28,0x1A,0x00,    // 0x71 'q' 
    0x0B,0x68,0x1A,0x00,    // 0x72 'r' 
    0x0E,0xA8,0x1A,0x00,    // 0x73 's' 
    0x09,0xE8,0x1A,0x00,    // 0x74 't' 
    0x0F,0x28,0x1B,0x00,    // 0x75 'u' 
    0x0F,0x68,0x1B,0x00,    // 0x76 'v' 
    0x16,0xA8,0x1B,0x00,    // 0x77 'w' 
    0x0F,0x08,0x1C,0x00,    // 0x78 'x' 
    0x0F,0x48,0x1C,0x00,    // 0x79 'y' 
    0x0F,0x88,0x1C,0x00,    // 0x7A 'z' 
    0x0A,0xC8,0x1C,0x00,    // 0x7B '{' 
    0x06,0x08,0x1D,0x00,    // 0x7C '|' 
    0x0A,0x28,0x1D,0x00,    // 0x7D '}' 
    0x11,0x68,0x1D,0x00,    // 0x7E '~' 
    0x09,0xC8,0x1D,0x00,    // 0x7F '<non-printable>' 
    0x01,0x08,0x1E,0x00,    // 0x80 '<non-printable>' 
    0x01,0x28,0x1E,0x00,    // 0x81 '<non-printable>' 
    0x01,0x48,0x1E,0x00,    // 0x82 '<non-printable>' 
    0x01,0x68,0x1E,0x00,    // 0x83 '<non-printable>' 
    0x01,0x88,0x1E,0x00,    // 0x84 '<non-printable>' 
    0x01,0xA8,0x1E,0x00,    // 0x85 '<non-printable>' 
    0x01,0xC8,0x1E,0x00,    // 0x86 '<non-printable>' 
    0x01,0xE8,0x1E,0x00,    // 0x87 '<non-printable>' 
    0x01,0x08,0x1F,0x00,    // 0x88 '<non-printable>' 
    0x01,0x28,0x1F,0x00,    // 0x89 '<non-printable>' 
    0x01,0x48,0x1F,0x00,    // 0x8A '<non-printable>' 
    0x01,0x68,0x1F,0x00,    // 0x8B '<non-printable>' 
    0x01,0x88,0x1F,0x00,    // 0x8C '<non-printable>' 
    0x01,0xA8,0x1F,0x00,    // 0x8D '<non-printable>' 
    0x01,0xC8,0x1F,0x00,    // 0x8E '<non-printable>' 
    0x01,0xE8,0x1F,0x00,    // 0x8F '<non-printable>' 
    0x01,0x08,0x20,0x00,    // 0x90 '<non-printable>' 
    0x01,0x28,0x20,0x00,    // 0x91 '<non-printable>' 
    0x01,0x48,0x20,0x00,    // 0x92 '<non-printable>' 
    0x01,0x68,0x20,0x00,    // 0x93 '<non-printable>' 
    0x01,0x88,0x20,0x00,    // 0x94 '<non-printable>' 
    0x01,0xA8,0x20,0x00,    // 0x95 '<non-printable>' 
    0x01,0xC8,0x20,0x00,    // 0x96 '<non-printable>' 
    0x01,0xE8,0x20,0x00,    // 0x97 '<non-printable>' 
    0x01,0x08,0x21,0x00,    // 0x98 '<non-printable>' 
    0x01,0x28,0x21,0x00,    // 0x99 '<non-printable>' 
    0x01,0x48,0x21,0x00,    // 0x9A '<non-printable>' 
    0x01,0x68,0x21,0x00,    // 0x9B '<non-printable>' 
    0x01,0x88,0x21,0x00,    // 0x9C '<non-printable>' 
    0x01,0xA8,0x21,0x00,    // 0x9D '<non-printable>' 
    0x01,0xC8,0x21,0x00,    // 0x9E '<non-printable>' 
    0x01,0xE8,0x21,0x00,    // 0x9F '<non-printable>' 
    0x01,0x08,0x22,0x00,    // 0xA0 '<non-printable>' 
    0x07,0x28,0x22,0x00,    // 0xA1 '<non-printable>' 
    0x10,0x48,0x22,0x00,    // 0xA2 '<non-printable>' 
    0x10,0x88,0x22,0x00,    // 0xA3 '<non-printable>' 
    0x10,0xC8,0x22,0x00,    // 0xA4 '<non-printable>' 
    0x11,0x08,0x23,0x00,    // 0xA5 '<non-printable>' 
    0x06,0x68,0x23,0x00,    // 0xA6 '<non-printable>' 
    0x10,0x88,0x23,0x00,    // 0xA7 '<non-printable>' 
    0x0A,0xC8,0x23,0x00,    // 0xA8 '<non-printable>' 
    0x16,0x08,0x24,0x00,    // 0xA9 '<non-printable>' 
    0x0B,0x68,0x24,0x00,    // 0xAA '<non-printable>' 
    0x0F,0xA8,0x24,0x00,    // 0xAB '<non-printable>' 
    0x10,0xE8,0x24,0x00,    // 0xAC '<non-printable>' 
    0x0A,0x28,0x25,0x00,    // 0xAD '<non-printable>' 
    0x16,0x68,0x25,0x00,    // 0xAE '<non-printable>' 
    0x11,0xC8,0x25,0x00,    // 0xAF '<non-printable>' 
    0x0B,0x28,0x26,0x00,    // 0xB0 '<non-printable>' 
    0x10,0x68,0x26,0x00,    // 0xB1 '<non-printable>' 
    0x0A,0xA8,0x26,0x00,    // 0xB2 '<non-printable>' 
    0x0A,0xE8,0x26,0x00,    // 0xB3 '<non-printable>' 
    0x09,0x28,0x27,0x00,    // 0xB4 '<non-printable>' 
    0x0F,0x68,0x27,0x00,    // 0xB5 '<non-printable>' 
    0x11,0xA8,0x27,0x00,    // 0xB6 '<non-printable>' 
    0x07,0x08,0x28,0x00,    // 0xB7 '<non-printable>' 
    0x09,0x28,0x28,0x00,    // 0xB8 '<non-printable>' 
    0x08,0x68,0x28,0x00,    // 0xB9 '<non-printable>' 
    0x0B,0x88,0x28,0x00,    // 0xBA '<non-printable>' 
    0x0F,0xC8,0x28,0x00,    // 0xBB '<non-printable>' 
    0x19,0x08,0x29,0x00,    // 0xBC '<non-printable>' 
    0x19,0x88,0x29,0x00,    // 0xBD '<non-printable>' 
    0x19,0x08,0x2A,0x00,    // 0xBE '<non-printable>' 
    0x11,0x88,0x2A,0x00,    // 0xBF '<non-printable>' 
    0x14,0xE8,0x2A,0x00,    // 0xC0 '<non-printable>' 
    0x14,0x48,0x2B,0x00,    // 0xC1 '<non-printable>' 
    0x14,0xA8,0x2B,0x00,    // 0xC2 '<non-printable>' 
    0x14,0x08,0x2C,0x00,    // 0xC3 '<non-printable>' 
    0x14,0x68,0x2C,0x00,    // 0xC4 '<non-printable>' 
    0x14,0xC8,0x2C,0x00,    // 0xC5 '<non-printable>' 
    0x1C,0x28,0x2D,0x00,    // 0xC6 '<non-printable>' 
    0x15,0xA8,0x2D,0x00,    // 0xC7 '<non-printable>' 
    0x13,0x08,0x2E,0x00,    // 0xC8 '<non-printable>' 
    0x13,0x68,0x2E,0x00,    // 0xC9 '<non-printable>' 
    0x13,0xC8,0x2E,0x00,    // 0xCA '<non-printable>' 
    0x13,0x28,0x2F,0x00,    // 0xCB '<non-printable>' 
    0x08,0x88,0x2F,0x00,    // 0xCC '<non-printable>' 
    0x08,0xA8,0x2F,0x00,    // 0xCD '<non-printable>' 
    0x09,0xC8,0x2F,0x00,    // 0xCE '<non-printable>' 
    0x09,0x08,0x30,0x00,    // 0xCF '<non-printable>' 
    0x14,0x48,0x30,0x00,    // 0xD0 '<non-printable>' 
    0x14,0xA8,0x30,0x00,    // 0xD1 '<non-printable>' 
    0x16,0x08,0x31,0x00,    // 0xD2 '<non-printable>' 
    0x16,0x68,0x31,0x00,    // 0xD3 '<non-printable>' 
    0x16,0xC8,0x31,0x00,    // 0xD4 '<non-printable>' 
    0x16,0x28,0x32,0x00,    // 0xD5 '<non-printable>' 
    0x16,0x88,0x32,0x00,    // 0xD6 '<non-printable>' 
    0x10,0xE8,0x32,0x00,    // 0xD7 '<non-printable>' 
    0x16,0x28,0x33,0x00,    // 0xD8 '<non-printable>' 
    0x14,0x88,0x33,0x00,    // 0xD9 '<non-printable>' 
    0x14,0xE8,0x33,0x00,    // 0xDA '<non-printable>' 
    0x14,0x48,0x34,0x00,    // 0xDB '<non-printable>' 
    0x14,0xA8,0x34,0x00,    // 0xDC '<non-printable>' 
    0x14,0x08,0x35,0x00,    // 0xDD '<non-printable>' 
    0x13,0x68,0x35,0x00,    // 0xDE '<non-printable>' 
    0x12,0xC8,0x35,0x00,    // 0xDF '<non-printable>' 
    0x10,0x28,0x36,0x00,    // 0xE0 '<non-printable>' 
    0x10,0x68,0x36,0x00,    // 0xE1 '<non-printable>' 
    0x10,0xA8,0x36,0x00,    // 0xE2 '<non-printable>' 
    0x10,0xE8,0x36,0x00,    // 0xE3 '<non-printable>' 
    0x10,0x28,0x37,0x00,    // 0xE4 '<non-printable>' 
    0x10,0x68,0x37,0x00,    // 0xE5 '<non-printable>' 
    0x1A,0xA8,0x37,0x00,    // 0xE6 '<non-printable>' 
    0x0F,0x28,0x38,0x00,    // 0xE7 '<non-printable>' 
    0x10,0x68,0x38,0x00,    // 0xE8 '<non-printable>' 
    0x10,0xA8,0x38,0x00,    // 0xE9 '<non-printable>' 
    0x10,0xE8,0x38,0x00,    // 0xEA '<non-printable>' 
    0x10,0x28,0x39,0x00,    // 0xEB '<non-printable>' 
    0x07,0x68,0x39,0x00,    // 0xEC '<non-printable>' 
    0x09,0x88,0x39,0x00,    // 0xED '<non-printable>' 
    0x09,0xC8,0x39,0x00,    // 0xEE '<non-printable>' 
    0x09,0x08,0x3A,0x00,    // 0xEF '<non-printable>' 
    0x10,0x48,0x3A,0x00,    // 0xF0 '<non-printable>' 
    0x0F,0x88,0x3A,0x00,    // 0xF1 '<non-printable>' 
    0x10,0xC8,0x3A,0x00,    // 0xF2 '<non-printable>' 
    0x10,0x08,0x3B,0x00,    // 0xF3 '<non-printable>' 
    0x10,0x48,0x3B,0x00,    // 0xF4 '<non-printable>' 
    0x10,0x88,0x3B,0x00,    // 0xF5 '<non-printable>' 
    0x10,0xC8,0x3B,0x00,    // 0xF6 '<non-printable>' 
    0x10,0x08,0x3C,0x00,    // 0xF7 '<non-printable>' 
    0x11,0x48,0x3C,0x00,    // 0xF8 '<non-printable>' 
    0x0F,0xA8,0x3C,0x00,    // 0xF9 '<non-printable>' 
    0x0F,0xE8,0x3C,0x00,    // 0xFA '<non-printable>' 
    0x0F,0x28,0x3D,0x00,    // 0xFB '<non-printable>' 
    0x0F,0x68,0x3D,0x00,    // 0xFC '<non-printable>' 
    0x0F,0xA8,0x3D,0x00,    // 0xFD '<non-printable>' 
    0x10,0xE8,0x3D,0x00,    // 0xFE '<non-printable>' 
    0x0F,0x28,0x3E,0x00,    // 0xFF '<non-printable>' 
    // Chars Bitstream
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x20 ' '
    0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x7C,0x7C,0x7C,0x78,0x78,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x21 '!'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDE,0x03,0xDE,0x03,0xDE,0x03,0xDE,0x03,0xDE,0x03,0xDC,0x03,0x9C,0x01,0x9C,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x22 '"'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF1,0x00,0xE0,0x71,0x00,0xE0,0x70,0x00,0xE0,0x70,0x00,0xE0,0x78,0x00,0xE0,0x38,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x70,0x38,0x00,0x70,0x3C,0x00,0x70,0x1C,0x00,0x78,0x1C,0x00,0x38,0x1C,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x38,0x0E,0x00,0x3C,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x0E,0x00,0x1C,0x0F,0x00,0x1E,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x23 '#'
    0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0xF0,0x1F,0xF8,0x3F,0xBC,0x7F,0x9C,0x7B,0x9C,0x73,0x9E,0x03,0x9C,0x03,0xBC,0x03,0xFC,0x03,0xF8,0x07,0xE0,0x3F,0x80,0x7F,0x80,0x7B,0x80,0xF3,0x80,0xF3,0x9E,0xF3,0x9E,0xF3,0x9C,0x73,0xBC,0x7B,0xF8,0x3F,0xF0,0x1F,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x24 '$'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0x1E,0x00,0xF8,0x03,0x0E,0x00,0x3C,0x07,0x07,0x00,0x1C,0x07,0x07,0x00,0x1C,0x8F,0x03,0x00,0x1C,0x8F,0x03,0x00,0x1C,0xC7,0x01,0x00,0x1C,0xC7,0x01,0x00,0x3C,0xE7,0x00,0x00,0xF8,0xF3,0x00,0x00,0xF0,0x71,0x00,0x00,0x00,0x78,0x7E,0x00,0x00,0x38,0xFF,0x00,0x00,0x3C,0xE7,0x01,0x00,0x9C,0xC3,0x01,0x00,0x8E,0xC3,0x01,0x00,0x8E,0xC3,0x01,0x00,0x87,0xC3,0x01,0x00,0x87,0xE7,0x01,0x80,0x03,0xE7,0x00,0x80,0x03,0xFF,0x00,0xC0,0x01,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x25 '%'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0x00,0xE0,0x3F,0x00,0xF0,0x3C,0x00,0xF0,0x78,0x00,0x70,0x78,0x00,0xF0,0x78,0x00,0xF0,0x3D,0x00,0xE0,0x1F,0x00,0xC0,0x0F,0x00,0xE0,0x07,0x00,0xF0,0x0F,0x00,0x78,0x9F,0x01,0x3C,0xDE,0x03,0x1C,0xFC,0x03,0x1E,0xF8,0x01,0x1E,0xF8,0x01,0x1E,0xF0,0x01,0x3C,0xF8,0x01,0x7C,0xFC,0x03,0xF8,0xBF,0x0F,0xF0,0x0F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x26 '&'
    0x00,0x00,0x00,0x00,0x00,0x1E,0x1E,0x1E,0x1E,0x1E,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x27 '''
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x01,0xE0,0x00,0xF0,0x00,0x70,0x00,0x78,0x00,0x38,0x00,0x38,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x38,0x00,0x38,0x00,0x78,0x00,0x70,0x00,0xF0,0x00,0xE0,0x00,0xC0,0x01,0xC0,0x03,  // 0x28 '('
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x38,0x00,0x38,0x00,0x70,0x00,0x70,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x01,0xE0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x00,0xE0,0x00,0x70,0x00,0x70,0x00,0x38,0x00,0x38,0x00,0x1C,0x00,  // 0x29 ')'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x60,0x00,0x6E,0x07,0xFE,0x07,0xF8,0x03,0xF0,0x00,0xF8,0x01,0xBC,0x03,0x98,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2A '*'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0xFC,0xFF,0xFC,0xFF,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2B '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x30,0x30,0x38,0x1C,0x00,0x00,  // 0x2C ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x03,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2D '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2E '.'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0xC0,0x01,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x3C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2F '/'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x1F,0xF8,0x3E,0x38,0x38,0x3C,0x78,0x1C,0x70,0x1C,0x70,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x70,0x1C,0x70,0x3C,0x78,0x3C,0x78,0x78,0x3C,0xF0,0x1F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x30 '0'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0F,0x80,0x0F,0xC0,0x0F,0xE0,0x0F,0xF8,0x0F,0x78,0x0F,0x18,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x31 '1'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xF0,0x1F,0xF8,0x3C,0x3C,0x78,0x1C,0x70,0x1E,0xF0,0x00,0xF0,0x00,0x70,0x00,0x78,0x00,0x3C,0x00,0x3E,0x00,0x1F,0x80,0x0F,0xC0,0x07,0xE0,0x03,0xF0,0x00,0x78,0x00,0x3C,0x00,0x1E,0x00,0xFE,0xFF,0xFE,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x32 '2'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xF0,0x1F,0x78,0x3E,0x3C,0x38,0x1C,0x78,0x1E,0x78,0x00,0x78,0x00,0x38,0x00,0x3E,0xC0,0x0F,0xC0,0x3F,0x00,0x7C,0x00,0x78,0x00,0xF0,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x3C,0x78,0x7C,0x7C,0xF8,0x3F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x33 '3'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1E,0x00,0x1F,0x00,0x1F,0x80,0x1F,0xC0,0x1F,0xE0,0x1F,0xE0,0x1E,0x70,0x1E,0x78,0x1E,0x38,0x1E,0x1C,0x1E,0x1E,0x1E,0x0E,0x1E,0xFF,0xFF,0xFF,0xFF,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x34 '4'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x7F,0xF8,0x7F,0x78,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xBC,0x07,0xFC,0x1F,0xFC,0x3F,0x3C,0x78,0x18,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x1C,0xF0,0x1E,0xF0,0x3C,0x78,0x7C,0x7C,0xF8,0x3F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x35 '5'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xF0,0x3F,0xF8,0x3C,0x78,0x78,0x3C,0x70,0x1C,0x18,0x1C,0x00,0x1E,0x00,0xFE,0x1F,0xFE,0x3F,0x7E,0x7C,0x3E,0x78,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1C,0x70,0x3C,0x78,0x78,0x7C,0xF0,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x36 '6'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFE,0xFF,0x00,0x78,0x00,0x3C,0x00,0x1C,0x00,0x1E,0x00,0x0F,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x00,0xE0,0x00,0xF0,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x37 '7'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x1F,0xF8,0x3E,0x3C,0x78,0x3C,0x78,0x3C,0x78,0x3C,0x78,0x3C,0x78,0xF8,0x3E,0xE0,0x1F,0xF8,0x3F,0x7C,0x7C,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xF0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x38 '8'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0x1F,0xF8,0x3E,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF8,0xFC,0xFE,0xF8,0xFF,0xE0,0xF7,0x00,0xF0,0x00,0x70,0x1C,0x78,0x3C,0x78,0x3C,0x3C,0xF8,0x1F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x39 '9'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3A ':'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x30,0x30,0x38,0x1C,0x00,0x00,  // 0x3B ';'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0xF8,0x00,0xFE,0xC0,0x1F,0xF0,0x07,0xFC,0x00,0x3C,0x00,0x7C,0x00,0xF8,0x03,0xE0,0x0F,0x00,0x3F,0x00,0xFC,0x00,0xF0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3C '<'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFC,0xFF,0xFC,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFC,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3D '='
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x7C,0x00,0xFC,0x01,0xE0,0x07,0x80,0x3F,0x00,0xFE,0x00,0xF0,0x00,0xF8,0x00,0x7F,0xC0,0x1F,0xF8,0x03,0xFC,0x00,0x3C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3E '>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xF8,0x3F,0x7C,0x7C,0x3C,0x78,0x1C,0xF0,0x1E,0xF0,0x00,0xF0,0x00,0x78,0x00,0x78,0x00,0x3E,0x00,0x1F,0x00,0x0F,0x80,0x07,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3F '?'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFE,0x7F,0x00,0x80,0x1F,0xF8,0x01,0xC0,0x03,0xE0,0x03,0xE0,0x01,0x80,0x07,0xF0,0x00,0x00,0x07,0x70,0xF8,0x7B,0x0F,0x38,0xFC,0x3F,0x0E,0x38,0x1E,0x3F,0x0E,0x1C,0x0F,0x3E,0x1C,0x1C,0x0F,0x3C,0x1C,0x1C,0x07,0x1C,0x1C,0x9C,0x07,0x1C,0x1E,0x9C,0x07,0x1C,0x0E,0x9C,0x07,0x1E,0x0E,0x9C,0x07,0x1E,0x0F,0x9C,0x07,0x0F,0x07,0x9C,0x07,0x8F,0x03,0x1C,0xCF,0xFF,0x03,0x38,0xFE,0xFF,0x00,0x38,0x7C,0x7E,0x00,0x70,0x00,0x00,0x1E,0xF0,0x00,0x00,0x0F,0xE0,0x03,0x80,0x07,0xC0,0x1F,0xF0,0x03,0x00,0xFF,0xFF,0x00,0x00,0xF8,0x3F,0x00,  // 0x40 '@'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x41 'A'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x01,0x3C,0xE0,0x01,0x3C,0xC0,0x03,0x3C,0xC0,0x03,0x3C,0xC0,0x03,0x3C,0xC0,0x01,0x3C,0xE0,0x01,0xFC,0xFF,0x00,0xFC,0xFF,0x00,0x3C,0xF8,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0xC0,0x03,0x3C,0xF0,0x03,0xFC,0xFF,0x01,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x42 'B'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF8,0x80,0x07,0x78,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x03,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x1E,0x3C,0x00,0x0F,0x78,0x00,0x0F,0xF8,0x80,0x0F,0xF0,0xC1,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x43 'C'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0E,0x3C,0x00,0x0E,0x3C,0x00,0x0E,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x80,0x07,0x3C,0xC0,0x07,0x3C,0xF8,0x03,0xFC,0xFF,0x01,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x44 'D'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x45 'E'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0xFC,0xFF,0x01,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x46 'F'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xC0,0xFF,0x07,0xE0,0xC7,0x0F,0xF0,0x00,0x0F,0x78,0x00,0x1E,0x78,0x00,0x1C,0x3C,0x00,0x0C,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1C,0xF0,0x3F,0x1C,0xF0,0x3F,0x3C,0xF0,0x3F,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x78,0x00,0x3C,0xF0,0x00,0x3E,0xF0,0x83,0x1F,0xC0,0xFF,0x0F,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x47 'G'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0xFC,0xFF,0x0F,0xFC,0xFF,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x48 'H'
    0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x49 'I'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x0E,0x1E,0x1E,0x1E,0x1E,0x1E,0x3E,0x1F,0xFC,0x0F,0xF8,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4A 'J'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x80,0x0F,0x3C,0xC0,0x07,0x3C,0xE0,0x03,0x3C,0xF0,0x01,0x3C,0x78,0x00,0x3C,0x3C,0x00,0x3C,0x1E,0x00,0x3C,0x0F,0x00,0xBC,0x07,0x00,0xFC,0x0F,0x00,0xFC,0x1F,0x00,0xFC,0x1E,0x00,0x7C,0x3C,0x00,0x3C,0x7C,0x00,0x3C,0xF8,0x00,0x3C,0xF0,0x00,0x3C,0xF0,0x01,0x3C,0xE0,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4B 'K'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0xFC,0xFF,0xFC,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4C 'L'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x7C,0xFC,0x00,0x7C,0xFC,0x00,0x7E,0xFC,0x00,0x7E,0xFC,0x01,0x7E,0xFC,0x01,0x7F,0xFC,0x01,0x7F,0xFC,0x03,0x7F,0xBC,0x83,0x7F,0xBC,0x83,0x7B,0xBC,0x87,0x7B,0x3C,0xC7,0x7B,0x3C,0xC7,0x79,0x3C,0xCF,0x79,0x3C,0xEE,0x79,0x3C,0xEE,0x78,0x3C,0xFE,0x78,0x3C,0x7C,0x78,0x3C,0x7C,0x78,0x3C,0x7C,0x78,0x3C,0x38,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4D 'M'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x7C,0x00,0x0F,0xFC,0x00,0x0F,0xFC,0x00,0x0F,0xFC,0x01,0x0F,0xFC,0x03,0x0F,0xFC,0x03,0x0F,0xBC,0x07,0x0F,0xBC,0x0F,0x0F,0x3C,0x0F,0x0F,0x3C,0x1E,0x0F,0x3C,0x3E,0x0F,0x3C,0x3C,0x0F,0x3C,0x78,0x0F,0x3C,0xF8,0x0F,0x3C,0xF0,0x0F,0x3C,0xE0,0x0F,0x3C,0xE0,0x0F,0x3C,0xC0,0x0F,0x3C,0x80,0x0F,0x3C,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4E 'N'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4F 'O'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x7F,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0xC0,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x00,0xFC,0x1F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x50 'P'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF8,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x1C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x30,0x1E,0x78,0xF0,0x1E,0xF8,0xF8,0x0F,0xF0,0xC1,0x07,0xE0,0xFF,0x0F,0x80,0xFF,0x3E,0x00,0x00,0x7C,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x51 'Q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x07,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x80,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x01,0xFC,0x3F,0x00,0x3C,0xF8,0x00,0x3C,0xF0,0x01,0x3C,0xE0,0x01,0x3C,0xC0,0x03,0x3C,0xC0,0x07,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x1F,0x3C,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x52 'R'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0xF0,0xFF,0x00,0xF8,0xF9,0x01,0x78,0xE0,0x03,0x3C,0xC0,0x03,0x3C,0xC0,0x03,0x3C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x03,0x00,0xF0,0x3F,0x00,0xC0,0xFF,0x00,0x00,0xFE,0x01,0x00,0xE0,0x03,0x00,0xC0,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x3C,0x80,0x07,0x7C,0xC0,0x03,0xF8,0xE0,0x03,0xF0,0xFF,0x01,0xE0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x53 'S'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x54 'T'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x38,0x00,0x07,0x78,0x80,0x07,0x78,0x80,0x07,0xF0,0xE1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x55 'U'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x1E,0x00,0x0F,0x1E,0x80,0x07,0x1E,0x80,0x07,0x3C,0x80,0x03,0x3C,0xC0,0x03,0x38,0xC0,0x03,0x78,0xC0,0x01,0x78,0xE0,0x01,0x70,0xE0,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0xE0,0x70,0x00,0xE0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x3B,0x00,0xC0,0x3F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x56 'V'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x00,0x0F,0x0E,0xF0,0x01,0x0F,0x1E,0xF8,0x01,0x07,0x1E,0xF8,0x81,0x07,0x1E,0xF8,0x83,0x07,0x1C,0xF8,0x83,0x07,0x3C,0xBC,0x83,0x03,0x3C,0x9C,0x83,0x03,0x38,0x9C,0xC7,0x03,0x38,0x1E,0xC7,0x03,0x78,0x1E,0xC7,0x01,0x78,0x0E,0xCF,0x01,0x70,0x0E,0xEF,0x01,0x70,0x0F,0xEE,0x00,0x70,0x07,0xEE,0x00,0xF0,0x07,0xFE,0x00,0xE0,0x07,0xFE,0x00,0xE0,0x07,0x7C,0x00,0xE0,0x03,0x7C,0x00,0xE0,0x03,0x7C,0x00,0xC0,0x03,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x57 'W'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x80,0x0F,0x3C,0x80,0x07,0x78,0xC0,0x03,0xF8,0xE0,0x01,0xF0,0xF0,0x00,0xE0,0xF1,0x00,0xC0,0x7B,0x00,0xC0,0x3F,0x00,0x80,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x7F,0x00,0xE0,0x79,0x00,0xF0,0xF0,0x00,0xF8,0xE0,0x01,0x78,0xE0,0x03,0x3C,0xC0,0x03,0x3E,0x80,0x07,0x1F,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x58 'X'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x0F,0x1E,0x80,0x07,0x3C,0xC0,0x07,0x7C,0xC0,0x03,0x78,0xE0,0x01,0xF0,0xF0,0x00,0xF0,0xF1,0x00,0xE0,0x79,0x00,0xC0,0x3B,0x00,0xC0,0x3F,0x00,0x80,0x1F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x59 'Y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x80,0x07,0x00,0xC0,0x07,0x00,0xE0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5A 'Z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0xFC,0x01,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0xFC,0x01,0xFC,0x01,  // 0x5B '['
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x07,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x01,0xC0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5C '\\'
    0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x7E,0x7E,  // 0x5D ']'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x01,0xE0,0x03,0xE0,0x03,0xF0,0x03,0xF0,0x07,0x78,0x07,0x38,0x0F,0x3C,0x0E,0x1C,0x1E,0x1C,0x1C,0x1E,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5E '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,  // 0x5F '_'
    0x00,0x00,0x00,0x00,0x00,0x3E,0x3C,0x78,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x60 '`'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x61 'a'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0xFC,0x0F,0xFC,0x3F,0x7C,0x3C,0x3C,0x78,0x1C,0x70,0x1C,0x70,0x1C,0xF0,0x1C,0xF0,0x1C,0xF0,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x7C,0x3C,0xFC,0x1F,0xFC,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x62 'b'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0xF8,0x3F,0x7C,0x3C,0x3C,0x78,0x1C,0x38,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x18,0x1C,0x70,0x3C,0x78,0x7C,0x3C,0xF8,0x3F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x63 'c'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x78,0xF0,0x7F,0xF8,0x7F,0x3C,0x7C,0x1C,0x78,0x1E,0x78,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x78,0x3C,0x78,0x7C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x64 'd'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0xFE,0xFF,0xFE,0xFF,0x1E,0x00,0x1E,0x00,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x65 'e'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF8,0x03,0x78,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0xFF,0x01,0xFF,0x01,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x66 'f'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x77,0xF8,0x7F,0x3C,0x7C,0x1C,0x78,0x1E,0x78,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x78,0x3C,0x78,0x7C,0x7E,0xF8,0x7F,0xE0,0x77,0x00,0x70,0x0E,0x78,0x1C,0x78,0x3C,0x3C,0xF8,0x1F,0xF0,0x0F,  // 0x67 'g'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0xDC,0x1F,0xFC,0x3F,0x7C,0x78,0x3C,0x78,0x3C,0x70,0x3C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x68 'h'
    0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x69 'i'
    0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1F,0x0F,  // 0x6A 'j'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x7C,0x1C,0x1E,0x1C,0x0F,0x9C,0x07,0xDC,0x03,0xFC,0x01,0xFC,0x03,0xFC,0x03,0xBC,0x07,0x1C,0x0F,0x1C,0x0F,0x1C,0x1E,0x1C,0x3C,0x1C,0x3C,0x1C,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6B 'k'
    0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6C 'l'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDC,0x9F,0x3F,0xFC,0xFF,0x7F,0x7C,0xFC,0x78,0x3C,0x78,0x70,0x3C,0x78,0x70,0x3C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x1C,0x38,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6D 'm'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDC,0x1F,0xFC,0x3F,0x7C,0x78,0x3C,0x78,0x3C,0x70,0x3C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6E 'n'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6F 'o'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEE,0x0F,0xFE,0x1F,0x3E,0x3C,0x1E,0x38,0x1E,0x78,0x1E,0x78,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x38,0x3E,0x3C,0xFE,0x1F,0xFE,0x0F,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,  // 0x70 'p'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x77,0xF8,0x7F,0x3C,0x7C,0x3C,0x78,0x1E,0x78,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1E,0x70,0x1C,0x78,0x3C,0x78,0x78,0x7C,0xF8,0x7F,0xE0,0x77,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,  // 0x71 'q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x07,0xFC,0x07,0x7C,0x03,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x72 'r'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0xFC,0x1F,0x1C,0x1C,0x1E,0x3C,0x1E,0x00,0x7C,0x00,0xFC,0x03,0xF0,0x1F,0x80,0x3F,0x00,0x3C,0x0E,0x38,0x1E,0x38,0x3C,0x3C,0xFC,0x1F,0xF8,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x73 's'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0xFE,0x00,0xFE,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0xF8,0x01,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x74 't'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x3C,0x78,0x3C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x75 'u'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x78,0x1E,0x78,0x1E,0x38,0x1C,0x3C,0x3C,0x1C,0x3C,0x1C,0x38,0x1E,0x78,0x0E,0x70,0x0F,0x70,0x0F,0xF0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x76 'v'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x1E,0x3C,0x0E,0x1E,0x1C,0x0E,0x1F,0x1E,0x1E,0x3F,0x1E,0x1E,0x3F,0x0E,0x1C,0x3F,0x0E,0xBC,0x3F,0x0F,0xBC,0x7B,0x07,0xB8,0x73,0x07,0xB8,0xF3,0x07,0xF8,0xF3,0x03,0xF0,0xF1,0x03,0xF0,0xE1,0x03,0xF0,0xE1,0x01,0xE0,0xE0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x77 'w'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x7C,0x3C,0x3C,0x3C,0x1E,0x78,0x0F,0xF0,0x0F,0xE0,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x07,0xF0,0x07,0x78,0x0F,0x78,0x1E,0x3C,0x3C,0x1E,0x3C,0x1F,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x78 'x'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x70,0x1E,0x78,0x1E,0x38,0x1C,0x3C,0x3C,0x3C,0x38,0x1C,0x78,0x1E,0x78,0x0E,0x70,0x0E,0xF0,0x0F,0xF0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xE0,0x01,0xF6,0x00,0xFC,0x00,0x7C,0x00,  // 0x79 'y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x3F,0xFE,0x3F,0x00,0x3C,0x00,0x1E,0x00,0x0F,0x80,0x07,0xC0,0x03,0xE0,0x01,0xF0,0x01,0xF0,0x00,0x78,0x00,0x3C,0x00,0x1E,0x00,0xFE,0x7F,0xFE,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7A 'z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x03,0xF0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x78,0x00,0x38,0x00,0x3E,0x00,0x0E,0x00,0x3E,0x00,0x38,0x00,0x78,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xF0,0x00,0xF0,0x03,0xE0,0x03,  // 0x7B '{'
    0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,  // 0x7C '|'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x3E,0x00,0x78,0x00,0x78,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0xF0,0x00,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xF0,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x78,0x00,0x78,0x00,0x3E,0x00,0x1E,0x00,  // 0x7D '}'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0xFC,0x83,0x01,0xFE,0xFF,0x01,0x8E,0xFF,0x01,0x06,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7E '~'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0xFE,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xC6,0x01,0xFE,0x01,0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x80 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x81 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x82 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x83 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x84 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x85 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x86 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x87 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x88 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x89 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8A '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8B '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8C '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8D '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8E '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x90 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x91 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x92 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x93 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x94 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x95 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x96 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x97 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x98 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x99 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9A '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9B '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9C '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9D '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9E '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA0 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,  // 0xA1 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x38,0x00,0x18,0x00,0x1C,0x00,0x1C,0x00,0x0C,0xE0,0x1F,0xF0,0x3F,0x78,0x7E,0x3C,0x7E,0x3C,0x77,0x1C,0x07,0x1C,0x03,0x9C,0x03,0x9C,0x03,0x9C,0x19,0xFC,0xF1,0xFC,0x79,0xF8,0x79,0xF0,0x3F,0xE0,0x1F,0xE0,0x00,0x60,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x30,0x00,  // 0xA2 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF0,0x3F,0x78,0x7C,0x3C,0x78,0x3C,0xF0,0x3C,0x30,0x3C,0x00,0x3C,0x00,0x38,0x00,0x78,0x00,0xFE,0x07,0xFE,0x07,0x70,0x00,0x70,0x00,0x70,0x00,0x78,0x00,0x38,0x00,0x1C,0x00,0xFE,0xC3,0xFF,0xFF,0x0E,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA3 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x60,0xFE,0xFF,0xFC,0x7F,0x78,0x3C,0x3C,0x78,0x3C,0x78,0x1C,0x70,0x1C,0x70,0x3C,0x78,0x78,0x3C,0xF8,0x3F,0xFC,0x7F,0xDE,0xF7,0x0C,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xE0,0x01,0x1E,0xF0,0x00,0x1E,0xF0,0x00,0x3C,0x78,0x00,0x3C,0x78,0x00,0x78,0x3C,0x00,0x70,0x1C,0x00,0xF0,0x1E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x00,0xFE,0xFF,0x00,0xFE,0xFF,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0xFE,0xFF,0x00,0xFE,0xFF,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,  // 0xA6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x78,0x3C,0x38,0x3C,0x3C,0x78,0x38,0x00,0xF8,0x00,0xF0,0x01,0xF8,0x07,0xFC,0x0F,0x1E,0x3F,0x0E,0x7C,0x1E,0x78,0x1E,0xF0,0x7C,0xF0,0xF8,0xF0,0xF0,0x73,0xC0,0x3F,0x80,0x1F,0x00,0x3E,0x00,0x3C,0x00,0x78,0x3C,0x78,0x3C,0x78,0x78,0x3C,0xF0,0x3F,0xE0,0x0F,  // 0xA7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDE,0x03,0xDE,0x03,0xDE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA8 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0xE0,0xFF,0x01,0xF0,0xC0,0x07,0x38,0x00,0x0F,0x1C,0x00,0x1E,0x8E,0x7F,0x1C,0xCE,0xF3,0x38,0xC6,0xC1,0x39,0xE7,0x00,0x38,0xE7,0x00,0x30,0xE7,0x00,0x30,0xE7,0x00,0x30,0xE7,0xC0,0x38,0xC7,0xC1,0x39,0xCE,0xE3,0x38,0x8E,0x7F,0x1C,0x1C,0x1E,0x1E,0x38,0x00,0x0F,0xF0,0x80,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA9 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x8E,0x07,0x00,0x07,0xF8,0x07,0xFE,0x07,0x8E,0x07,0x8E,0x07,0xDE,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x73,0xE0,0x39,0xE0,0x3C,0xF0,0x1C,0x78,0x0E,0x38,0x0F,0xBC,0x07,0x38,0x0F,0x78,0x0E,0xF0,0x1E,0xE0,0x3C,0xE0,0x39,0xC0,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAB '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFC,0xFF,0xFC,0xFF,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAC '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x03,0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAD '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0xE0,0xFF,0x01,0xF0,0xC0,0x07,0x38,0x00,0x0F,0x1C,0x00,0x1E,0xCE,0x3F,0x1C,0xCE,0x7F,0x38,0xC6,0xE1,0x38,0xC7,0xE1,0x38,0xC7,0xF1,0x30,0xC7,0x7F,0x30,0xC7,0x1F,0x30,0xC7,0x39,0x38,0xC7,0x71,0x38,0xCE,0x71,0x38,0xCE,0xE1,0x1C,0x1C,0x80,0x1F,0x38,0x00,0x0F,0xF0,0x80,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAE '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x01,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAF '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xF8,0x03,0x1C,0x03,0x0C,0x07,0x0C,0x07,0x9C,0x03,0xF8,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB0 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xFE,0xFF,0xFE,0xFF,0xFE,0xFF,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFE,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB1 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0xFE,0x03,0x8E,0x03,0x80,0x03,0xC0,0x03,0xE0,0x01,0xF0,0x00,0x3C,0x00,0x1E,0x00,0xFE,0x03,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB2 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xFE,0x01,0xCE,0x03,0xC0,0x01,0xF0,0x01,0xF0,0x01,0x80,0x03,0x80,0x03,0xCF,0x03,0xFE,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB3 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x01,0xF0,0x00,0xF0,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x70,0x3C,0x78,0x7C,0x7C,0xFC,0x7F,0xFC,0x7F,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,  // 0xB5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xFC,0xFF,0x01,0xFE,0xFF,0x01,0xFE,0x79,0x00,0xFF,0x79,0x00,0xFF,0x79,0x00,0xFF,0x79,0x00,0xFF,0x79,0x00,0xFF,0x79,0x00,0xFE,0x79,0x00,0xFC,0x79,0x00,0xF8,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,0xC0,0x79,0x00,  // 0xB6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x78,0x00,0xE0,0x00,0xE0,0x01,0xFC,0x00,0x7C,0x00,  // 0xB8 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0xE0,0xF0,0xFC,0xFC,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB9 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xFC,0x03,0x9E,0x03,0x0E,0x07,0x0E,0x07,0x0E,0x07,0x0E,0x07,0x8E,0x07,0xDE,0x03,0xFC,0x01,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x07,0x38,0x0F,0x78,0x0E,0x70,0x1E,0xE0,0x3C,0xE0,0x39,0xC0,0x7B,0xE0,0x39,0xE0,0x3C,0xF0,0x1C,0x78,0x0E,0x38,0x0F,0x1C,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBB '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x38,0x00,0xF0,0x00,0x1C,0x00,0xFC,0x00,0x1E,0x00,0xFC,0x00,0x0E,0x00,0xE0,0x00,0x07,0x00,0xE0,0x80,0x03,0x00,0xE0,0xC0,0x03,0x00,0xE0,0xC0,0x01,0x00,0xE0,0xE0,0x00,0x00,0xE0,0xF0,0x00,0x00,0xE0,0x70,0x00,0x00,0x00,0x38,0x70,0x00,0x00,0x1C,0x78,0x00,0x00,0x1E,0x7C,0x00,0x00,0x0E,0x7E,0x00,0x00,0x07,0x7E,0x00,0x80,0x07,0x77,0x00,0x80,0x83,0x73,0x00,0xC0,0x81,0xFF,0x01,0xE0,0x00,0x70,0x00,0xF0,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBC '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x3C,0x00,0xF0,0x00,0x1C,0x00,0xFC,0x00,0x0E,0x00,0xFC,0x00,0x07,0x00,0xE0,0x00,0x07,0x00,0xE0,0x80,0x03,0x00,0xE0,0xC0,0x01,0x00,0xE0,0xE0,0x01,0x00,0xE0,0xE0,0x00,0x00,0xE0,0x70,0x00,0x00,0xE0,0x78,0x00,0x00,0x00,0x38,0x7E,0x00,0x00,0x1C,0xFF,0x00,0x00,0x8E,0xE7,0x01,0x00,0x0F,0xE0,0x01,0x00,0x07,0xE0,0x00,0x80,0x03,0x78,0x00,0xC0,0x03,0x3C,0x00,0xC0,0x01,0x1E,0x00,0xE0,0x00,0x07,0x00,0x70,0x80,0xFF,0x01,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBD '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x38,0x00,0xFE,0x01,0x1C,0x00,0xCE,0x03,0x1E,0x00,0xC0,0x01,0x0E,0x00,0xF0,0x01,0x07,0x00,0xF0,0x81,0x03,0x00,0x80,0xC3,0x03,0x00,0x80,0xC3,0x01,0x00,0xCF,0xE3,0x00,0x00,0xFE,0xF1,0x00,0x00,0xF8,0x70,0x00,0x00,0x00,0x38,0x70,0x00,0x00,0x1C,0x78,0x00,0x00,0x1E,0x7C,0x00,0x00,0x0E,0x7E,0x00,0x00,0x07,0x7E,0x00,0x80,0x07,0x77,0x00,0x80,0x83,0x73,0x00,0xC0,0x81,0xFF,0x01,0xE0,0x00,0x70,0x00,0xF0,0x00,0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBE '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x3C,0xE0,0x01,0x3C,0xE0,0x00,0x78,0xF0,0x00,0xF8,0x78,0x00,0xF0,0x7F,0x00,0xC0,0x1F,0x00,  // 0xBF '<non-printable>'
    0xC0,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x18,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC0 '<non-printable>'
    0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC1 '<non-printable>'
    0x00,0x0F,0x00,0x80,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x7B,0x00,0x60,0x00,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC2 '<non-printable>'
    0x00,0xE0,0x00,0xC0,0x7F,0x00,0xE0,0x7F,0x00,0xE0,0x38,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC3 '<non-printable>'
    0x00,0x00,0x00,0xC0,0x7B,0x00,0xC0,0x7B,0x00,0xC0,0x7B,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x1F,0x00,0x80,0x19,0x00,0x80,0x19,0x00,0x00,0x1B,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0xC0,0x3F,0x00,0xC0,0x3F,0x00,0xC0,0x39,0x00,0xE0,0x79,0x00,0xE0,0x78,0x00,0xF0,0xF0,0x00,0xF0,0xF0,0x00,0x70,0xE0,0x01,0xF8,0xFF,0x01,0xF8,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x1E,0x80,0x07,0x1E,0x80,0x07,0x0E,0x00,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xFE,0xFF,0x0F,0x00,0xCF,0x03,0x00,0x00,0xCF,0x03,0x00,0x80,0xC7,0x03,0x00,0x80,0xC7,0x03,0x00,0x80,0xC3,0x03,0x00,0xC0,0xC3,0x03,0x00,0xC0,0xC1,0xFF,0x07,0xE0,0xC1,0xFF,0x07,0xE0,0xC1,0xFF,0x07,0xF0,0xC0,0x03,0x00,0xF0,0xFF,0x03,0x00,0xF8,0xFF,0x03,0x00,0x78,0xC0,0x03,0x00,0x3C,0xC0,0x03,0x00,0x3C,0xC0,0x03,0x00,0x1E,0xC0,0x03,0x00,0x1E,0xC0,0xFF,0x0F,0x0F,0xC0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF8,0x80,0x07,0x78,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x03,0x3C,0x00,0x00,0x1C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x1E,0x3C,0x00,0x0F,0x78,0x00,0x0F,0xF8,0x80,0x0F,0xF0,0xC1,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x00,0x00,0x0C,0x00,0x00,0x1E,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,  // 0xC7 '<non-printable>'
    0xC0,0x07,0x00,0x80,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x18,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC8 '<non-printable>'
    0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xC9 '<non-printable>'
    0x00,0x0F,0x00,0x80,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x7B,0x00,0x60,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCA '<non-printable>'
    0x00,0x00,0x00,0xC0,0x7B,0x00,0xC0,0x7B,0x00,0xC0,0x7B,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x03,0xFC,0xFF,0x03,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCB '<non-printable>'
    0x3E,0x3C,0x78,0x70,0xC0,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCC '<non-printable>'
    0xF0,0x78,0x78,0x3C,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCD '<non-printable>'
    0x3C,0x00,0x7E,0x00,0xFE,0x00,0xEF,0x01,0x01,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCE '<non-printable>'
    0x00,0x00,0xEF,0x01,0xEF,0x01,0xEF,0x01,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xCF '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x3F,0x00,0xFC,0xFF,0x00,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0E,0xFF,0x0F,0x0E,0xFF,0x0F,0x0E,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x80,0x07,0x3C,0xC0,0x07,0x3C,0xF8,0x03,0xFC,0xFF,0x01,0xFC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD0 '<non-printable>'
    0x00,0xC0,0x01,0x80,0xFF,0x00,0xC0,0xFF,0x00,0xC0,0x71,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x7C,0x00,0x0F,0xFC,0x00,0x0F,0xFC,0x00,0x0F,0xFC,0x01,0x0F,0xFC,0x03,0x0F,0xFC,0x03,0x0F,0xBC,0x07,0x0F,0xBC,0x0F,0x0F,0x3C,0x0F,0x0F,0x3C,0x1E,0x0F,0x3C,0x3E,0x0F,0x3C,0x3C,0x0F,0x3C,0x78,0x0F,0x3C,0xF8,0x0F,0x3C,0xF0,0x0F,0x3C,0xE0,0x0F,0x3C,0xE0,0x0F,0x3C,0xC0,0x0F,0x3C,0x80,0x0F,0x3C,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD1 '<non-printable>'
    0x80,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x30,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD2 '<non-printable>'
    0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD3 '<non-printable>'
    0x00,0x1E,0x00,0x00,0x3F,0x00,0x00,0x7F,0x00,0x80,0xF7,0x00,0xC0,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD4 '<non-printable>'
    0x00,0x80,0x03,0x00,0xFF,0x01,0x80,0xFF,0x01,0x80,0xE3,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD5 '<non-printable>'
    0x00,0x00,0x00,0x80,0xF7,0x00,0x80,0xF7,0x00,0x80,0xF7,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xC0,0xFF,0x03,0xF0,0xE3,0x07,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x00,0x1E,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1E,0x00,0x3C,0x1C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x3C,0x3C,0x00,0x1E,0x78,0x00,0x1E,0xF8,0x00,0x0F,0xF0,0xC3,0x07,0xE0,0xFF,0x03,0x80,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x70,0x7C,0xF8,0xF8,0x3C,0xF0,0x1F,0xE0,0x0F,0xC0,0x07,0xC0,0x0F,0xE0,0x1F,0xF0,0x3E,0x78,0x7C,0x3C,0xF8,0x18,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0xFF,0x38,0xC0,0xFF,0x3F,0xF0,0xE3,0x1F,0xF0,0x80,0x0F,0x78,0x00,0x1F,0x3C,0x80,0x1F,0x3C,0xC0,0x3D,0x3C,0xE0,0x3C,0x1C,0x70,0x3C,0x1E,0x78,0x3C,0x1E,0x3C,0x3C,0x1E,0x1E,0x3C,0x1E,0x0F,0x3C,0x1C,0x07,0x3C,0xBC,0x03,0x3C,0xFC,0x01,0x1E,0xF8,0x00,0x1E,0xF8,0x00,0x0F,0xF8,0xC3,0x07,0xFC,0xFF,0x03,0x9E,0xFF,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD8 '<non-printable>'
    0x80,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x30,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x38,0x00,0x07,0x78,0x80,0x07,0x78,0x80,0x07,0xF0,0xE1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xD9 '<non-printable>'
    0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x38,0x00,0x07,0x78,0x80,0x07,0x78,0x80,0x07,0xF0,0xE1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDA '<non-printable>'
    0x00,0x1E,0x00,0x00,0x3F,0x00,0x00,0x7F,0x00,0x80,0xF7,0x00,0xC0,0x00,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x38,0x00,0x07,0x78,0x80,0x07,0x78,0x80,0x07,0xF0,0xE1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDB '<non-printable>'
    0x00,0x00,0x00,0x80,0xF7,0x00,0x80,0xF7,0x00,0x80,0xF7,0x00,0x00,0x00,0x00,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x3C,0x00,0x0F,0x38,0x00,0x07,0x78,0x80,0x07,0x78,0x80,0x07,0xF0,0xE1,0x03,0xE0,0xFF,0x01,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDC '<non-printable>'
    0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x1F,0x00,0x0F,0x1E,0x80,0x07,0x3C,0xC0,0x07,0x7C,0xC0,0x03,0x78,0xE0,0x01,0xF0,0xF0,0x00,0xF0,0xF1,0x00,0xE0,0x79,0x00,0xC0,0x3B,0x00,0xC0,0x3F,0x00,0x80,0x1F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDD '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0xFC,0x1F,0x00,0xFC,0xFF,0x01,0xFC,0xFF,0x03,0x3C,0xC0,0x03,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0x80,0x07,0x3C,0xC0,0x03,0xFC,0xFF,0x03,0xFC,0xFF,0x01,0xFC,0x3F,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDE '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0xF0,0x1F,0x00,0x78,0x3C,0x00,0x38,0x38,0x00,0x3C,0x38,0x00,0x3C,0x38,0x00,0x3C,0x3C,0x00,0x3C,0x1C,0x00,0x3C,0x1E,0x00,0x3C,0x0E,0x00,0x3C,0x1E,0x00,0x3C,0x3E,0x00,0x3C,0x7C,0x00,0x3C,0xF8,0x00,0x3C,0xE0,0x01,0x3C,0xC0,0x03,0x3C,0xC0,0x03,0xBC,0xC3,0x03,0xFC,0xE7,0x01,0x3C,0xFF,0x01,0x3C,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xDF '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xC0,0x03,0x80,0x07,0x00,0x07,0x00,0x0C,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE0 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE1 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x07,0xE0,0x0F,0xF0,0x1E,0x18,0x00,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE2 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xF0,0x1F,0xF8,0x1F,0x38,0x0E,0x00,0x00,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE3 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x60,0x06,0x60,0x06,0xC0,0x06,0x80,0x03,0x00,0x00,0xF0,0x1F,0xF8,0x3F,0x3C,0x78,0x1C,0x78,0x1E,0x70,0x00,0x78,0xC0,0x7F,0xF8,0x7F,0xFC,0x70,0x1E,0x78,0x1E,0x78,0x1E,0x78,0x1E,0x7C,0xFC,0x7F,0xF8,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xDF,0x3F,0x00,0xF8,0xFF,0xFF,0x00,0x3C,0xF8,0xF0,0x00,0x1C,0x78,0xE0,0x01,0x1E,0x78,0xC0,0x01,0x00,0x78,0xC0,0x01,0xC0,0xFF,0xFF,0x03,0xF8,0xFF,0xFF,0x03,0xFC,0x78,0x00,0x00,0x1E,0x78,0x00,0x00,0x1E,0x78,0xC0,0x03,0x1E,0x78,0xE0,0x01,0x1E,0xFE,0xF1,0x01,0xFC,0xEF,0xFF,0x00,0xF8,0xC7,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0xF8,0x3F,0x7C,0x3C,0x3C,0x78,0x1C,0x38,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x18,0x1C,0x70,0x3C,0x78,0x7C,0x3C,0xF8,0x3F,0xE0,0x0F,0x80,0x01,0xC0,0x03,0x00,0x07,0x00,0x0F,0xE0,0x07,0xE0,0x03,  // 0xE7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xE0,0x01,0xC0,0x03,0x80,0x03,0x00,0x06,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0xFE,0xFF,0xFE,0xFF,0x1E,0x00,0x1E,0x00,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE8 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0xFE,0xFF,0xFE,0xFF,0x1E,0x00,0x1E,0x00,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xE9 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x07,0xE0,0x0F,0xF0,0x1E,0x18,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0xFE,0xFF,0xFE,0xFF,0x1E,0x00,0x1E,0x00,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xEA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0xFE,0xFF,0xFE,0xFF,0x1E,0x00,0x1E,0x00,0x1E,0xF0,0x3C,0x70,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xEB '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x1F,0x1E,0x3C,0x38,0x60,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xEC '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x01,0xF0,0x00,0xF0,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xED '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x7E,0x00,0xFE,0x00,0xEF,0x01,0x01,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xEE '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEF,0x01,0xEF,0x01,0xEF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xEF '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x19,0xC0,0x3F,0x80,0x0F,0xE0,0x0F,0xF0,0x1E,0x30,0x1C,0xE0,0x3F,0xF8,0x7F,0x7C,0x7C,0x3C,0x78,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0xF0,0x3C,0x78,0x7C,0x7C,0xF8,0x3F,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF0 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE0,0x3F,0xF0,0x3F,0x70,0x1C,0x00,0x00,0x00,0x00,0xDC,0x1F,0xFC,0x3F,0x7C,0x78,0x3C,0x78,0x3C,0x70,0x3C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF1 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x01,0xE0,0x01,0xC0,0x03,0x80,0x03,0x00,0x06,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF2 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF3 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x07,0xE0,0x0F,0xF0,0x1E,0x18,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xF0,0x1F,0xF8,0x1F,0x38,0x0E,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0xF8,0x3F,0x7C,0x78,0x3C,0x70,0x1C,0xF0,0x1E,0xF0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xF0,0x1C,0xF0,0x3C,0xF0,0x7C,0x78,0xF8,0x3F,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFE,0xFF,0x00,0x00,0x00,0x00,0xC0,0x03,0xC0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0xE0,0xFF,0x01,0xF0,0xFF,0x00,0x78,0xF8,0x00,0x38,0xF8,0x00,0x3C,0xFC,0x01,0x3C,0xFE,0x01,0x1C,0xEE,0x01,0x1C,0xE7,0x01,0x9C,0xE3,0x01,0xFC,0xE1,0x01,0xFC,0xE1,0x01,0xF8,0xF0,0x00,0x78,0xF8,0x00,0xF8,0x7F,0x00,0xF8,0x1F,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF8 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xC0,0x03,0x80,0x07,0x00,0x07,0x00,0x0C,0x00,0x00,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x3C,0x78,0x3C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xF9 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x3C,0x78,0x3C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xFA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xE0,0x07,0xE0,0x0F,0xF0,0x1E,0x18,0x00,0x00,0x00,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x3C,0x78,0x3C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xFB '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x1C,0x78,0x3C,0x78,0x3C,0x7C,0xF8,0x7F,0xF0,0x77,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xFC '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x07,0x80,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,0x0F,0x70,0x1E,0x78,0x1E,0x38,0x1C,0x3C,0x3C,0x3C,0x38,0x1C,0x78,0x1E,0x78,0x0E,0x70,0x0E,0xF0,0x0F,0xF0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xE0,0x01,0xF6,0x00,0xFC,0x00,0x7C,0x00,  // 0xFD '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0xDC,0x1F,0xFC,0x3F,0x7C,0x78,0x3C,0x70,0x3C,0xF0,0x1C,0xF0,0x1C,0xF0,0x1C,0xF0,0x1C,0xF0,0x1C,0xF0,0x3C,0xF0,0x3C,0x78,0x7C,0x7C,0xFC,0x3F,0xDC,0x0F,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,  // 0xFE '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x1E,0xF0,0x1E,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x70,0x1E,0x78,0x1E,0x38,0x1C,0x3C,0x3C,0x3C,0x38,0x1C,0x78,0x1E,0x78,0x0E,0x70,0x0E,0xF0,0x0F,0xF0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x03,0xC0,0x03,0xC0,0x01,0xC0,0x01,0xE0,0x01,0xF6,0x00,0xFC,0x00,0x7C,0x00  // 0xFF '<non-printable>'
};
