//
//    This script modifies a font file which was generated with a tool by
//    MikroElektronika - GLD Font Creator.
//
//    That tool creates the font data set for an embedded system from a Windows
//    True Type font. The user is encouraged to ensure that the font used is
//    properly licensed, or drawn from a source that does not have a license
//    restriction.
//
//    This script will read and then modify the file for a few specific purposes:
//      * <space>   character is redefined to set the width to 1/4 the height,
//                  because the normal behavior sets it much too narrow.
//      * '0' - '9' characters are redefined to set the width equal to the width
//                  of the widest digit, or to the user override value.
//
//    And just because it can, it then improves upon the documentation in the
//    resulting data structure.
//
//    This script was created by Smartware Computing, and is provided 'as is'
//    with no warranty or suitability of fitness for any purpose. Anyone may use
//    or modify it subject to the agreement that:
//      * The Smartware copyright statement remains intact.
//      * Modifications for derivative use are clearly stated in this header.
//
//    Modifications from the original:
//      * automatically change 'unsigned short' to 'unsigned char'.
//
// Script Activation:
//   ParseMikroeFont raw_BPG_Arial10x12.h BPG_Arial10x12.h


//Font Generated by MikroElektronika GLCD Font Creator 1.2.0.0
//MikroElektrnika 2011
//http://www.mikroe.com

//GLCD FontName : BPG_Arial10x12
//GLCD FontSize : 10 x 12

const unsigned char BPG_Arial10x12[] = {
    // Font Info
    0x00,                   // Unknown #1
    0x00,                   // Unknown #2
    0x20,0x00,              // FirstChar
    0xFF,0x00,              // LastChar
    0x0C,                   // FontHeight
    0x00,                   // Unknown #3
    // Directory of Chars  [Width] [Offset-L] [Offset-M] [Offset-H]
    0x03,0x88,0x03,0x00,    // 0x20 ' '
    0x02,0x94,0x03,0x00,    // 0x21 '!'
    0x03,0xA0,0x03,0x00,    // 0x22 '"'
    0x06,0xAC,0x03,0x00,    // 0x23 '#'
    0x06,0xB8,0x03,0x00,    // 0x24 '$'
    0x09,0xC4,0x03,0x00,    // 0x25 '%'
    0x07,0xDC,0x03,0x00,    // 0x26 '&'
    0x02,0xE8,0x03,0x00,    // 0x27 '''
    0x03,0xF4,0x03,0x00,    // 0x28 '('
    0x03,0x00,0x04,0x00,    // 0x29 ')'
    0x05,0x0C,0x04,0x00,    // 0x2A '*'
    0x06,0x18,0x04,0x00,    // 0x2B '+'
    0x02,0x24,0x04,0x00,    // 0x2C ','
    0x03,0x30,0x04,0x00,    // 0x2D '-'
    0x02,0x3C,0x04,0x00,    // 0x2E '.'
    0x03,0x48,0x04,0x00,    // 0x2F '/'
    0x06,0x54,0x04,0x00,    // 0x30 '0'
    0x06,0x60,0x04,0x00,    // 0x31 '1'
    0x06,0x6C,0x04,0x00,    // 0x32 '2'
    0x06,0x78,0x04,0x00,    // 0x33 '3'
    0x06,0x84,0x04,0x00,    // 0x34 '4'
    0x06,0x90,0x04,0x00,    // 0x35 '5'
    0x06,0x9C,0x04,0x00,    // 0x36 '6'
    0x06,0xA8,0x04,0x00,    // 0x37 '7'
    0x06,0xB4,0x04,0x00,    // 0x38 '8'
    0x06,0xC0,0x04,0x00,    // 0x39 '9'
    0x02,0xCC,0x04,0x00,    // 0x3A ':'
    0x02,0xD8,0x04,0x00,    // 0x3B ';'
    0x06,0xE4,0x04,0x00,    // 0x3C '<'
    0x06,0xF0,0x04,0x00,    // 0x3D '='
    0x06,0xFC,0x04,0x00,    // 0x3E '>'
    0x05,0x08,0x05,0x00,    // 0x3F '?'
    0x09,0x14,0x05,0x00,    // 0x40 '@'
    0x07,0x2C,0x05,0x00,    // 0x41 'A'
    0x07,0x38,0x05,0x00,    // 0x42 'B'
    0x07,0x44,0x05,0x00,    // 0x43 'C'
    0x07,0x50,0x05,0x00,    // 0x44 'D'
    0x07,0x5C,0x05,0x00,    // 0x45 'E'
    0x07,0x68,0x05,0x00,    // 0x46 'F'
    0x08,0x74,0x05,0x00,    // 0x47 'G'
    0x07,0x80,0x05,0x00,    // 0x48 'H'
    0x02,0x8C,0x05,0x00,    // 0x49 'I'
    0x05,0x98,0x05,0x00,    // 0x4A 'J'
    0x07,0xA4,0x05,0x00,    // 0x4B 'K'
    0x06,0xB0,0x05,0x00,    // 0x4C 'L'
    0x08,0xBC,0x05,0x00,    // 0x4D 'M'
    0x07,0xC8,0x05,0x00,    // 0x4E 'N'
    0x08,0xD4,0x05,0x00,    // 0x4F 'O'
    0x07,0xE0,0x05,0x00,    // 0x50 'P'
    0x07,0xEC,0x05,0x00,    // 0x51 'Q'
    0x07,0xF8,0x05,0x00,    // 0x52 'R'
    0x06,0x04,0x06,0x00,    // 0x53 'S'
    0x07,0x10,0x06,0x00,    // 0x54 'T'
    0x06,0x1C,0x06,0x00,    // 0x55 'U'
    0x07,0x28,0x06,0x00,    // 0x56 'V'
    0x09,0x34,0x06,0x00,    // 0x57 'W'
    0x07,0x4C,0x06,0x00,    // 0x58 'X'
    0x07,0x58,0x06,0x00,    // 0x59 'Y'
    0x06,0x64,0x06,0x00,    // 0x5A 'Z'
    0x03,0x70,0x06,0x00,    // 0x5B '['
    0x03,0x7C,0x06,0x00,    // 0x5C '\\'
    0x02,0x88,0x06,0x00,    // 0x5D ']'
    0x05,0x94,0x06,0x00,    // 0x5E '^'
    0x06,0xA0,0x06,0x00,    // 0x5F '_'
    0x03,0xAC,0x06,0x00,    // 0x60 '`'
    0x06,0xB8,0x06,0x00,    // 0x61 'a'
    0x06,0xC4,0x06,0x00,    // 0x62 'b'
    0x05,0xD0,0x06,0x00,    // 0x63 'c'
    0x05,0xDC,0x06,0x00,    // 0x64 'd'
    0x05,0xE8,0x06,0x00,    // 0x65 'e'
    0x04,0xF4,0x06,0x00,    // 0x66 'f'
    0x05,0x00,0x07,0x00,    // 0x67 'g'
    0x05,0x0C,0x07,0x00,    // 0x68 'h'
    0x02,0x18,0x07,0x00,    // 0x69 'i'
    0x02,0x24,0x07,0x00,    // 0x6A 'j'
    0x05,0x30,0x07,0x00,    // 0x6B 'k'
    0x02,0x3C,0x07,0x00,    // 0x6C 'l'
    0x08,0x48,0x07,0x00,    // 0x6D 'm'
    0x05,0x54,0x07,0x00,    // 0x6E 'n'
    0x06,0x60,0x07,0x00,    // 0x6F 'o'
    0x05,0x6C,0x07,0x00,    // 0x70 'p'
    0x05,0x78,0x07,0x00,    // 0x71 'q'
    0x04,0x84,0x07,0x00,    // 0x72 'r'
    0x05,0x90,0x07,0x00,    // 0x73 's'
    0x03,0x9C,0x07,0x00,    // 0x74 't'
    0x05,0xA8,0x07,0x00,    // 0x75 'u'
    0x05,0xB4,0x07,0x00,    // 0x76 'v'
    0x07,0xC0,0x07,0x00,    // 0x77 'w'
    0x05,0xCC,0x07,0x00,    // 0x78 'x'
    0x05,0xD8,0x07,0x00,    // 0x79 'y'
    0x05,0xE4,0x07,0x00,    // 0x7A 'z'
    0x03,0xF0,0x07,0x00,    // 0x7B '{'
    0x02,0xFC,0x07,0x00,    // 0x7C '|'
    0x03,0x08,0x08,0x00,    // 0x7D '}'
    0x06,0x14,0x08,0x00,    // 0x7E '~'
    0x03,0x20,0x08,0x00,    // 0x7F '<non-printable>'
    0x01,0x2C,0x08,0x00,    // 0x80 '<non-printable>'
    0x01,0x38,0x08,0x00,    // 0x81 '<non-printable>'
    0x01,0x44,0x08,0x00,    // 0x82 '<non-printable>'
    0x01,0x50,0x08,0x00,    // 0x83 '<non-printable>'
    0x01,0x5C,0x08,0x00,    // 0x84 '<non-printable>'
    0x01,0x68,0x08,0x00,    // 0x85 '<non-printable>'
    0x01,0x74,0x08,0x00,    // 0x86 '<non-printable>'
    0x01,0x80,0x08,0x00,    // 0x87 '<non-printable>'
    0x01,0x8C,0x08,0x00,    // 0x88 '<non-printable>'
    0x01,0x98,0x08,0x00,    // 0x89 '<non-printable>'
    0x01,0xA4,0x08,0x00,    // 0x8A '<non-printable>'
    0x01,0xB0,0x08,0x00,    // 0x8B '<non-printable>'
    0x01,0xBC,0x08,0x00,    // 0x8C '<non-printable>'
    0x01,0xC8,0x08,0x00,    // 0x8D '<non-printable>'
    0x01,0xD4,0x08,0x00,    // 0x8E '<non-printable>'
    0x01,0xE0,0x08,0x00,    // 0x8F '<non-printable>'
    0x01,0xEC,0x08,0x00,    // 0x90 '<non-printable>'
    0x01,0xF8,0x08,0x00,    // 0x91 '<non-printable>'
    0x01,0x04,0x09,0x00,    // 0x92 '<non-printable>'
    0x01,0x10,0x09,0x00,    // 0x93 '<non-printable>'
    0x01,0x1C,0x09,0x00,    // 0x94 '<non-printable>'
    0x01,0x28,0x09,0x00,    // 0x95 '<non-printable>'
    0x01,0x34,0x09,0x00,    // 0x96 '<non-printable>'
    0x01,0x40,0x09,0x00,    // 0x97 '<non-printable>'
    0x01,0x4C,0x09,0x00,    // 0x98 '<non-printable>'
    0x01,0x58,0x09,0x00,    // 0x99 '<non-printable>'
    0x01,0x64,0x09,0x00,    // 0x9A '<non-printable>'
    0x01,0x70,0x09,0x00,    // 0x9B '<non-printable>'
    0x01,0x7C,0x09,0x00,    // 0x9C '<non-printable>'
    0x01,0x88,0x09,0x00,    // 0x9D '<non-printable>'
    0x01,0x94,0x09,0x00,    // 0x9E '<non-printable>'
    0x01,0xA0,0x09,0x00,    // 0x9F '<non-printable>'
    0x01,0xAC,0x09,0x00,    // 0xA0 '<non-printable>'
    0x02,0xB8,0x09,0x00,    // 0xA1 '<non-printable>'
    0x06,0xC4,0x09,0x00,    // 0xA2 '<non-printable>'
    0x06,0xD0,0x09,0x00,    // 0xA3 '<non-printable>'
    0x06,0xDC,0x09,0x00,    // 0xA4 '<non-printable>'
    0x06,0xE8,0x09,0x00,    // 0xA5 '<non-printable>'
    0x02,0xF4,0x09,0x00,    // 0xA6 '<non-printable>'
    0x06,0x00,0x0A,0x00,    // 0xA7 '<non-printable>'
    0x03,0x0C,0x0A,0x00,    // 0xA8 '<non-printable>'
    0x08,0x18,0x0A,0x00,    // 0xA9 '<non-printable>'
    0x04,0x24,0x0A,0x00,    // 0xAA '<non-printable>'
    0x05,0x30,0x0A,0x00,    // 0xAB '<non-printable>'
    0x06,0x3C,0x0A,0x00,    // 0xAC '<non-printable>'
    0x03,0x48,0x0A,0x00,    // 0xAD '<non-printable>'
    0x08,0x54,0x0A,0x00,    // 0xAE '<non-printable>'
    0x06,0x60,0x0A,0x00,    // 0xAF '<non-printable>'
    0x04,0x6C,0x0A,0x00,    // 0xB0 '<non-printable>'
    0x06,0x78,0x0A,0x00,    // 0xB1 '<non-printable>'
    0x03,0x84,0x0A,0x00,    // 0xB2 '<non-printable>'
    0x03,0x90,0x0A,0x00,    // 0xB3 '<non-printable>'
    0x03,0x9C,0x0A,0x00,    // 0xB4 '<non-printable>'
    0x05,0xA8,0x0A,0x00,    // 0xB5 '<non-printable>'
    0x06,0xB4,0x0A,0x00,    // 0xB6 '<non-printable>'
    0x02,0xC0,0x0A,0x00,    // 0xB7 '<non-printable>'
    0x03,0xCC,0x0A,0x00,    // 0xB8 '<non-printable>'
    0x03,0xD8,0x0A,0x00,    // 0xB9 '<non-printable>'
    0x04,0xE4,0x0A,0x00,    // 0xBA '<non-printable>'
    0x05,0xF0,0x0A,0x00,    // 0xBB '<non-printable>'
    0x09,0xFC,0x0A,0x00,    // 0xBC '<non-printable>'
    0x09,0x14,0x0B,0x00,    // 0xBD '<non-printable>'
    0x09,0x2C,0x0B,0x00,    // 0xBE '<non-printable>'
    0x06,0x44,0x0B,0x00,    // 0xBF '<non-printable>'
    0x07,0x50,0x0B,0x00,    // 0xC0 '<non-printable>'
    0x07,0x5C,0x0B,0x00,    // 0xC1 '<non-printable>'
    0x07,0x68,0x0B,0x00,    // 0xC2 '<non-printable>'
    0x07,0x74,0x0B,0x00,    // 0xC3 '<non-printable>'
    0x07,0x80,0x0B,0x00,    // 0xC4 '<non-printable>'
    0x07,0x8C,0x0B,0x00,    // 0xC5 '<non-printable>'
    0x09,0x98,0x0B,0x00,    // 0xC6 '<non-printable>'
    0x08,0xB0,0x0B,0x00,    // 0xC7 '<non-printable>'
    0x07,0xBC,0x0B,0x00,    // 0xC8 '<non-printable>'
    0x07,0xC8,0x0B,0x00,    // 0xC9 '<non-printable>'
    0x07,0xD4,0x0B,0x00,    // 0xCA '<non-printable>'
    0x07,0xE0,0x0B,0x00,    // 0xCB '<non-printable>'
    0x03,0xEC,0x0B,0x00,    // 0xCC '<non-printable>'
    0x03,0xF8,0x0B,0x00,    // 0xCD '<non-printable>'
    0x04,0x04,0x0C,0x00,    // 0xCE '<non-printable>'
    0x03,0x10,0x0C,0x00,    // 0xCF '<non-printable>'
    0x07,0x1C,0x0C,0x00,    // 0xD0 '<non-printable>'
    0x07,0x28,0x0C,0x00,    // 0xD1 '<non-printable>'
    0x08,0x34,0x0C,0x00,    // 0xD2 '<non-printable>'
    0x08,0x40,0x0C,0x00,    // 0xD3 '<non-printable>'
    0x08,0x4C,0x0C,0x00,    // 0xD4 '<non-printable>'
    0x08,0x58,0x0C,0x00,    // 0xD5 '<non-printable>'
    0x08,0x64,0x0C,0x00,    // 0xD6 '<non-printable>'
    0x06,0x70,0x0C,0x00,    // 0xD7 '<non-printable>'
    0x08,0x7C,0x0C,0x00,    // 0xD8 '<non-printable>'
    0x07,0x88,0x0C,0x00,    // 0xD9 '<non-printable>'
    0x07,0x94,0x0C,0x00,    // 0xDA '<non-printable>'
    0x07,0xA0,0x0C,0x00,    // 0xDB '<non-printable>'
    0x07,0xAC,0x0C,0x00,    // 0xDC '<non-printable>'
    0x07,0xB8,0x0C,0x00,    // 0xDD '<non-printable>'
    0x07,0xC4,0x0C,0x00,    // 0xDE '<non-printable>'
    0x06,0xD0,0x0C,0x00,    // 0xDF '<non-printable>'
    0x06,0xDC,0x0C,0x00,    // 0xE0 '<non-printable>'
    0x06,0xE8,0x0C,0x00,    // 0xE1 '<non-printable>'
    0x06,0xF4,0x0C,0x00,    // 0xE2 '<non-printable>'
    0x06,0x00,0x0D,0x00,    // 0xE3 '<non-printable>'
    0x06,0x0C,0x0D,0x00,    // 0xE4 '<non-printable>'
    0x06,0x18,0x0D,0x00,    // 0xE5 '<non-printable>'
    0x09,0x24,0x0D,0x00,    // 0xE6 '<non-printable>'
    0x05,0x3C,0x0D,0x00,    // 0xE7 '<non-printable>'
    0x06,0x48,0x0D,0x00,    // 0xE8 '<non-printable>'
    0x06,0x54,0x0D,0x00,    // 0xE9 '<non-printable>'
    0x06,0x60,0x0D,0x00,    // 0xEA '<non-printable>'
    0x06,0x6C,0x0D,0x00,    // 0xEB '<non-printable>'
    0x03,0x78,0x0D,0x00,    // 0xEC '<non-printable>'
    0x03,0x84,0x0D,0x00,    // 0xED '<non-printable>'
    0x04,0x90,0x0D,0x00,    // 0xEE '<non-printable>'
    0x03,0x9C,0x0D,0x00,    // 0xEF '<non-printable>'
    0x06,0xA8,0x0D,0x00,    // 0xF0 '<non-printable>'
    0x05,0xB4,0x0D,0x00,    // 0xF1 '<non-printable>'
    0x06,0xC0,0x0D,0x00,    // 0xF2 '<non-printable>'
    0x06,0xCC,0x0D,0x00,    // 0xF3 '<non-printable>'
    0x06,0xD8,0x0D,0x00,    // 0xF4 '<non-printable>'
    0x06,0xE4,0x0D,0x00,    // 0xF5 '<non-printable>'
    0x06,0xF0,0x0D,0x00,    // 0xF6 '<non-printable>'
    0x06,0xFC,0x0D,0x00,    // 0xF7 '<non-printable>'
    0x06,0x08,0x0E,0x00,    // 0xF8 '<non-printable>'
    0x05,0x14,0x0E,0x00,    // 0xF9 '<non-printable>'
    0x05,0x20,0x0E,0x00,    // 0xFA '<non-printable>'
    0x05,0x2C,0x0E,0x00,    // 0xFB '<non-printable>'
    0x05,0x38,0x0E,0x00,    // 0xFC '<non-printable>'
    0x05,0x44,0x0E,0x00,    // 0xFD '<non-printable>'
    0x06,0x50,0x0E,0x00,    // 0xFE '<non-printable>'
    0x05,0x5C,0x0E,0x00,    // 0xFF '<non-printable>'
    // Chars Bitstream
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x20 ' '
    0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x02,0x00,0x00,  // 0x21 '!'
    0x00,0x00,0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x22 '"'
    0x00,0x00,0x34,0x14,0x3F,0x12,0x12,0x3F,0x0A,0x09,0x00,0x00,  // 0x23 '#'
    0x00,0x08,0x1C,0x2A,0x0A,0x0A,0x1C,0x28,0x2A,0x1C,0x08,0x00,  // 0x24 '$'
    0x00,0x00,0x00,0x00,0x4E,0x00,0x4A,0x00,0x2A,0x00,0x2E,0x00,0xD0,0x00,0x50,0x01,0x48,0x01,0xCC,0x01,0x00,0x00,0x00,0x00,  // 0x25 '%'
    0x00,0x00,0x1C,0x12,0x14,0x0C,0x2A,0x73,0x32,0x5E,0x00,0x00,  // 0x26 '&'
    0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x27 '''
    0x00,0x00,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x04,  // 0x28 '('
    0x00,0x00,0x02,0x02,0x04,0x04,0x04,0x04,0x04,0x04,0x02,0x02,  // 0x29 ')'
    0x00,0x00,0x15,0x0E,0x1F,0x0E,0x15,0x00,0x00,0x00,0x00,0x00,  // 0x2A '*'
    0x00,0x00,0x00,0x00,0x08,0x08,0x3E,0x08,0x08,0x00,0x00,0x00,  // 0x2B '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x01,  // 0x2C ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,  // 0x2D '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,  // 0x2E '.'
    0x00,0x00,0x04,0x04,0x02,0x02,0x02,0x02,0x01,0x01,0x00,0x00,  // 0x2F '/'
    0x00,0x00,0x0C,0x12,0x21,0x21,0x21,0x21,0x12,0x0C,0x00,0x00,  // 0x30 '0'
    0x00,0x00,0x08,0x0C,0x0A,0x08,0x08,0x08,0x08,0x08,0x00,0x00,  // 0x31 '1'
    0x00,0x00,0x1E,0x21,0x20,0x10,0x0C,0x02,0x01,0x3F,0x00,0x00,  // 0x32 '2'
    0x00,0x00,0x0E,0x11,0x10,0x0C,0x10,0x10,0x11,0x0E,0x00,0x00,  // 0x33 '3'
    0x00,0x00,0x10,0x18,0x14,0x12,0x12,0x3F,0x10,0x10,0x00,0x00,  // 0x34 '4'
    0x00,0x00,0x0F,0x01,0x01,0x0F,0x10,0x10,0x11,0x0E,0x00,0x00,  // 0x35 '5'
    0x00,0x00,0x0E,0x11,0x01,0x0D,0x13,0x11,0x13,0x0E,0x00,0x00,  // 0x36 '6'
    0x00,0x00,0x1F,0x10,0x08,0x08,0x04,0x04,0x04,0x04,0x00,0x00,  // 0x37 '7'
    0x00,0x00,0x0E,0x11,0x11,0x0E,0x11,0x11,0x11,0x0E,0x00,0x00,  // 0x38 '8'
    0x00,0x00,0x0E,0x11,0x11,0x11,0x1E,0x10,0x11,0x0E,0x00,0x00,  // 0x39 '9'
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,  // 0x3A ':'
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x02,0x02,  // 0x3B ';'
    0x00,0x00,0x00,0x20,0x18,0x06,0x06,0x18,0x20,0x00,0x00,0x00,  // 0x3C '<'
    0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,  // 0x3D '='
    0x00,0x00,0x00,0x02,0x04,0x18,0x30,0x0C,0x02,0x00,0x00,0x00,  // 0x3E '>'
    0x00,0x00,0x0E,0x11,0x11,0x10,0x0C,0x04,0x00,0x0C,0x00,0x00,  // 0x3F '?'
    0x00,0x00,0x7C,0x00,0x82,0x01,0x19,0x01,0x65,0x01,0x45,0x01,0x45,0x01,0x25,0x01,0xF9,0x00,0x02,0x01,0xFC,0x00,0x00,0x00,  // 0x40 '@'
    0x00,0x00,0x08,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0x41 'A'
    0x00,0x00,0x1E,0x22,0x22,0x3E,0x22,0x42,0x62,0x3E,0x00,0x00,  // 0x42 'B'
    0x00,0x00,0x3C,0x42,0x42,0x02,0x02,0x42,0x42,0x3C,0x00,0x00,  // 0x43 'C'
    0x00,0x00,0x3E,0x42,0x42,0x42,0x42,0x42,0x42,0x3E,0x00,0x00,  // 0x44 'D'
    0x00,0x00,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,  // 0x45 'E'
    0x00,0x00,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x46 'F'
    0x00,0x00,0x7C,0x86,0x82,0x02,0xE2,0x82,0x86,0x7C,0x00,0x00,  // 0x47 'G'
    0x00,0x00,0x42,0x42,0x42,0x7E,0x42,0x42,0x42,0x42,0x00,0x00,  // 0x48 'H'
    0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x49 'I'
    0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x0E,0x00,0x00,  // 0x4A 'J'
    0x00,0x00,0x62,0x32,0x1A,0x0E,0x1E,0x12,0x22,0x42,0x00,0x00,  // 0x4B 'K'
    0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x00,0x00,  // 0x4C 'L'
    0x00,0x00,0x86,0xC6,0xC6,0xCA,0xAA,0xAA,0xB2,0x92,0x00,0x00,  // 0x4D 'M'
    0x00,0x00,0x42,0x46,0x46,0x4A,0x52,0x72,0x62,0x42,0x00,0x00,  // 0x4E 'N'
    0x00,0x00,0x3C,0x46,0x82,0x82,0x82,0x82,0x46,0x3C,0x00,0x00,  // 0x4F 'O'
    0x00,0x00,0x3E,0x62,0x42,0x62,0x3E,0x02,0x02,0x02,0x00,0x00,  // 0x50 'P'
    0x00,0x00,0x3E,0x41,0x41,0x41,0x41,0x41,0x21,0x3E,0x40,0x00,  // 0x51 'Q'
    0x00,0x00,0x3E,0x42,0x42,0x22,0x1E,0x22,0x42,0x42,0x00,0x00,  // 0x52 'R'
    0x00,0x00,0x1E,0x21,0x01,0x1E,0x20,0x21,0x21,0x1E,0x00,0x00,  // 0x53 'S'
    0x00,0x00,0x7F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,  // 0x54 'T'
    0x00,0x00,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x1E,0x00,0x00,  // 0x55 'U'
    0x00,0x00,0x41,0x41,0x22,0x22,0x22,0x14,0x14,0x08,0x00,0x00,  // 0x56 'V'
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x11,0x01,0x92,0x00,0xAA,0x00,0xAA,0x00,0xCC,0x00,0x44,0x00,0x00,0x00,0x00,0x00,  // 0x57 'W'
    0x00,0x00,0x41,0x22,0x14,0x18,0x18,0x14,0x22,0x41,0x00,0x00,  // 0x58 'X'
    0x00,0x00,0x41,0x22,0x34,0x14,0x08,0x08,0x08,0x08,0x00,0x00,  // 0x59 'Y'
    0x00,0x00,0x3F,0x20,0x10,0x08,0x0C,0x06,0x01,0x3F,0x00,0x00,  // 0x5A 'Z'
    0x00,0x00,0x06,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x06,  // 0x5B '['
    0x00,0x00,0x01,0x01,0x01,0x02,0x02,0x02,0x04,0x04,0x00,0x00,  // 0x5C '\\'
    0x00,0x00,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,  // 0x5D ']'
    0x00,0x00,0x04,0x0A,0x0A,0x11,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5E '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,  // 0x5F '_'
    0x00,0x00,0x03,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x60 '`'
    0x00,0x00,0x00,0x00,0x1E,0x11,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0x61 'a'
    0x00,0x00,0x02,0x02,0x02,0x1E,0x22,0x22,0x22,0x1E,0x00,0x00,  // 0x62 'b'
    0x00,0x00,0x00,0x00,0x0E,0x11,0x01,0x01,0x11,0x1E,0x00,0x00,  // 0x63 'c'
    0x00,0x00,0x10,0x10,0x10,0x1E,0x11,0x11,0x11,0x1E,0x00,0x00,  // 0x64 'd'
    0x00,0x00,0x00,0x00,0x0E,0x11,0x11,0x0F,0x01,0x1E,0x00,0x00,  // 0x65 'e'
    0x00,0x00,0x0E,0x02,0x0F,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x66 'f'
    0x00,0x00,0x00,0x00,0x1E,0x11,0x11,0x11,0x13,0x1E,0x11,0x1E,  // 0x67 'g'
    0x00,0x00,0x02,0x02,0x02,0x1E,0x12,0x12,0x12,0x12,0x00,0x00,  // 0x68 'h'
    0x00,0x00,0x02,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x69 'i'
    0x00,0x00,0x02,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,  // 0x6A 'j'
    0x00,0x00,0x02,0x02,0x12,0x0A,0x06,0x0A,0x0A,0x12,0x00,0x00,  // 0x6B 'k'
    0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x6C 'l'
    0x00,0x00,0x00,0x00,0xCE,0xB2,0x92,0x92,0x92,0x92,0x00,0x00,  // 0x6D 'm'
    0x00,0x00,0x00,0x00,0x1E,0x12,0x12,0x12,0x12,0x12,0x00,0x00,  // 0x6E 'n'
    0x00,0x00,0x00,0x00,0x0C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0x6F 'o'
    0x00,0x00,0x00,0x00,0x0D,0x13,0x11,0x11,0x13,0x0F,0x01,0x01,  // 0x70 'p'
    0x00,0x00,0x00,0x00,0x1C,0x12,0x11,0x11,0x12,0x1E,0x10,0x10,  // 0x71 'q'
    0x00,0x00,0x00,0x00,0x0E,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0x72 'r'
    0x00,0x00,0x00,0x00,0x0E,0x11,0x06,0x18,0x11,0x0E,0x00,0x00,  // 0x73 's'
    0x00,0x00,0x02,0x02,0x07,0x02,0x02,0x02,0x02,0x06,0x00,0x00,  // 0x74 't'
    0x00,0x00,0x00,0x00,0x12,0x12,0x12,0x12,0x12,0x1E,0x00,0x00,  // 0x75 'u'
    0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x0A,0x0C,0x04,0x00,0x00,  // 0x76 'v'
    0x00,0x00,0x00,0x00,0x41,0x49,0x5A,0x56,0x66,0x24,0x00,0x00,  // 0x77 'w'
    0x00,0x00,0x00,0x00,0x13,0x0A,0x0C,0x0C,0x0A,0x13,0x00,0x00,  // 0x78 'x'
    0x00,0x00,0x00,0x00,0x11,0x12,0x12,0x0A,0x0C,0x04,0x04,0x06,  // 0x79 'y'
    0x00,0x00,0x00,0x00,0x1F,0x18,0x08,0x04,0x02,0x1F,0x00,0x00,  // 0x7A 'z'
    0x00,0x00,0x04,0x02,0x02,0x02,0x02,0x03,0x02,0x02,0x02,0x04,  // 0x7B '{'
    0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,  // 0x7C '|'
    0x00,0x00,0x01,0x02,0x02,0x02,0x02,0x04,0x02,0x02,0x02,0x01,  // 0x7D '}'
    0x00,0x00,0x00,0x00,0x00,0x26,0x19,0x00,0x00,0x00,0x00,0x00,  // 0x7E '~'
    0x00,0x00,0x00,0x07,0x05,0x05,0x05,0x05,0x05,0x05,0x07,0x00,  // 0x7F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x80 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x81 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x82 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x83 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x84 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x85 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x86 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x87 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x88 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x89 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8A '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8B '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8C '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8D '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8E '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x8F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x90 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x91 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x92 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x93 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x94 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x95 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x96 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x97 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x98 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x99 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9A '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9B '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9C '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9D '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9E '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x9F '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA0 '<non-printable>'
    0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x02,0x02,0x02,0x02,0x02,  // 0xA1 '<non-printable>'
    0x00,0x00,0x10,0x08,0x0C,0x1A,0x0A,0x06,0x36,0x1E,0x02,0x02,  // 0xA2 '<non-printable>'
    0x00,0x00,0x1C,0x12,0x22,0x02,0x0F,0x02,0x02,0x3F,0x00,0x00,  // 0xA3 '<non-printable>'
    0x00,0x00,0x00,0x11,0x3E,0x12,0x12,0x1E,0x31,0x00,0x00,0x00,  // 0xA4 '<non-printable>'
    0x00,0x00,0x21,0x12,0x12,0x0C,0x3F,0x3F,0x08,0x08,0x00,0x00,  // 0xA5 '<non-printable>'
    0x00,0x00,0x02,0x02,0x02,0x02,0x00,0x00,0x02,0x02,0x02,0x02,  // 0xA6 '<non-printable>'
    0x00,0x00,0x1E,0x12,0x02,0x0E,0x11,0x22,0x1C,0x18,0x12,0x1E,  // 0xA7 '<non-printable>'
    0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xA8 '<non-printable>'
    0x00,0x00,0x3C,0x42,0xB9,0x85,0x85,0xB9,0x42,0x3C,0x00,0x00,  // 0xA9 '<non-printable>'
    0x00,0x00,0x06,0x09,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x14,0x0A,0x0A,0x14,0x14,0x00,0x00,  // 0xAB '<non-printable>'
    0x00,0x00,0x00,0x00,0x3E,0x20,0x20,0x20,0x00,0x00,0x00,0x00,  // 0xAC '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,  // 0xAD '<non-printable>'
    0x00,0x00,0x3C,0x42,0x9D,0xA5,0x9D,0x95,0x62,0x3C,0x00,0x00,  // 0xAE '<non-printable>'
    0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xAF '<non-printable>'
    0x00,0x00,0x04,0x0A,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB0 '<non-printable>'
    0x00,0x00,0x00,0x04,0x04,0x04,0x3F,0x04,0x04,0x3F,0x00,0x00,  // 0xB1 '<non-printable>'
    0x00,0x00,0x06,0x05,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB2 '<non-printable>'
    0x00,0x00,0x06,0x05,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB3 '<non-printable>'
    0x00,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB4 '<non-printable>'
    0x00,0x00,0x00,0x00,0x12,0x12,0x12,0x12,0x12,0x1E,0x02,0x02,  // 0xB5 '<non-printable>'
    0x00,0x00,0x3E,0x17,0x17,0x17,0x14,0x14,0x14,0x14,0x14,0x14,  // 0xB6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,  // 0xB7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x06,  // 0xB8 '<non-printable>'
    0x00,0x00,0x04,0x06,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xB9 '<non-printable>'
    0x00,0x00,0x06,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00,0x00,  // 0xBA '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x0A,0x14,0x14,0x0A,0x0A,0x00,0x00,  // 0xBB '<non-printable>'
    0x00,0x00,0x00,0x00,0x84,0x00,0x46,0x00,0x24,0x00,0x24,0x01,0x94,0x01,0x48,0x01,0xC4,0x01,0x06,0x01,0x00,0x00,0x00,0x00,  // 0xBC '<non-printable>'
    0x00,0x00,0x00,0x00,0x84,0x00,0x46,0x00,0x24,0x00,0xD4,0x01,0x14,0x01,0x88,0x00,0x44,0x00,0xC6,0x01,0x00,0x00,0x00,0x00,  // 0xBD '<non-printable>'
    0x00,0x00,0x00,0x00,0x83,0x00,0x44,0x00,0x26,0x00,0x24,0x01,0x93,0x01,0x48,0x01,0xC4,0x01,0x06,0x01,0x00,0x00,0x00,0x00,  // 0xBE '<non-printable>'
    0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x08,0x04,0x02,0x22,0x1E,  // 0xBF '<non-printable>'
    0x0C,0x08,0x18,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC0 '<non-printable>'
    0x10,0x08,0x08,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC1 '<non-printable>'
    0x18,0x14,0x28,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC2 '<non-printable>'
    0x2C,0x10,0x08,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC3 '<non-printable>'
    0x14,0x00,0x08,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC4 '<non-printable>'
    0x00,0x1C,0x18,0x14,0x14,0x34,0x22,0x3E,0x42,0x41,0x00,0x00,  // 0xC5 '<non-printable>'
    0x00,0x00,0x00,0x00,0xF0,0x01,0x28,0x00,0x28,0x00,0xE4,0x01,0x24,0x00,0x3E,0x00,0x22,0x00,0xE1,0x01,0x00,0x00,0x00,0x00,  // 0xC6 '<non-printable>'
    0x00,0x00,0x3C,0x42,0x22,0x02,0x02,0xC2,0x42,0x3C,0x08,0x18,  // 0xC7 '<non-printable>'
    0x0C,0x08,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,  // 0xC8 '<non-printable>'
    0x10,0x08,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,  // 0xC9 '<non-printable>'
    0x18,0x14,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,  // 0xCA '<non-printable>'
    0x14,0x00,0x7E,0x02,0x02,0x3E,0x02,0x02,0x02,0x7E,0x00,0x00,  // 0xCB '<non-printable>'
    0x03,0x02,0x06,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xCC '<non-printable>'
    0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xCD '<non-printable>'
    0x06,0x05,0x0A,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xCE '<non-printable>'
    0x05,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xCF '<non-printable>'
    0x00,0x00,0x3E,0x62,0x42,0x42,0x4F,0x42,0x42,0x3E,0x00,0x00,  // 0xD0 '<non-printable>'
    0x2C,0x10,0x42,0x46,0x46,0x4A,0x52,0x72,0x62,0x42,0x00,0x00,  // 0xD1 '<non-printable>'
    0x0C,0x08,0x3C,0x46,0x82,0x82,0x82,0x82,0x42,0x3C,0x00,0x00,  // 0xD2 '<non-printable>'
    0x10,0x08,0x3C,0x46,0x82,0x82,0x82,0x82,0x42,0x3C,0x00,0x00,  // 0xD3 '<non-printable>'
    0x18,0x14,0x3C,0x46,0x82,0x82,0x82,0x82,0x42,0x3C,0x00,0x00,  // 0xD4 '<non-printable>'
    0x2C,0x10,0x3C,0x46,0x82,0x82,0x82,0x82,0x42,0x3C,0x00,0x00,  // 0xD5 '<non-printable>'
    0x14,0x00,0x3C,0x46,0x82,0x82,0x82,0x82,0x42,0x3C,0x00,0x00,  // 0xD6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x32,0x0C,0x0C,0x32,0x00,0x00,0x00,0x00,  // 0xD7 '<non-printable>'
    0x00,0x00,0xBC,0x46,0xA2,0x92,0x8A,0x86,0x46,0x3F,0x00,0x00,  // 0xD8 '<non-printable>'
    0x0C,0x08,0x52,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,  // 0xD9 '<non-printable>'
    0x10,0x08,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,  // 0xDA '<non-printable>'
    0x18,0x14,0x62,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,  // 0xDB '<non-printable>'
    0x14,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,  // 0xDC '<non-printable>'
    0x10,0x08,0x43,0x22,0x34,0x14,0x08,0x08,0x08,0x08,0x00,0x00,  // 0xDD '<non-printable>'
    0x00,0x00,0x02,0x02,0x3E,0x42,0x42,0x3E,0x02,0x02,0x00,0x00,  // 0xDE '<non-printable>'
    0x00,0x00,0x1C,0x12,0x12,0x0A,0x12,0x22,0x26,0x3A,0x00,0x00,  // 0xDF '<non-printable>'
    0x00,0x00,0x06,0x04,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE0 '<non-printable>'
    0x00,0x00,0x08,0x04,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE1 '<non-printable>'
    0x00,0x00,0x0C,0x0A,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE2 '<non-printable>'
    0x00,0x00,0x16,0x08,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE3 '<non-printable>'
    0x00,0x00,0x0A,0x00,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE4 '<non-printable>'
    0x00,0x00,0x0E,0x0C,0x1C,0x12,0x10,0x1E,0x11,0x3E,0x00,0x00,  // 0xE5 '<non-printable>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x32,0x01,0x10,0x01,0xFE,0x00,0x11,0x01,0xEE,0x01,0x00,0x00,0x00,0x00,  // 0xE6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x0C,0x12,0x01,0x01,0x12,0x1E,0x04,0x0C,  // 0xE7 '<non-printable>'
    0x00,0x00,0x06,0x04,0x0C,0x12,0x21,0x1F,0x32,0x1E,0x00,0x00,  // 0xE8 '<non-printable>'
    0x00,0x00,0x08,0x04,0x0C,0x12,0x21,0x1F,0x32,0x1E,0x00,0x00,  // 0xE9 '<non-printable>'
    0x00,0x00,0x0C,0x0A,0x1C,0x12,0x21,0x1F,0x32,0x1E,0x00,0x00,  // 0xEA '<non-printable>'
    0x00,0x00,0x0A,0x00,0x0C,0x12,0x21,0x1F,0x32,0x1E,0x00,0x00,  // 0xEB '<non-printable>'
    0x00,0x00,0x03,0x02,0x06,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xEC '<non-printable>'
    0x00,0x00,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xED '<non-printable>'
    0x00,0x00,0x06,0x05,0x0A,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xEE '<non-printable>'
    0x00,0x00,0x05,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,  // 0xEF '<non-printable>'
    0x00,0x00,0x14,0x0C,0x1E,0x12,0x21,0x21,0x12,0x1E,0x00,0x00,  // 0xF0 '<non-printable>'
    0x00,0x00,0x16,0x08,0x1E,0x12,0x12,0x12,0x12,0x12,0x00,0x00,  // 0xF1 '<non-printable>'
    0x00,0x00,0x06,0x04,0x0C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0xF2 '<non-printable>'
    0x00,0x00,0x08,0x04,0x0C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0xF3 '<non-printable>'
    0x00,0x00,0x0C,0x0A,0x1C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0xF4 '<non-printable>'
    0x00,0x00,0x16,0x08,0x0C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0xF5 '<non-printable>'
    0x00,0x00,0x0A,0x00,0x0C,0x12,0x21,0x21,0x22,0x1E,0x00,0x00,  // 0xF6 '<non-printable>'
    0x00,0x00,0x00,0x00,0x0C,0x00,0x3F,0x0C,0x00,0x00,0x00,0x00,  // 0xF7 '<non-printable>'
    0x00,0x00,0x00,0x00,0x3C,0x32,0x2A,0x2A,0x26,0x1E,0x00,0x00,  // 0xF8 '<non-printable>'
    0x00,0x00,0x06,0x04,0x1A,0x12,0x12,0x12,0x12,0x1E,0x00,0x00,  // 0xF9 '<non-printable>'
    0x00,0x00,0x08,0x04,0x12,0x12,0x12,0x12,0x12,0x1E,0x00,0x00,  // 0xFA '<non-printable>'
    0x00,0x00,0x0C,0x0A,0x12,0x12,0x12,0x12,0x12,0x1E,0x00,0x00,  // 0xFB '<non-printable>'
    0x00,0x00,0x0A,0x00,0x12,0x12,0x12,0x12,0x12,0x1E,0x00,0x00,  // 0xFC '<non-printable>'
    0x00,0x00,0x08,0x04,0x11,0x12,0x12,0x0A,0x0C,0x04,0x04,0x06,  // 0xFD '<non-printable>'
    0x00,0x00,0x02,0x02,0x0E,0x12,0x22,0x22,0x12,0x1E,0x02,0x02,  // 0xFE '<non-printable>'
    0x00,0x00,0x0A,0x00,0x11,0x12,0x12,0x0A,0x0C,0x04,0x04,0x06  // 0xFF '<non-printable>'
};
