#include "mbed.h"

void PWM_Tests(void) {
    int l;
    int i;
    float f;
    struct {
        const char * name;
        PwmOut pwm;
    } Pwms[] = {
        {"PWM 1", p21},
        {"PWM 2", p22},
        {"PWM 3", p23},
        {"PWM 4", p24},
        {"PWM 5", p25},
        {"PWM 6", p26},
        {"Led 1", LED1},
        {"Led 2", LED2},
        {"Led 3", LED3},
        {"Led 4", LED4}
    };
    const int numPwms = sizeof(Pwms) / sizeof(Pwms[0]);

    printf("PWM Test:\r\n");
    printf("    Unexplained interaction\r\n"
           "       PWM 3 and Led 4,\r\n"
           "       PWM 4 and Led 3,\r\n"
           "       PWM 5 and Led 2,\r\n"
           "       PWM 6 and Led 1\r\n");
    for (l=0; l<numPwms; l++) {
        printf("   Ramp %s [%d] PWM 5 times\r\n", Pwms[l].name, l);
        for (i=0; i<5; i++) {
            for (f=0.0; f<=1.0; f+= 0.1) {
                Pwms[l].pwm = f;
                wait(0.1);
            }
        }
        Pwms[l].pwm = 0;    // off when done
    }
}

int main() {
    while(1) {
        PWM_Tests();
        wait(5.0);
    }
}
