
#include "lpc_phy.h"
 
/** \brief DP83848 PHY status definitions */
#define DP8_REMOTEFAULT    (1 << 6)   /**< Remote fault */
#define DP8_FULLDUPLEX     (1 << 2)   /**< 1=full duplex */
#define DP8_SPEED10MBPS    (1 << 1)   /**< 1=10MBps speed */
#define DP8_VALID_LINK     (1 << 0)   /**< 1=Link active */
 
bool get_link_status(void);
 
// This function returns the status of transmission.
int get_transmission_status(void);  // 1 = 1/2 duplex, 2 = full duplex
 
// This function returns the speed of the connection.
int get_connection_speed(void);     // 10 or 100 Mb
 
// This function returns the current value in the MII data register.
uint32_t mii_read_data(void);
