#include "EthStatus.h"

// This function returns the current status of connection.
bool get_link_status(void)
{
    uint32_t tmp = lpc_mii_read_data();
    return (tmp & DP8_VALID_LINK) ? true : false;
}

// This function returns the status of transmission.
int get_transmission_status(void)
{
    uint32_t tmp = lpc_mii_read_data();
    if(tmp & DP8_FULLDUPLEX) {
        return 2;   // "FULL DUPLEX";
    } else {
        return 1;   // "HALF DUPLEX";
    }
}

// This function returns the speed of the connection.
int get_connection_speed()
{
    uint32_t tmp = lpc_mii_read_data();
    return (tmp & DP8_SPEED10MBPS) ? 10 : 100;
}

// This function returns the current value in the MII data register.
uint32_t mii_read_data(void)
{
    return lpc_mii_read_data();  // 16-bit MRDD - address 0x2008 4030
}
