#ifndef PLAYGROUND_H
#define PLAYGROUND_H


#include "mbed.h"
#include "RA8875.h"
#include "Block.h"
#include "Define.h"
#include "Field.h"

typedef enum {
    drop = 0,
    move_right = 1,
    move_left = 2,
    spin_cw = 3,
    spin_ccw = 4,
    ignore = 13
} gesture_t;

extern RA8875 TFT;
extern RawSerial pc;

void TFTInit();
void ReInitGame();
bool ReplayTouched();
void drawMap();
void drawMapV2();
void drawBlock(Block NewBlock);
void drawFrame();
void clrBlock(Block NewBlock);
gesture_t getGesture();
Block doGest(Block NewBlock, point_t p);
void gameOver(int score);
void drawScore(int score);
void drawPeriod(int period);
void drawNextBlock(Block NewBlock);
void clrNextBlock(Block NewBlock);

#endif // PLAYGROUND_H
