//
//  GAME AND DESIGN PARAMETERS

// Define this for 800x480 panel, undefine for 480x272
#define BIG_SCREEN

// Define this for Cap touch panel, undefine for resistive
#define CAP_TOUCH

#ifdef BIG_SCREEN
    #define LCD_W 800
    #define LCD_H 480
    #define LCD_C 8         // color - bits per pixel
    #define BL_NORM 25      // Backlight Normal setting (0 to 255)
#else
    #define LCD_W 480
    #define LCD_H 272
    #define LCD_C 8         // color - bits per pixel
    #define BL_NORM 25      // Backlight Normal setting (0 to 255)
#endif


// Title
//
// Score       (orig)            
//                +     |       |     |
//        Rotate  |     |       |     |   Rotate
//          Left  |     |       |     |   Right
//         -------|-|-|-| . . . |-|-|-|------
//                |                   |
//                |                   |
//         -------|-|-|-| . . . |-|-|-|------
//          Move  |     |       |     |   Move
//          Left  |     |       |     |   Right
//                |     |       |     |
//                |     |       |     |
//                |     |       |     |
//                |     |       |     |
//                =====================
//                        DROP It
//
//                           [SmallBlock]
//
#define TITLE_X             0
#define TITLE_Y             0

#define SCORE_X             LCD_W/8
#define SCORE_Y             LCD_H/6

#define PACE_X              LCD_W/8
#define PACE_Y              7*LCD_H/8

// Block Counts
#define MAXX                10
#define MAXY                12
#define BLOCK_SIZE          ((int)(LCD_H/20))
#define SPEED               100

#define ORIGIN_X            ((int)(LCD_W/2))
#define ORIGIN_Y            ((int)(LCD_H/6))

// Small Block
#define SB_X        ORIGIN_X+(MAXX+3)*BLOCK_SIZE
#define SB_Y        ORIGIN_Y+(2)*BLOCK_SIZE
#define SB_SIZE     8

#define ROT_RIGHT   ORIGIN_X+0,ORIGIN_Y+0,                              ORIGIN_X+4*BLOCK_SIZE,ORIGIN_Y+3*BLOCK_SIZE
#define ROT_LEFT    ORIGIN_X+(MAXX-2)*BLOCK_SIZE,ORIGIN_Y+0,            ORIGIN_X+(MAXX+2)*BLOCK_SIZE,ORIGIN_Y+3*BLOCK_SIZE
#define MOV_LEFT    ORIGIN_X+0,ORIGIN_Y+4*BLOCK_SIZE,                   ORIGIN_X+4*BLOCK_SIZE,ORIGIN_Y+(MAXY-1)*BLOCK_SIZE
#define MOV_RIGHT   ORIGIN_X+(MAXX-2)*BLOCK_SIZE,ORIGIN_Y+4*BLOCK_SIZE, ORIGIN_X+(MAXX+2)*BLOCK_SIZE,ORIGIN_Y+(MAXY-1)*BLOCK_SIZE
#define DROP        ORIGIN_X+0,ORIGIN_Y+MAXY*BLOCK_SIZE,                ORIGIN_X+(MAXX+2)*BLOCK_SIZE,ORIGIN_Y+(MAXY+4)*BLOCK_SIZE

#define REPLAY      SCORE_X,SCORE_Y+40, SCORE_X+100,SCORE_Y+40+100

#include "RA8875.h"         // colors
#define GreenYellow RGB(173,255,47)
#define Purple      RGB(128,0,128)
