//  mbed version   Graphics Working   PrintScreen Working? "/local/file.bmp"
//  v148           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v142           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v140           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v138           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v137           Yes                Yes
//  v136           Yes                Yes
//  v128           Yes                Yes

#include "mbed.h"           // v137
#include "RA8875.h"         // v148
#include "BPG_Arial08x08.h"
#include "BPG_Arial10x10.h"
#include "BPG_Arial20x20.h"
#include "BPG_Arial31x32.h"
#include "BPG_Arial63x63.h"
#include "FixedFont54x96.h"
#include "MyFont18x32.h"

RA8875 lcd(p5,p6,p7,p12,NC, "tft");    // MOSI, MISO, SCK, /ChipSelect, /reset, name
LocalFileSystem local("local");     // Because I want <PrintScreen>
Serial pc(USBTX, USBRX);            // And a little feedback
Timer measurement;


int main()
{
    pc.baud(460800);                            // I like a snappy terminal, so crank it up!
    pc.printf("\r\nRA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    measurement.start();
    lcd.init(800,480,8, 30);
    
    // **************************
    //RunTestSet(lcd, pc);  // If the library was compiled for test mode...
    
    lcd.foreground(RGB(255,255,0));
    lcd.puts(0,0, "RA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    lcd.SelectUserFont(Dave_Smart18x32);
    lcd.puts("**** ! Soft Fonts ! **** 0123456789\r\n");
    lcd.puts("ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont();
    lcd.puts("Back to normal\r\n");
    lcd.SelectUserFont(BPG_Arial08x08);
    lcd.puts("BPG_Arial08x08 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial08x08 abcdefghijklmnopqrstuvwxyz\r\n");    
    lcd.SelectUserFont(BPG_Arial10x10);
    lcd.puts("BPG_Arial10x10 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial10x10 abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont(BPG_Arial20x20);
    lcd.puts("BPG_Arial20x20  ");
    lcd.SelectUserFont(BPG_Arial31x32);
    lcd.puts("B32\r\n");
    lcd.SelectUserFont(BPG_Arial63x63);
    lcd.puts("B63");
    lcd.SetTextFontSize(2);
    lcd.puts("x2");
    lcd.SetTextCursor(300, 10);
    lcd.SetTextFontSize(3);
    lcd.SelectUserFont(FixedWidth_54x96);
    lcd.puts("A");
    pc.printf("Time trial completed in %d uSec\r\n", measurement.read_us());

    //pc.printf("PrintScreen activated ...\r\n");
    //RetCode_t r = lcd.PrintScreen(0,0,480,272,"/local/file.bmp");
    //pc.printf("  PrintScreen returned %d\r\n", r);
    
    while(1) {
        ;       // end
    }
}
