#include "mbed.h"           // v122
#include "RA8875.h"         // v125

RA8875 lcd(p5, p6, p7, p8, NC, p9, p10, p16, "tft");
LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

#define LCD_C 16         // color - bits per pixel
#define LCD_W 480
#define LCD_H 272

#define DELAY_MS 4000

void Emit(int line, point_t p1, point_t p2) {
    pc.printf("%3d: (%3d,%3d) - (%3d,%3d)\r\n", line, p1.x,p1.y, p2.x,p2.y);
}

point_t CreatePoint(loc_t x, loc_t y) {
    point_t pt;
    pt.x = x; pt.y = y;
    return pt;
}

point_t Translate(point_t pt) {
    point_t pp;
    pp.x = pt.y; pp.y = pt.x;
    return pp;
}

point_t Translate(loc_t x, loc_t y) {
    return Translate(CreatePoint(x,y));
}

int main()
{
    pc.baud(460800);
    pc.printf("Orientation Test, Build " __DATE__ " " __TIME__ "\r\n");
    
    lcd.init(LCD_W, LCD_H, LCD_C);
    lcd.Backlight(0.05f);

#if 0
    wait_ms(DELAY_MS);
    uint8_t val = lcd.ReadCommand(RA8875_FNCR1);
    val |= 0x10;    // 90 degree display
    lcd.WriteCommand(RA8875_FNCR1, val);        // Font Rotate
    val = lcd.ReadCommand(RA8875_DPCR);
    val |= 0x04;
    lcd.WriteCommand(RA8875_DPCR, val);         // Scan n-1 to 0 (up)
#endif
    lcd.cls();
    lcd.foreground(BrightBlue);
    //lcd.SetOrientation(RA8875::normal);
    //lcd.RenderImageFile(0,82,"/local/Jag.jpg");
    lcd.RenderImageFile(50,50,"/local/Jag.bmp");                    // 150 x 78
    lcd.line(Translate(0,0), Translate(479,271), BrightRed);
    lcd.line(Translate(0,0), Translate(271,479), BrightGreen);
    //lcd.rect(Translate(50,50), Translate(80,80), BrightBlue);
    lcd.puts(Translate(30,30), "(30,30) Normal Landscape");
    lcd.puts(Translate(30,90), "(30,90)");
    lcd.puts(Translate(30,200), "(30,200)");
    lcd.puts(Translate(30,300), "(30,300)");
    lcd.puts(Translate(30,450), "(30,450)");
    lcd.puts(Translate(300,200), "(300,200)");
    lcd.foreground(White);
    lcd.puts(Translate(100,250),"(100,250) Rotate");
    wait_ms(DELAY_MS);
    
#if 0
    lcd.cls();
    lcd.foreground(BrightGreen);
    lcd.SetOrientation(RA8875::rotate_90);
    //lcd.RenderImageFile(0,82,"/local/Jag.jpg");
    //lcd.RenderImageFile(0,160,"/local/Jag.bmp");
    lcd.line(0,0,479,271);
    lcd.line(0,0,271,479);
    lcd.rect(50,50, 80,80);
    lcd.puts(30,30, "(30,30) Normal Landscape");
    lcd.puts(30,90, "(30,90)");
    lcd.puts(30,200, "(30,200)");
    lcd.puts(30,300, "(30,300)");
    lcd.puts(30,450, "(30,450)");
    lcd.puts(300,200, "(300,200)");
    wait_ms(DELAY_MS);
    
    lcd.cls();
    lcd.foreground(BrightCyan);
    lcd.SetOrientation(RA8875::rotate_180);
    lcd.RenderImageFile(0,82,"/local/Jag.jpg");
    lcd.RenderImageFile(0,160,"/local/Jag.bmp");
    lcd.line(0,0,479,271);
    lcd.line(0,0,271,479);
    lcd.rect(50,50, 80,80);
    lcd.puts(30,30, "(30,30) Normal Landscape");
    lcd.puts(30,90, "(30,90)");
    lcd.puts(30,200, "(30,200)");
    lcd.puts(30,300, "(30,300)");
    lcd.puts(30,450, "(30,450)");
    lcd.puts(300,200, "(300,200)");
    wait_ms(DELAY_MS);

    pc.printf("%d Draw Lines\r\n", __LINE__);
    lcd.SetOrientation(RA8875::rotate_270);
    lcd.cls();
    //lcd.RenderImageFile(0,82,"/local/Jag.jpg");
    //lcd.RenderImageFile(0,160,"/local/Jag.bmp");
    int i;
    point_t p1, p2;
    lcd.foreground(White);
    // From Top-Left
    // Horz
    for (i=10; i<= 250; i+= 10) {
        p1.x = 0; p1.y = p2.x = p2.y = i;
        Emit(__LINE__, p1,p2);
        lcd.line(p1,p2, Red);
    }
    // Vert
    for (i=10; i<= 250; i+= 10) {
        p1.y = 0; p1.x = p2.x = p2.y = i;
        Emit(__LINE__, p1,p2);
        lcd.line(p1,p2, Blue);
    }
    
    //from bottom-right
    // Horz
    for (i=10; i<= 250; i+= 10) {
        p1.x = lcd.width() - 1; p2.x = lcd.width() - 1 - i; p1.y = p2.y = lcd.height() - 1 - i;
        Emit(__LINE__, p1,p2);
        lcd.line(p1,p2, Green);
    }
    // vert
    for (i=10; i<= 250; i+= 10) {
        p1.y = lcd.height() - 1 - i; p2.y = lcd.height() - 1; p1.x = p2.x = lcd.width() - 1 - i;
        Emit(__LINE__, p1,p2);
        lcd.line(p1,p2, Cyan);
    }

    lcd.foreground(BrightRed);
    lcd.SetTextFontFill(NOFILL);
    lcd.line(0,0,479,271, Yellow);
    lcd.line(0,0,271,479, Magenta);
    lcd.rect(50,50, 80,80, Orange);
    lcd.foreground(White);
    lcd.puts(30,30, "(30,30) Normal Landscape");
    lcd.puts(30,90, "(30,90)");
    lcd.puts(30,200, "(30,200)");
    lcd.puts(30,300, "(30,300)");
    lcd.puts(30,450, "(30,450)");
    lcd.puts(300,200, "(300,200)");
    wait_ms(DELAY_MS);
#endif

    while(1) {
        led1 = !led1;
        wait_ms(1000);
    }
}
