//      ______________  ______________  ______________  _______________
//     /_____   _____/ /  ___________/ /  ___________/ /_____   ______/
//          /  /      /  /            /  /                  /  /
//         /  /      /  /___         /  /__________        /  /
//        /  /      /  ____/        /__________   /       /  /
//       /  /      /  /                       /  /       /  /
//      /  /      /  /__________  ___________/  /       /  /
//     /__/      /_____________/ /_____________/       /__/
//

#include "mbed.h"           // v122
#include "RA8875.h"         // test v183, works v179
#include "WebColors.h"
#include <algorithm>

#include "FlashFileSystem.h"
#include "fileimg.h"


FlashFileSystem flash("flash");             // static files here for reliability and speed

// These two defines can be enabled, or commented out
//#define BIG_SCREEN
//#define CAP_TOUCH
#define LCD_C 16         // color - bits per pixel

#ifdef CAP_TOUCH
RA8875 lcd(p5,p6,p7,p12,NC, p9,p10,p13, "tft"); // MOSI,MISO,SCK,/ChipSelect,/reset, SDA,SCL,/IRQ, name
#else
RA8875 lcd(p5,p6,p7,p12,NC, "tft");             //MOSI, MISO, SCK, /ChipSelect, /reset, name
LocalFileSystem local("local");                     // access to calibration file for resistive touch.
#endif

#ifdef BIG_SCREEN
    #define LCD_W 800
    #define LCD_H 480
#else
    #define LCD_W 480
    #define LCD_H 272
#endif



//#define DEBUG "Main"
// ...
// INFO("Stuff to show %d", var); // new-line is automatically appended
//
#if (defined(DEBUG) && !defined(TARGET_LPC11U24))
#define INFO(x, ...) std::printf("[INF %s %4d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[WRN %s %4d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
#define ERR(x, ...)  std::printf("[ERR %s %4d] "x"\r\n", DEBUG, __LINE__, ##__VA_ARGS__);
static void HexDump(const char * title, const uint8_t * p, int count)
{
    int i;
    char buf[100] = "0000: ";

    if (*title)
        INFO("%s", title);
    for (i=0; i<count; ) {
        sprintf(buf + strlen(buf), "%02X ", *(p+i));
        if ((++i & 0x0F) == 0x00) {
            INFO("%s", buf);
            if (i < count)
                sprintf(buf, "%04X: ", i);
            else
                buf[0] = '\0';
        }
    }
    if (strlen(buf))
        INFO("%s", buf);
}
#else
#define INFO(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#define HexDump(a, b, c)
#endif

Serial pc(USBTX, USBRX);
extern "C" void mbed_reset();


typedef struct {
    bool cls;
    loc_t x;
    loc_t y;
    char * filename;
} TestImage_T;

TestImage_T TestImage[] = {
    { true, 0, 0, "/flash/Image_1.jpg"},
    { false, 400, 0, "/flash/Image_2.png"},
    { false, 0, 240, "/flash/Image_3.bmp"},
    { false, 400, 240, "/flash/Image_4.gif"},
    { false, 350, 120, "/flash/Image_5.gif"},
    { false, 350, 340, "/flash/Image_6.ico"},

//    { 0, 0, "/local/01601602.bmp"},
//    { 0, 0, "/local/48027202.bmp"},
//    { 0, 0, "/local/48027204.bmp"},
//    { 0, 0, "/local/48027208.bmp"},
//    { 0, 0, "/local/48027224.bmp"},
//    { 0, 0, "/local/p480272.jpg"},
//    { 0, 0, "/local/p480272.bmp"},
};



int main()
{
    pc.baud(460800);    // I like a snappy terminal, so crank it up!
    pc.printf("\r\nRA8875 Bitmap Test - Build " __DATE__ " " __TIME__ "\r\n");

    lcd.init(LCD_W, LCD_H, LCD_C);
    lcd.Backlight(0.5f);
    
    int count = sizeof(TestImage)/sizeof(TestImage[0]);
    while (1) {
        for (int i=0; i<count; i++) {
            if (TestImage[i].cls)
                lcd.cls();
            printf("RenderBitmapFile(%d, %d, %s) \r\n", TestImage[i].x, TestImage[i].y, TestImage[i].filename);
            RetCode_t r = lcd.RenderImageFile(TestImage[i].x, TestImage[i].y, TestImage[i].filename);
            printf("  returned %d - %s\r\n", r, lcd.GetErrorMessage(r));
            wait(5);
        }
    }
}
