/// @file FreeRunTimer.h is a super-class over the timer class to get a free running value
///
/// This module creates an interface to a free running timer.
///
/// @note Copyright &copr; 2011 by Smartware Computing, all rights reserved.
///     Individuals may use this application for evaluation or non-commercial
///     purposes. Within this restriction, changes may be made to this application
///     as long as this copyright notice is retained. The user shall make
///     clear that their work is a derived work, and not the original.
///     Users of this application and sources accept this application "as is" and
///     shall hold harmless Smartware Computing, for any undesired results while
///     using this application - whether real or imagined.
///
/// @author David Smart, Smartware Computing
///
/// History
/// v0.01 20110724
/// \li initial version
///
#ifndef FREERUNTIMER_H
#define FREERUNTIMER_H

#include "mbed.h"

class FreeRunTimer : public Timer
{
public:
    FreeRunTimer();
    virtual ~FreeRunTimer();
    
    float read();
    uint64_t read_ms();
    uint64_t read_us();
};

#endif 
