/// @file FreeRunTimer.cpp
/// This is the free running timer
///
/// @version 1.0
///
/// @note Copyright &copr; 2011 by Smartware Computing, all rights reserved.
///     Individuals may use this application for evaluation or non-commercial
///     purposes. Within this restriction, changes may be made to this application
///     as long as this copyright notice is retained. The user shall make
///     clear that their work is a derived work, and not the original.
///     Users of this application and sources accept this application "as is" and
///     shall hold harmless Smartware Computing, for any undesired results while
///     using this application - whether real or imagined.
///
/// @author David Smart, Smartware Computing
///
/// @note
/// Version History
/// 20111991
/// \li Adding documentation

#include "mbed.h"
#include "FreeRunTimer.h"

static Timer timer;
static bool init = false;
static float lastTimeValue;
static uint32_t lastTimeValue_ms;
static uint32_t lastTimeValue_us;

static float curTimeValue;
static uint64_t curTimeValue_ms;
static uint64_t curTimeValue_us;

FreeRunTimer::FreeRunTimer() {
    if (!init) {
        timer.start();
        init = true;
        curTimeValue    = lastTimeValue    = timer.read();
        curTimeValue_ms = lastTimeValue_ms = (uint32_t)timer.read_ms();
        curTimeValue_us = lastTimeValue_us = (uint32_t)timer.read_us();
    }
}

FreeRunTimer::~FreeRunTimer() {
}

float FreeRunTimer::read() {
    float now;
    
    __disable_irq();
    now = timer.read();
    curTimeValue += (now - lastTimeValue);
    lastTimeValue = now;
    __enable_irq();
    return curTimeValue;
}

uint64_t FreeRunTimer::read_ms() {
    uint32_t now;
    
    __disable_irq();
    now = (uint32_t)timer.read_ms();
    curTimeValue_ms += (now - lastTimeValue_ms);
    lastTimeValue_ms = now;
    __enable_irq();
    return curTimeValue_ms;
}

uint64_t FreeRunTimer::read_us() {
    uint32_t now;
    
    __disable_irq();
    now = (uint32_t)timer.read_us();
    curTimeValue_us += (now - lastTimeValue_us);
    lastTimeValue_us = now;
    __enable_irq();
    return curTimeValue_us;
}
