//
// EthernetInterface Modifications to enhance it slightly.
//
// This set of modifications integrates with the mbed standard EthernetInterface stack.
// It does require one-line modifications of both EthernetInterface.h and EthernetInterface.cpp.
//
// CAUTION: This works with the LPC1768, but some of the interfaces may be unique to that part.
//
// Two steps integrate this:
//
// STEP 1: edit EthernetInterface.h as follows:
//
//      class EthernetInterface {
//      public:
//          ... normal EthernetInterface APIs
//
            // add this in the public section, at the bottom
//          #include "EthernetInterface_Mods.h" 
//      };
//
// STEP 2: edit EthernetInterface.cpp as follows:
//
//      // add this at the end of the file
//      #include "EthernetInterface_Mods.hxx"
//
#ifndef ETHERNETINTERFACE_MODS_H
#define ETHERNETINTERFACE_MODS_H

//#include "lpc_phy.h"    // needed for is_connected()

/** \brief DP83848 PHY status definitions */
#define DP8_REMOTEFAULT    (1 << 6)   /**< Remote fault */
#define DP8_FULLDUPLEX     (1 << 2)   /**< 1=full duplex */
#define DP8_SPEED10MBPS    (1 << 1)   /**< 1=10MBps speed */
#define DP8_VALID_LINK     (1 << 0)   /**< 1=Link active */


/** setName 
*
* Set the network name for this device. Apply this before
* calling 'connect'.
*
* \example
* EthernetInterface eth;
* ...
*     if (0 == eth.init()) {
*         eth.setName("Sensor 3");
*         if (0 == eth.connect()) {
*             ...
*
* \param myname is the name to assign for this node. 
*        Only the first 32 characters will be used if the 
*        name is longer.
*        Only '0'-'9', 'A'-'Z', 'a'-'z' are accepted,
*        any others are converted to '-'.
* \return 0 on success, a negative number on failure.
*/
static int setName(const char * myname);

/** getName
*
* Get the network name for this device.
*
* \return pointer to the name (or null)
*/
static const char * getName(void);

/** is_connected
*
* Determine if the interface is up and connected.
* 
* \example
*      if (eth.is_connected())
*         ethLED = 1;
*      else
*         ethLED = 0;
*
* \return true if connected, false if not connected.
*/
static bool is_connected(void);

/** get_transmission_status - full or half duplex.
*
* \return 1 = 1/2 (half) duplex, 2 = 2/2 (full) duplex
*/
int get_transmission_status(void);  // 1 = 1/2 duplex, 2 = full duplex

/** get the speed of the connection.
*
* \return 10 or 100 Mb
*/
int get_connection_speed(void);     // 10 or 100 Mb

/** get the current value in the MII data register.
*
* \return mii register value
*/
uint32_t mii_read_data(void);



/** set whether the link signal blinks on traffic, or is steady.
*
* @param[in] BlinkIt when non-zero sets the PHY register accordingly.
*
* @code
* EthernetInterface eth;
* eth.init();
* eth.connect();
* eth.LinkBlinkOnTraffic(1);
* @endcode
*/
void LinkBlinkOnTraffic(int BlinkIt);

#endif // ETHERNETINTERFACE_MODS_H