//
// EthernetInterface Modifications to enhance it slightly.
//
// This set of modifications integrates with the mbed standard EthernetInterface stack.
// It does require one-line modifications of both EthernetInterface.h and EthernetInterface.cpp.
//
// See the details at the top of EthernetInterface_Mods.h
//
#include "lpc_phy.h"

static char myName[33];  // holds the name, when setName() is called.

static bool inRange(char testChar, char minChar, char maxChar)
{
    if (testChar >= minChar && testChar <= maxChar) 
        return true;
    else
        return false;
}

int EthernetInterface::setName(const char * myname) {
    int i;
    
    strncpy(myName, myname, 32);
    myName[32] = '\0';  // be sure it is NULL terminated.
    // make the name 'safe'
    for (i=0; i<32 && myName[i]; i++) {
        if (!inRange(myName[i], '0', '9')
        &&  !inRange(myName[i], 'A', 'Z')
        &&  !inRange(myName[i], 'a', 'z'))
            myName[i] = '-';
    }
    netif_set_hostname(&netif, myName);
    return 0;
}

const char * EthernetInterface::getName(void) {
    return netif_get_hostname(&netif);
}

bool EthernetInterface::is_connected(void) {
    uint32_t tmp = lpc_mii_read_data();
    
    return (tmp & DP8_VALID_LINK) ? true : false;
}

int EthernetInterface::get_transmission_status(void) {  // 1 = 1/2 duplex, 2 = full duplex
    uint32_t tmp = lpc_mii_read_data();
    
    if(tmp & DP8_FULLDUPLEX) {
        return 2;   // "FULL DUPLEX";
    } else {
        return 1;   // "HALF DUPLEX";
    }
}

int EthernetInterface::get_connection_speed(void) {     // 10 or 100 Mb
    uint32_t tmp = lpc_mii_read_data();
    
    return (tmp & DP8_SPEED10MBPS) ? 10 : 100;
}

uint32_t EthernetInterface::mii_read_data(void) {
    return lpc_mii_read_data();  // 16-bit MRDD - address 0x2008 4030
}

void EthernetInterface::LinkBlinkOnTraffic(int BlinkIt)
{
    uint32_t data;
    
    if (lpc_mii_read(0x19, &data) == ERR_OK) {
        data &= ~(1 << 5);      // Mode 2, link status blinks on data
        if (!BlinkIt)
            data |= (1 << 5);   // Mode 1, link status only
        if (lpc_mii_write(0x19, data) != ERR_OK) {
            printf("LED Reconfig attempt failed.\r\n");
        }
    }
}
