/// @file CANQueue.h 
/// The CAN Queue mechanism permits the creation and management of 
/// messages through a CAN queue.
///
/// @todo disable on the relevant interrupts, rather than all when protecting
///       the critical section.
///
/// @note Copyright &copr; 2011 by Smartware Computing, all rights reserved.
///     Individuals may use this application for evaluation or non-commercial
///     purposes. Within this restriction, changes may be made to this application
///     as long as this copyright notice is retained. The user shall make
///     clear that their work is a derived work, and not the original.
///     Users of this application and sources accept this application "as is" and
///     shall hold harmless Smartware Computing, for any undesired results while
///     using this application - whether real or imagined.
///
/// @author David Smart, Smartware Computing
///

// These are needed by this file
#include "CANQueue.h"
//#include "CANUtilities.h"


CANQueue::CANQueue(int Size)
{
    queue = new CANmsg[Size];
    queueSize = Size;
    queueCount = 0;
    queueMaxCount = 0;
    enqueuePosition = 0;
    dequeuePosition = 0;
}


CANQueue::~CANQueue()
{
    delete[] queue;
}


bool CANQueue::Enqueue(CANmsg msg)
{
#if 1
    return Enqueue(&msg);
#else
    queue[enqueuePosition++] = msg;
    enqueuePosition = enqueuePosition % queueSize;
    queueCount++;
    if (queueCount > queueMaxCount) // track the max
        queueMaxCount = queueCount;
    if (queueCount > queueSize)     // just overwrote the oldest
    {
        dequeuePosition++;
        dequeuePosition = dequeuePosition % queueSize;
        queueCount = queueSize;
        return false;
    }
    return true;
#endif
}


bool CANQueue::Enqueue(CANmsg *msg)
{
    bool retval = true;
    
    __disable_irq();
    queue[enqueuePosition++] = *msg;
    enqueuePosition = enqueuePosition % queueSize;
    queueCount++;
    if (queueCount > queueMaxCount) // track the max
        queueMaxCount = queueCount;
    if (queueCount > queueSize)    // just overwrote the oldest
    {
        dequeuePosition++;
        dequeuePosition = dequeuePosition % queueSize;
        queueCount = queueSize;
        retval = false;
    }
    __enable_irq();
    return retval;
}



bool CANQueue::Dequeue(CANmsg *msg)
{
    if (queueCount)
    {
        __disable_irq();
        *msg = queue[dequeuePosition++];
        dequeuePosition = dequeuePosition % queueSize;
        queueCount--;
        __enable_irq();
        return true;
    }
    return false;
}
