/// @file ShowTime.h contains a couple of simple time printing apis
///
/// APIs for showing the time from the RTC, or from a passed in value.
///
/// @note Copyright &copy; 2011 by Smartware Computing, all rights reserved.
/// @author David Smart
///
#ifndef SHOWTIME_H
#define SHOWTIME_H

/// ShowTime prints out the time to the serial console in a usable format
///
/// This prints the passed in, or current time, to the console. It will
/// indicate the time zone offset parameters as well.
///
/// @param tValue is the non-optional time value to convert to friendly time format. If
///     this value is absent or zero, then it will get the system time to convert.
/// @param hOffset is the non-optional hour offset to the local time zone
/// @param mOffset is the non-optional minute offset to the local time zone
/// @returns nothing
///
void ShowTime(time_t tValue, int hOffset, int mOffset);

/// ShowTime prints out the time to the serial console in a usable format
///
/// This prints the current time to the console. It will
/// indicate the time zone offset parameters as well.
///
/// @param hOffset is the optional hour offset to the local time zone
/// @param mOffset is the optional minute offset to the local time zone
/// @returns nothing
///
void ShowTime(int hOffset=0, int mOffset=0);

#endif
