/// @file ShowTime.cpp contains a couple of simple time printing apis
///
/// APIs for showing the time from the RTC, or from a passed in value.
///
/// @note Copyright &copy; 2011 by Smartware Computing, all rights reserved.
/// @author David Smart
///
#include "mbed.h"
#include "ShowTime.h"

static int SignOf(const int i) {
    return (i >= 0) ? 1 : -1;
}

void ShowTime(int hOffset, int mOffset) {
    ShowTime(0, hOffset, mOffset);
}

void ShowTime(time_t tValue, int hOffset, int mOffset) {
    time_t ctTime;
    char timbuf[70];

    if (tValue == 0)
        tValue = time(NULL);
    ctTime = tValue + hOffset * 3600 + SignOf(hOffset) * mOffset * 60;
    strcpy(timbuf, ctime(&ctTime));
    timbuf[strlen(timbuf)-1] = '\0';
    printf("    %s (offset: %02i:%02i)\r\n", timbuf, hOffset, mOffset);
}
